<?php
function renderPage(&$render, $vars, $PHP_SELF) {
	require_once("render/session.php");
	/* Elements of the associative array $vars:
	 * topic: optional, a valid TopicID
	 * roll: optional, a valid RollID
	 * frame: optional, a valid FrameID
	 * search: a list of (space delimited) search terms
	 * action: a database update action */

	$render->htmlStr = "";
	$render->htmlHeader = "";
	$render->onload = "installEvents();";
	$render->scripts[] = "script.js";
	  
	  /* This is not good since at this point, $render->view is not set yet */
	  //    $render->view = $render->build_qs($vars);
	$render->view = "";
	$render->currentTopicID = nil;
	  
	$render->slooze->ct->resetError();

	updateSessionParameters($render,$vars);
	$render->ct->sortMethod = $render->sortMethod;

	/* handle database update actions */
	if (isset($vars['action'])) {
		if ($render->debug) {
			foreach($vars as $name => $value) {
				if (is_array($value))
					echo "$name = [".implode(",",$value)."]<br>";
				else
					echo "$name = $value<br>";
			}
		}

		if ($vars['action']=='remindPassword') {
			return;
		}

		/* if we have just deleted something, */
		/* don't carry on and try to render it */
		$action = $vars['action'];
		if(strstr($action,'delete') 
		   && $action!='deletePicture'
		   && $action!='deleteTopic'
		   && $action!='deleteComment'
		   && $action!='deleteUser'
		   && $action!='deleteGroup') {
			require_once("render/topic.php");
			renderTopic($render,0);
		}
		if ($action=='deletePicture') {
			unset($vars['PictureID']);
		}
	}

	$render->user = &$render->slooze->user;

	$render->ct->authorFilter = $render->authorFilter;

	if (isset($vars['TopicID'])) {
		$render->currentTopicID = $vars['TopicID'];
	}
	if ($render->ct->sortMethod==SORT_TOPICINDEX && 
	    ($render->currentTopicID==nil || $render->currentTopicID==0)) {
		$render->ct->sortMethod = SORT_NONE;
	}

	if (!isset($vars['Start'])) {
		$vars['Start'] = 0;
	}

	if ($render->displayMode=='diaporama') {
		$render->canSelect = false;
	}

	/* render an appropriate page body */
	if (isset($vars['MissingFiles'])) {
		$render->renderMissingFiles();
	} 
	else if (isset($vars['displayPrefs'])) {
		require_once("render/prefs.php");
		$render->show('<div class="normal">');
		renderDisplayPrefsForm($render);
		$render->show('</div>');
	}
	else if (!$render->anonymous && isset($vars['form'])) {
		require("render/navbar.php");
		$render->show('<div class="normal">');
		$render->showSort = false;
		$render->showMode = false;
		$render->showNbThumbs = false;
		$render->showRecursiveTopic = false;
		$form = $vars['form'];
		if ($form == 'addTopic') {
			require_once("render/form_topic.php");
			$render->setView(array('form'=>'addTopic'),true);
			$render->setBareTitle(_("Add album"));
			showFormAddTopic($render,true,$vars['ParentTopicID']);
		} else  if ($form == 'addUser') {
			$render->show('<div class="normal">');
			$render->setView(array('form'=>'addUser'),true);
			$render->setBareTitle(_("Add user"));
			showFormAddUser();
			$render->show("</div>");
		} else  if ($form == 'upload') {
			require_once("render/upload.php");
			$params = array();
			if (isset($vars['TopicID']))
				$params['TopicID'] = $vars['TopicID'];
			if (isset($vars['RollID']))
				$params['RollID'] = $vars['RollID'];
			renderUploadForms($render,$params);
		} else  if ($form == 'addImage') {
			$render->renderAddPicture();
		} else  if ($form == 'sendMail') {
			require_once("render/sendmail.php");
			showFormSendMail($render);
		} else  if ($form == 'addKeywordType') {
			require_once("render/form_keyword.php");
			$render->showFormAddKeywordType();
		} else  if ($form == 'updateDates') {
			$render->slooze->updateDates();
		} else  if ($form == 'updateDisplayRatios') {
			$render->slooze->updateDisplayRatios();
		} else {
			$render->error("Unknown form : $form");
		}
		$render->show('<hr>');
		require_once("render/admin.php");
		showFormAdminActions($render);
		$render->show('</div>');
		showNavBar($render);
	}
	else if (isset($vars['Topics'])) {
		require_once("render/topics.php");
		renderTopics($render);
	}	
	else if (isset($vars['Users'])) {
		require_once("render/users.php");
		renderUsers($render);
	}	
	else if (isset($vars['MyRolls'])) {
		require_once("render/rolls.php");
		renderRolls($render);
	}	else if (isset($vars['Searchs'])) {
		require_once("render/form_search.php");
		renderSearchs($render);
	}	
	else if (isset($vars['Preferences'])) {
		require_once("render/user.php");
		require_once("render/navbar.php");
		showFormUserPrefs($render,$render->user);
		showNavBar($render);
	}	
	else if (isset($vars['MyGroups'])) {
		require_once("render/groups.php");
		renderGroups($render);
	}	
	else if (isset($vars['TopicID']) && isset($vars['Position'])) {
		require_once("render/topic.php");
		renderPictureInTopic(
			$render,
			$vars['PictureID'],
			$vars['TopicID'], 
			$vars['Position']);
	}
	else if (isset($vars['RollID']) && isset($vars['Position'])) {
		require_once("render/roll.php");
		renderPictureInRoll(
			$render,
			$vars['PictureID'],
			$vars['RollID'], 
			$vars['Position']);
	}
	else if (isset($vars['RollID']) && isset($vars['PictureID'])) {
		require_once("render/roll.php");
		renderPictureInRoll(
			$render,
			$vars['PictureID'],
			$vars['RollID'], 
			'');
	}
	else if (isset($vars['Keyword']) && isset($vars['TypeID']) &&
			 isset($vars['Position'])) {
		require_once("render/search.php");
		renderPictureInKeywordSearch(
			$render,
			$vars['PictureID'],
			$vars['Keyword'], $vars['TypeID'], 
			$vars['Position']);
	}
	else if (isset($vars['RateSort']) && isset($vars['Position'])) {
		require_once("render/ratesort.php");
		renderPictureInRateSort(
			$render,
			$vars['PictureID'],
			$vars['Position']);
	}
	else if (isset($vars['DateSort']) && isset($vars['Position'])) {
		require_once("render/datesort.php");
		renderPictureInDateSort(
			$render,
			$vars['PictureID'],
			$vars['Position']);
	}
	else if (isset($vars['Unindexed']) && isset($vars['Position'])) {
		require("render/unindexed.php");
		renderPictureInListUnindexed(
			$render,
			$vars['PictureID'],
			$vars['Position']);
	}
	else if (isset($vars['Unrated']) && isset($vars['Position'])) {
		require("render/unrated.php");
		renderPictureInListUnrated(
			$render,
			$vars['PictureID'],
			$vars['Position']);
	}
	else if (isset($vars['Selected']) && isset($vars['Position'])) {
		require("render/selected.php");
		renderPictureInListSelected(
			$render,
			$vars['PictureID'],
			$vars['Position']);
	}
	else if (isset($vars['SimilarPictures']) && isset($vars['Position'])) {
		require("render/similar.php");
		renderPictureInSimilarPictures(
			$render,
			$vars['PictureID'],
			$vars['SimilarPictures'],
			$vars['Position']);
	}
	else if(isset($vars['Search']) && isset($vars['PictureID']) 
			&& isset($vars['Position'])) {
		require("render/search.php");
		renderPictureInSearch(
			$render,
			$vars['PictureID'],
			$vars['Search'],
			$vars['Position']);
	}
	else if (isset($vars['Keywords']) && isset($vars['PictureID']) && 
			 isset($vars['Position'])) {
		require_once("render/search.php");
		renderPictureInMultipleKeywordSearch(
			$render,
			$vars['PictureID'],
			split("[ ,]",$vars['Keywords']),
			$vars['MatchAll']=='true',
			$vars['Position']);
	}
	else if(isset($vars['Keyword']) && isset($vars['TypeID'])) {
		require_once("render/search.php");
		renderKeywordSearch(
			$render,
			$vars['TypeID'],
			$vars['Keyword'],
			$vars['Start']);
	}
	else if (isset($vars['Keywords'])) {
		require_once("render/search.php");
		renderMultipleKeywordSearch(
			$render,
			split("[, ]",$vars['Keywords']),
			$vars['MatchAll']=='true',
			$vars['Start']);
	}
	else if (isset($vars['TopicID'])) {
		require_once("render/topic.php");
		renderTopic($render,$vars['TopicID'],$vars['Start']);
	}
	else if (isset($vars['RollID'])) {
		require_once("render/roll.php");
		renderRoll($render,$vars['RollID'],$vars['Start']);
	}
	else if (isset($vars['GroupID'])) {
		require_once("render/groups.php");
		renderGroup($render,$vars['GroupID']);
	}
	else if (isset($vars['UserID'])) {
		require_once("render/user.php");
		renderUser($render,$vars['UserID']);
	}
	else if (isset($vars['Search'])) {
		require_once("render/search.php");
		renderSearch($render,$vars['Search'],$vars['Start']);
	}
	else if (isset($vars['KeywordSort'])) {
		require_once("render/search.php");
		renderKeywordSort($render,$vars['TypeID']);
	}
	else if (isset($vars['Unindexed'])) {
		require_once("render/unindexed.php");
		renderUnindexed($render,$vars['Start']);
	}
	else if (isset($vars['Unrated'])) {
		require_once("render/unrated.php");
		renderUnrated($render,$vars['Start']);
	}
	else if (isset($vars['Selected'])) {
		require_once("render/selected.php");
		renderSelected($render,$vars['Start']);
	}
	else if (isset($vars['DateSort'])) {
		require_once("render/datesort.php");
		renderDateSort($render,$vars['Start']);
	}
	else if (isset($vars['RateSort'])) {
		require_once("render/ratesort.php");
		renderRateSort($render,$vars['Start']);
	}
	else if (isset($vars['SimilarPictures'])) {
		require_once("render/similar.php");
		renderSimilarPictures($render,$vars['SimilarPictures'],$vars['Start']);
	}
	else if (isset($vars['PictureID'])) {
		require_once("render/picture.php");
		renderPicture($render,$vars['PictureID']);
	}
	else {
		/* default action is render top-level topics */
		if (!isset($vars['Start'])) {
			$vars['Start'] = 0;
		}
		require_once("render/topic.php");
		renderTopic($render,0,$vars['Start']);
	}

	if ($render->displayMode!='diaporama') {
		require_once("render/footer.php");
		showFooter($render);
	}

	$render->show('</div>'); // this is the class=main
	$render->includeJavaScript("wz_tooltip.js");
	
	if ($render->displayMode=='diaporama') {
		$interval = $render->user['PictureInterval'] ? $render->user['PictureInterval'] : 10;
		$render->startJavaScript();
		$render->show("diaporama=true;".
					"setTimeout('gotoLink(\'next\')',".($interval*1000).");");
		$render->endJavaScript();
	}
	if ($render->keywordScript) {
		$render->startJavaScript();
		$topics = $render->ct->getTopicsOfPicture($render->keywordScript,$render->uid);
		$keywords = array();
		foreach ($topics as $topic) {
			$keywords = array_merge(
				$keywords,
				$render->ct->getTopicKeywordValues($topic['TopicID']));
			$keywords = array_unique($keywords);
		}
		$keywords = array_map("quote",$keywords);
		$render->show('var keywords = new Array(',false);
		$render->show(implode(",",$keywords),false);
		$render->show(');');
		$render->endJavaScript();
		$render->includeJavaScript("keyword.js");
	}

	$render->show('<iframe id="RSIFrame" name="RSIFrame"></iframe>');
	$render->show('</body>');
	$render->show('</html>');
	
	$render->showInHeader = true;
	$render->showHeader();

	if ($render->displayMode!='diaporama') {
		require_once("render/header.php");
		showTop($render);
		// calculte the size of the top bar
		if ($render->showMode || $render->showNbThumbs || 
		    $render->showSort || $render->showRecursiveTopic) {
			$top = 83;
		} else {
			$top = 61;
		}
		if ($render->topTitle=="") {
			$top -= 27;
		}
	} else {
		$top = 0;
	}

	$user_agent = $_SERVER['HTTP_USER_AGENT'];
	if (!ereg("MSIE",$user_agent)) {
		$navTop = $top + 12;
		$render->style .= "#nav {top: {$navTop}px;}\n";
	}

	if (ereg("MSIE",$user_agent)) {
		$render->showH('<div id="main">');
	} else {
		$navTop = $top + 12;
		$render->style .= "#nav {top: {$navTop}px;}\n";
		$render->showH('<div id="main" style="top: '.$top.'px;">');
	}
	echo $render->htmlHeader;
	$render->showMessages();
	echo $render->htmlStr;
}

function renderMessagePage(&$render) {
	require_once("render/header.php");
	require_once("render/footer.php");
	require_once("render/navbar.php");

	$render->setNoDisplayPrefs();
	// calculte the size of the top bar
	if ($render->showMode || $render->showNbThumbs || 
	    $render->showSort || $render->showRecursiveTopic) {
		$top = 83;
	} else {
		$top = 61;
	}
	if ($render->topTitle=="") {
		$top -= 27;
	}

	$user_agent = $_SERVER['HTTP_USER_AGENT'];
	if (!ereg("MSIE",$user_agent)) {
		$navTop = $top + 12;
		$render->style .= "#nav {top: {$navTop}px;}\n";
	}

	$render->showInHeader=true;
	$render->showHeader();
	showTop($render);

	if (ereg("MSIE",$user_agent)) {
		$render->showH('<div id="main">');
	} else {
		$render->showH('<div id="main" style="top: '.$top.'px;">');
	}
	$render->showInHeader=false;
	showNavBar($render);
	showFooter($render);
	$render->show('</div>'); // this is the class=main
	$render->show('</body>');
	$render->show('</html>');

	echo $render->htmlHeader;
	$render->showMessages();
	echo $render->htmlStr;
}
?>