<?php
function renderSearchs(&$render) {
	require_once("render/navbar.php");
	$render->setView(array('Searchs'=>''),true);
	$render->htmlTitle = _("Search");
	$render->setBareTitle(_("Search"));
	$render->show('<div class="normal">');
	showNavBar($render);
	showFormSearch($render);
	showFormMultipleKeywordSearch($render);
	showFormKeywordSort($render);
	$render->show("</div>");
}

/** show a search form */
function showFormSearch(&$render) {
	require_once("render/form_elements.php");
	$render->show('<h2>'._('Title search').'</h2>');
	showFormElementStart($render,true,'get');
	showFormElementSearch($render,'Search');
	showFormElementEnd($render,_('Search'));
}

/** show a search form */
function showFormMultipleKeywordSearch(&$render) {
	require_once("render/form_elements.php");
	$render->show('<h2>'._('Keyword search').'</h2>');
	showFormElementStart($render,true,'get');
	showFormElementSearch($render,'Keywords');
	showFormBooleanField($render,'MatchAll',_('Match all'),true);
	showFormElementEnd($render,_('Search'));
}

function showFormKeywordSort(&$render) {
	require_once("render/form_elements.php");
	require_once("render/form_keyword.php");
	$render->show('<h2>'._('Keyword sort').'</h2>');
	showFormElementStart($render,true,'get');
	showFormElementTypeSelector($render);
	showFormElementHidden($render,'KeywordSort');
	showFormElementEnd($render,_('Sort'));
}

  
/** Show search form element */
function showFormElementSearch(&$render,$name) {
	$render->show("<input type=\"text\" name=\"$name\">");
}

function showFormDateSort(&$render) {
	$render->show("<h2><a href=\"".$render->selfURL("DateSort=yes")."\">".
				_('Sort by entry date (show more recent pictures first)').'</a></h2>');
}

function showFormRateSort(&$render) {
	$render->show("<h2><a href=\"".$render->selfURL("RateSort=yes")."\">".
				  _('Sort by average rating').'</a></h2>');
}
?>