<?php
/* information to show at the bottom of the page */
function showFooter(&$render) {
	$querystring = $render->view;
	if ($querystring!="") {
		$querystring = "?" . $querystring;
	}
    
	$render->show('<div class="footer">');
	$render->show('<p>',false);
	if ($render->anonymous) {
		$render->show(sprintf(_("You are not logged in, so you may not see all the pictures. If you have an account on this system, please <a href=\"%s\">login</a> and you will see them."),
							$render->actionAndViewURL("again=yes")));
	} else {
		$render->show(_('Hello')." ".$render->user['Name'], false);
	}
	$render->show('</p>');
	$render->show(
		'<p>'.
		sprintf(_("Please <a href=\"mailto:%s\">report any problem</a> you may encounter."),
				$render->slooze->admin_email).'</p>');
	$render->show(
		'<p>powered by <a href="http://www.bearteam.org/tof/">TOF</a> '.
		$render->version.'</p>');
	$render->show(
		'<p>'.
		sprintf(_('This page should be %s compliant'),
				'<a href="http://validator.w3.org/check/referer">HTML 4.01</a>').
		'</p>');
	global $timer,$sqlTimer;
	$render->show('<p>'.
				sprintf(_('Page generated in %ss (SQL: %ss)'),
						$timer->stopShow(),
						$sqlTimer->show()).
				", ".
				sprintf(_('memory usage: %s (max %s)'),
						makeSizeString(memory_get_usage()),
						function_exists('memory_get_maxusage') ? makeSizeString(memory_get_maxusage()):'???').
				'</p>');
	$render->show('</div>');
}
?>