<?php
function renderBook(&$render,$bookID,$book,$start) {
	require_once("render/nav.php");
	require_once("render/navbar.php");
	require_once("render/header.php");
	$render->count = $render->ct->getPageCount($bookID);
	$render->htmlTitle = $book['Description'].countString($render,$start,$render->count);
	// header
	$render->topTitle = $book['Description'].countString($render,$start,$render->count);

	$render->show('<div class="normal">');

	$upLink = "TopicID=".$book['ParentTopicID'];
	$parentTopic = $render->ct->getTopic($book['ParentTopicID']);
	$upTitle = $parentTopic['Description'];

	showPages(
		$render,
		$bookID,$start,$render->count,
		$upLink,$upTitle);

	// other
	showNav($render,$bookID);

	if (!$render->anonymous) {
		require_once("render/actions.php");
		$render->show('<p>',false);
		showLink(
			$render,
			_('Gen PDF'),'genBookPdf',_('Generate a PDF file'),
			array('TopicID'=>$bookID,
				  'Quality'=>HIGH));
		$render->show('</p>');
	}
	if ($render->admin) {
		require_once("render/form_topic.php");
		$perms = $render->ct->getTopicPerms($bookID,$render->uid);
		$book = $render->ct->getTopic($bookID);
		if ($render->uid==1 || in_array(WRITE,$perms) || in_array(OWNER,$perms)) {
			$pictures = $render->ct->getPicturesInTopic(
				$bookID,false,$render->uid,0,-1,$count);
			pictureList($render,$pictures);
			showFormAddPage($render,$book);
			showFormEditImage($render,$bookID);
			showFormEditText($render,$bookID);
			showFormEditPage($render,$bookID);
		}
	}
	$render->show("</div>");
}

function showPages(
	&$render,
	$bookID, $start, $nbTotPictures, 
	$upLink="", $upTitle="") 
{
	$count = $render->nbThumbsPerPage;
	$links = array();

	$render->links['home'] = $render->selfURL();
	$links[] = array('URL'=>$render->links['home'],
					 'Title'=>_('Home').' (S-h)',
					 'Img'=>'Home.png');

	// First and previous links
	$first = array('Title'=>_('First').' (S-f)',
				   'Img'=>'First.png');
	$prev = array('Title'=>_('Previous').' (S-p)',
				  'Img'=>'Back.png');
	if ($start>0) {
		$render->links['prev'] = $render->selectURL("Start=".max($start-$count,0));
		$render->links['first'] = $render->selectURL("Start=0");
		$first['URL'] = $render->links['first'];
		$prev['URL'] = $render->links['prev'];
	}
	$links[] = $first;
	$links[] = $prev;
		  
	// Up link
	$up = array('Title'=>_('Up').' (S-u)',
				'Img'=>'Up.png');
	if ($upLink!='') {
		$render->links['up'] = $render->selfURL($upLink);
		$up['URL'] = $render->links['up'];
	}
	$links[] = $up;

	// Next and last links
	$last = array('Title'=>_('Last').' (S-l)',
				  'Img'=>'Last.png');
	$next = array('Title'=>_('Next').' (S-n)',
				  'Img'=>'Forward.png');
	if ($count>0 && $start+$count<$nbTotPictures) {
		$render->links['next'] = 
			 $render->selectURL("Start=".($start+$count));
		$render->links['last'] = 
			 $render->selectURL("Start=".
							  (int)(($nbTotPictures-1)/$count)*$count);
		$next['URL'] = $render->links['next'];
		$last['URL'] = $render->links['last'];
	}
	$links[] = $next;
	$links[] = $last;
	showNavBar($render,$links);

	//$render->getUserSelection();
	$render->stylesheets[] = "book.css";
	if ($render->admin) {
		$render->scripts[] = "book.js";
	}

	if ($count>0)
		$render->show('<p>'._('Click on a page to edit it.').'</p>');
	$render->show('<div class="pages">');
	for ($i=0; $i<$count && $start+$i<$nbTotPictures; $i++) {
		showPage($render,$bookID,$start+$i);
		if ((($start+$i) % 2) ==1)
			$render->show('<hr class="transpa">');
	}
	$render->show('<br style="clear: both"/>');
	$render->show('</div>');

	if ($render->admin) {
		$render->show(
			'<div id="selection" style="display: none">'.
			'<div class="handleTop"></div><div class="handleBottom"></div>'.
			'<div class="handleRight"></div><div class="handleLeft"></div></div>');
		$render->showJavaScript(
			"installPageEvents(document,'img');\n".
			"installPageEvents(document,'div');\n".
			"initSelFrame();\n".
			"selFrame = getElt('selection');");
	}
}

function showPage(&$render,$bookID, $num) {
	require_once("render/actions.php");

	// The float way
	$render->show('<div class="pbox">');
	$render->show('<div class="move">',false);
	if ($num>0) 
		showLink(
			$render,
			'<','movePageUp',_('move up'),
			array('_PageNum'=>$num,'_TopicID'=>$bookID));
	if ($num<($render->count-1))
		showLink(
			$render,
			'>','movePageDown',_('move down'),
			array('_PageNum'=>$num,'_TopicID'=>$bookID));
	$render->show('</div>'); // move
	  
	if ($render->admin) {
		$page = $render->ct->getPage($bookID,$num);
		showEditablePage($render,$page);
	} else {
		$render->show(
			sprintf('<img class="page" src="%s" alt="%s">',
					$render->urlWithParams(
						"bookpage.php",
						array('TopicID'=>$bookID,
							  'PageNum'=>$num,
							  'Quality'=>1)),
					"page $num"));
	}
	$render->show('</a>');
	$render->show('<div class="desc">'.$num.'</div>');
	$render->show("</div>"); // page
}

/**
 * Render a page, using a separate IMG for each element 
 */ 
function showEditablePage(&$render,$page) {
	$scale = $render->pageScale;
	$render->show(
		sprintf('<div class="page" id="p%d" style="width: %spx; height: %spx">',
				$page['PageNum'],
				px($page['Width'],$scale),
				px($page['Height'],$scale)));
	if (is_array($page['Images'])) {
		foreach($page['Images'] as $image) {
			showImageElement($render,$image);
		}
	}
	if (is_array($page['Texts'])) {
		foreach($page['Texts'] as $text) {
			showTextElement($render,$text);
		}
	}
	$render->show('</div>');
	$render->startJavaScript();
	$render->show("texts[${page['PageNum']}] = new Array();");
	if (is_array($page['Texts'])) {
		foreach($page['Texts'] as $text) {
			$b = $text['Box'];
			$data = addslashes($text['Text']);
			$render->show(
				"texts[${page['PageNum']}][${text['Id']}] =".
				" new Text(${text['Id']},'$data',".
				"${b['top']},${b['left']},${b['bottom']},${b['right']},".
				"'${text['Font']}',${text['Size']},'${text['Align']}');");
		}
	}	
	$render->show("images[${page['PageNum']}] = new Array();");
	if (is_array($page['Images'])) {
		foreach($page['Images'] as $image) {
			$b = $image['Box'];
			$render->show(
				"images[${page['PageNum']}][${image['Id']}] =".
				" new Image(${image['Id']},${image['PictureID']},".
				"${b['top']},${b['left']},${b['bottom']},${b['right']},".
				"${image['halign']},${image['valign']});");
		}
	}
	$render->endJavaScript();
}

function showImageElement(&$render,&$image) {
	require_once("render/layout.php");
	$pos = getPicturePos($render->slooze,$image);

	$box = $image['Box'];

	$scale = $render->pageScale;
	$render->show(
		sprintf('<div '.
				' style="width:%spx; height:%spx; bottom: %spx; left: %spx;"'.
				' id="i%d" class="image">',
				px($box['width'],$scale),
				px($box['height'],$scale),
				px($box['bottom'],$scale),
				px($box['left'],$scale),
				$image['Id']));
	$render->show(
		sprintf('<img src="%s" '.
				' style="width: %s%%; height: %s%%; bottom: %s%%; left: %s%%;">',
				$render->urlWithParams(
					'picture.php',
					array('PictureID'=>$image['PictureID'],
						  'Size'=>'medium')),
				// do not use round(width*scale) because it can be off by one
				number_format(100*$pos['width']/$box['width'],2),
				number_format(100*$pos['height']/$box['height'],2),
				//round($pos['right']*$scale)-round($pos['left']*$scale),
				//round($pos['top']*$scale)-round($pos['bottom']*$scale),
				number_format(100*($pos['bottom']-$box['bottom'])/$box['height'],2),
				number_format(100*($pos['left']-$box['left'])/$box['width'],2)));
				//round($pos['bottom']*$scale),
				//round($pos['left']*$scale)));
	$render->show('</div>');
}

function showTextElement(&$render,&$text) {
	$scale = $render->pageScale;
	$box = $text['Box'];
	$render->show(
		sprintf('<img src="%s" '.
				' style="width:%dpx; height:%dpx; bottom: %dpx; left: %dpx;"'.
				' id="t%d" class="text">',
				$render->urlWithParams(
					'textelement.php',
					array('TopicID'=>$text['TopicID'],
						  'PageNum'=>$text['PageNum'],
						  'Id'=>$text['Id'],
						  // since we map points to pixels, we have 72px/inch
						  'Density'=>number_format(72*$scale,2,'.',''))),
				px($box['width'],$scale),
				px($box['height'],$scale),
				px($box['bottom'],$scale),
				px($box['left'],$scale),
				$text['Id']));
}

function px($pt,$scale) {
	return number_format($pt*$scale,2,'.','');
}

function showFormAddPage(&$render,$book) {
	require_once("render/form_elements.php");
	require_once("render/form_topicid.php");
	$render->show('<h2>'._('Add page').'</h2>');
	$topicID = $book['TopicID'];
	showFormElementStart($render);
	showFormElementTopicID($render,$topicID);
	showFormElementAction($render,'addPage');
	showFormElementEnd($render,_('Add page'));
}

function halignEditor(&$render,$label,$name) {
	$render->show($label.' ',false);
	$alignments = array(
		'0.5'=>_('center'),
		'1' => _('right'),
		'0' => _('left'));
	showFormElementSelect($render,$name,$alignments,'0.5');
}

function valignEditor(&$render,$label,$name) {
	$render->show($label.' ',false);
	$alignments = array(
		'0.5'=>_('center'),
		'1' => _('top'),
		'0' => _('bottom'));
	showFormElementSelect($render,$name,$alignments,'0.5');
}

function boxEditor(&$render,$box=nil) {
	$render->show(_('top').': ',false);
	showFormElementInteger(&$render,'Top',$box!=nil?$box['top']:842,4,false);
	$render->show(_('left').': ',false);
	showFormElementInteger(&$render,'Left',$box!=nil?$box['left']:0,4);
	$render->show(_('bottom').': ',false);
	showFormElementInteger(&$render,'Bottom',$box!=nil?$box['bottom']:0,4,false);
	$render->show(_('right').': ',false);
	showFormElementInteger(&$render,'Right',$box!=nil?$box['right']:595,4);
}

function showFormRemovePageElement(&$render,$bookID) {
	showFormElementStart($render);
	showFormElementHidden($render,'TopicID',$bookID);
	showFormElementHidden($render,'PageNum','');
	showFormElementHidden($render,'Id','');
	showFormElementAction($render,'removePageElement');
	showFormElementEnd($render,_('Remove'));
}

function showFormEditImage(&$render,$bookID) {
	require_once("render/form_elements.php");
	$render->show('<div class="forms formRight" id="formEditImage">');
	$render->show('<h2>'._('Edit image').'</h2>');

	showFormElementStartRPC($render);
	imageElementEditors($render,$bookID);
	showFormElementAction($render,'updateImageElement');
	showFormElementEnd($render,_('Update'));

	showFormRemovePageElement($render,$bookID);
	$render->show('</div>');
}

function textAlignEditor(&$render,$label,$name) {
	$render->show($label.' ',false);
	$alignments = array(
		'C'=>_('center'),
		'R' => _('right'),
		'L' => _('left'));
	showFormElementSelect($render,$name,$alignments);
}

function fontEditor(&$render,$label,$name) {
	$render->show($label.' ',false);
	$fonts = array(
		'Helvetica'=>'Helvetica',
		'Times-Roman' => 'Times',
		'Courier' => 'Courier');
	showFormElementSelect($render,$name,$fonts);
}

function showFormEditText(&$render,$bookID) {
	require_once("render/form_elements.php");
	$render->show('<div class="forms formRight" id="formEditText">');
	$render->show('<h2>'._('Edit text').'</h2>');
	showFormElementStartRPC($render);
	textElementEditors($render,$bookID);
	showFormElementAction($render,'updateTextElement');
	showFormElementEnd($render,_('Update'));
	showFormRemovePageElement($render,$bookID);
	$render->show('</div>');
}

function imageElementEditors(&$render,$bookID) {
	showFormElementHidden($render,'TopicID',$bookID);
	showFormElementHidden($render,'PageNum','');
	showFormElementHidden($render,'Id','');
	showFormElementHidden($render,'Scale',$render->pageScale);
	pictureSelector($render);
	halignEditor($render,_('Horizontal alignment'),'halign');
	$render->show('<br>');
	valignEditor($render,_('Vertical alignment'),'valign');
	$render->show('<br>');
	boxEditor($render);
	$render->show('<br>');
}

function textElementEditors(&$render,$bookID) {
	showFormElementHidden($render,'TopicID',$bookID);
	showFormElementHidden($render,'PageNum','');
	showFormElementHidden($render,'Id','');
	showFormElementTextArea($render,'Text','');
	showFormElementHidden($render,'Scale',$render->pageScale);
	textAlignEditor($render,_('Alignment'),'Align');
	$render->show('<br>');
	fontEditor($render,_('font'),'Font');
	$render->show(_('size').' ');
	showFormElementInteger($render,'Size',12);
	$render->show('<br>');
	boxEditor($render);
}

function showFormEditPage(&$render,$bookID) {
	require_once("render/form_elements.php");
	$render->show('<div class="forms formRight" id="formEditPage">');

	$render->show('<h2>'._('Add image').'</h2>');
	showFormElementStart($render,false,'post','','addImageElement');
	imageElementEditors($render,$bookID);
	showFormElementAction($render,'addImageElement');
	showFormElementEnd($render,_('Add'));

	$render->show('<h2>'._('Add text').'</h2>');
	showFormElementStart($render,false,'post','','addTextElement');
	textElementEditors($render,$bookID);
	showFormElementAction($render,'addTextElement');
	showFormElementEnd($render,_('Add'));

	$render->show('<h2>'._('Remove page').'</h2>');
	showFormElementStart($render);
	showFormElementHidden($render,'TopicID',$bookID);
	showFormElementHidden($render,'PageNum','');
	showFormElementAction($render,'removePage');
	showFormElementEnd($render,_('Remove'));

	$render->show('</div>');
}

/*
function pictureSelector(&$render,$pictures) {
	$render->show('<div class="pictureSelector">');
	foreach($pictures as $picture) {
		$render->show(
			'<label><input type="radio" name="PictureID" value="'.
			$picture['PictureID'].'" onchange="pictureSelectorChanged(this)">',false);
		showThumbPicture($render,$picture,0.4);
		$render->show('</label>');
	}
	$render->show('</div>');
}
*/

function pictureSelector(&$render,$picture=false) {
	$render->show('<div class="pictureSelector" onclick="openPictureSelector(this);">');
	if ($picture)
		showThumbPicture($render,$picture,0.4);
	else 
		// We must not use src="" because it would refer to the current document
		// See RFC2396 par4.2
		$render->show('<img alt="">');
	showFormElementHidden($render,'PictureID',$picture['PictureID']);
	$render->show('</div>');
}

function pictureList(&$render,&$pictures) {
	$render->show('<div id="pictureList">');
	$render->show('<span class="button" onclick="hideBlock(\'pictureList\')">'._('Cancel').'</span>');
	foreach($pictures as $picture) {
		showThumbPicture($render,$picture,0.4);
	}
	$render->show('</div>');
}

function showThumbPicture(&$render,$picture,$scale) {
	require_once("render/tooltip.php");

	$fileName = $render->slooze->getThumbFilename($picture);
	if (file_exists($fileName)) {
		/* make img tag with size and caption plus a link to the fullsize picture */
		$size = GetImageSize($fileName);
		$tooltip = getToolTip($render,$picture);
		$width = number_format($size[0]*$scale);
		$height = number_format($size[1]*$scale);
		$render->show(
			"<img id=\"pic${picture['PictureID']}\" src=\"".$render->url("picture.php?PictureID=".$picture['PictureID']).
			"&amp;Size=thumb\" width=\"$width\" height=\"$height\"".
			" alt=\"${picture['Description']}\">",false);
	} else {
		$render->error(
			"<a href=\"" .
			$render->selectURL("PictureID=".$picture['PictureID'].
							   $render->output_separator."Position=$position").
			"\">".sprintf(_('File not found : %s'),$fileName)."</a>");
	}
}
?>