-- TABLES

CREATE TABLE params (
       Name varchar PRIMARY KEY, 
       Value varchar);

CREATE TABLE users (
	UserID serial PRIMARY KEY,
	Name character varying(255),
	Email character varying(255),
	SelfGroup integer,
	Upload boolean NOT NULL default false,
	Selection boolean NOT NULL default true,
	Admin boolean NOT NULL default false,
	NotifyComment boolean NOT NULL default false,
	DiskUsage bigint NOT NULL default 0,
	PictureSize character varying(20),
	PictureInterval integer,
	username character varying(64) NOT NULL UNIQUE,
	password character varying(64) NOT NULL);

CREATE TABLE groups (
	GroupID serial PRIMARY KEY,
	Name character varying(255),
	Owner integer NOT NULL REFERENCES users ON DELETE cascade);
CREATE INDEX groups_owner ON groups (owner);

ALTER TABLE users ADD CONSTRAINT fkey_selfgroup 
	FOREIGN KEY (SelfGroup) REFERENCES groups DEFERRABLE INITIALLY DEFERRED;

CREATE TABLE rolls (
	RollID character varying(64) PRIMARY KEY,
	Owner integer NOT NULL REFERENCES users ON DELETE cascade);

CREATE TABLE topics (
	TopicID serial PRIMARY KEY,
	ParentTopicID integer REFERENCES topics,
	Description character varying(255),
	Summary character varying(255),
	Book boolean NOT NULL DEFAULT false,
	Width smallint,
	Height smallint);

CREATE TABLE pages (
	TopicID integer NOT NULL REFERENCES topics,
	PageNum smallint NOT NULL,
	PRIMARY KEY (TopicID,PageNum));

CREATE VIEW pages_view AS 
	SELECT pages.*,topics.width,topics.height 
		FROM pages JOIN topics USING(TopicID);

CREATE TABLE pageelements (
	TopicID integer,
	PageNum smallint,
	Id smallint,
	Box box NOT NULL,
	PRIMARY KEY (TopicID,PageNum,Id),
	FOREIGN KEY (TopicID,PageNum) REFERENCES pages 
		ON DELETE cascade DEFERRABLE INITIALLY DEFERRED);

CREATE TABLE textelements (
	Text character varying,
	Size smallint,
	Font character varying,
	Align character
       ) INHERITS (pageelements);

CREATE TABLE topicperms (
       TopicID integer NOT NULL REFERENCES topics ON DELETE CASCADE,
       GroupID integer NOT NULL REFERENCES groups ON DELETE CASCADE,
       Access character,
       PRIMARY KEY (TopicID,GroupID,Access));

CREATE TABLE pictures (
	PictureID serial PRIMARY KEY,
	RollID character varying(64) NOT NULL REFERENCES rolls ON DELETE CASCADE,
	FrameID character varying(64) NOT NULL,
	Description character varying(255),
	Filename character varying(255),
	DisplayRatio float,
	Owner integer NOT NULL REFERENCES users,
	EntryDate timestamp DEFAULT now(),
	Date timestamp,
	NbClick integer DEFAULT 0,
	NbRates integer DEFAULT 0,
	MaxRate int2,
	MinRate int2,
	AverageRate float4 DEFAULT 5,
	SumRates integer DEFAULT 0);
CREATE INDEX pictures_rollid ON pictures (RollID);
CREATE INDEX pictures_date ON pictures (Date);
CREATE INDEX pictures_owner ON pictures (owner);

CREATE TABLE imageelements (
	PictureID integer REFERENCES pictures,
	HAlign float DEFAULT 0.5,
	VAlign float DEFAULT 0.5
       ) INHERITS (pageelements);


CREATE TABLE topicscontent (
	TopicID integer REFERENCES topics ON DELETE cascade,
	PictureID integer REFERENCES pictures ON DELETE cascade,
	Index integer,
	Direct boolean NOT NULL,
	PRIMARY KEY (TopicID,PictureID) );
CREATE INDEX topicscontent_topicid ON topicscontent (TopicID);
CREATE INDEX topicscontent_pictureid ON topicscontent (PictureID);

CREATE TABLE topicsfrontpage (
	TopicID integer REFERENCES topics ON DELETE cascade,
	PictureID integer REFERENCES pictures ON DELETE cascade,
	FOREIGN KEY (topicid,pictureid) REFERENCES topicscontent(topicid,pictureid),
	PRIMARY KEY (TopicID,PictureID) );

CREATE TABLE comments (
	CommentID character varying(64) NOT NULL PRIMARY KEY,
	PictureID integer NOT NULL REFERENCES pictures ON DELETE cascade,
	Comment character varying(255),
	IP character varying(96),
	UserID integer NOT NULL REFERENCES users);

CREATE TABLE permissions (
	GroupID integer NOT NULL REFERENCES groups ON DELETE cascade,
	PictureID integer NOT NULL REFERENCES pictures ON DELETE cascade,
	UNIQUE (GroupID, PictureID));

CREATE TABLE active_sessions (
	sid character varying PRIMARY KEY,
	name character varying NOT NULL,
	val character varying,
	changed bigint NOT NULL);
CREATE INDEX session_changed ON active_sessions (changed);

CREATE TABLE groupsdef (
	UserID integer REFERENCES users ON DELETE cascade,
	GroupID integer REFERENCES groups ON DELETE cascade,
	PRIMARY KEY (UserID,GroupID));

CREATE TABLE notes (
        UserID integer REFERENCES users ON DELETE cascade,
        PictureID integer REFERENCES pictures ON DELETE cascade,
        Note int2 NOT NULL,
	PRIMARY KEY (UserID,PictureID));
CREATE INDEX notes_userid ON notes (UserID);

CREATE TABLE keywordtypes (
        TypeID serial PRIMARY KEY,
        Libelle_fr character varying(128));

CREATE TABLE keywords (
        Type integer,
        PictureID integer NOT NULL REFERENCES pictures ON DELETE cascade,
        Value character varying(128) NOT NULL,
	UNIQUE (Type,PictureID,Value));

CREATE INDEX keywords_valuetype ON keywords (Value, Type);
CREATE INDEX keywords_value ON keywords (Value);
CREATE INDEX keywords_pictureid ON keywords (PictureID);

CREATE TABLE selections (
	UserID integer NOT NULL REFERENCES users ON DELETE cascade,
	PictureID integer NOT NULL REFERENCES pictures ON DELETE cascade,
	UNIQUE(UserID,PictureID));
CREATE INDEX selections_userid ON selections (UserID);
CREATE INDEX selections_pkey ON selections (UserID,PictureID);

-- VIEWS
CREATE VIEW userpictures (
       PictureID,RollID,FrameID,Description,Filename,
       Owner,EntryDate,Date,
       NbClick,NbRates,MaxRate,MinRate,AverageRate,SumRates,
       UserID) 
   AS SELECT DISTINCT ON (Permissions.PictureID,UserID) 
	     Pictures.PictureID,RollID,FrameID,Description,Filename,Owner,
	     EntryDate,Date,NbClick,NbRates,MaxRate,MinRate,AverageRate,SumRates,
	     UserID 
	 FROM Permissions 
	      JOIN Groupsdef using (GroupID) 
	      JOIN pictures using (PictureID);

CREATE FUNCTION picturesID(int) RETURNS SETOF int AS '
       SELECT PictureID FROM permissions JOIN groupsdef USING(GroupID) 
	      WHERE groupsdef.UserID = $1
' LANGUAGE 'sql';
