<?php
function maybeCreateTopic(&$tof,$topicID,$description,$groups=array(),$perms=array()) {
	if ($description) {
		createTopic($tof,$topicID,$description,'',$groups,$perms,false);
	}
	return $topicID;
}

/**
 * Creates a new topic owned by the current user
 */
function createTopic(
	&$tof,$parentTopicID,$description,$summary,$groups,$perms,
	$book,$paperSize=null,$orientation='portait') 
{
	$topic = array('ParentTopicID' => $parentTopicID,
				   'Description' => $description,
				   'Summary' => $summary,
				   'Book' => $book);
	if ($book) {
		global $papers;
		if (isset($papers[$paperSize])) {
			$size = $papers[$paperSize];
			if ($orientation=='landscape') {
				$topic['Width'] = $size[1];
				$topic['Height'] = $size[0];
			} else {
				$topic['Width'] = $size[0];
				$topic['Height'] = $size[1];
			}
		} else {
			$tof->error(sprintf(_('Unkown paper size: %s'),$paperSize));
		}
	}

	$topicID = $tof->ct->addTopic($topic);
	$tof->ct->addTopicPerm($topicID,$tof->user['SelfGroup'],OWNER);
	if (is_array($groups) && is_array($perms)) {
		require_once("actions/addTopicPerms.php");
		addTopicPerms($tof,$topicID,$groups,$perms);
	}
	$tof->log(sprintf(_('Topic "%s" added.'),$tof->getTopicLink($description,$topicID)));
	return $topicID;
}
?>