<?php

function rotatePictures(&$tof, $pictures, $angle) {
	foreach($pictures as $pictureID) {
		rotatePicture($tof,$pictureID, $angle);
	}
}

function rotatePicture(&$tof, $pictureID, $angle) {
	require_once("actions/thumb.php");
	$tof->debug(sprintf(_('Rotate %s %s&deg;'),$pictureID, $angle));
	$picture = $tof->ct->getPicture($pictureID);
	if (!is_array($picture)) {
		$tof->error(sprintf(_("Picture %s not found !!!"),$pictureID));
		return;
	}
	$file = $tof->getOrigFilename($picture);
	if (file_exists($file)) {
		rotateFile($tof,$file,$angle);
		createThumb($tof,$picture,true);
	} else {
		rotateFile($tof,$tof->getPictureFilename($picture),$angle);
		createThumb($tof,$picture,true);
	}
}

/**
   * Use jpegtran if available, mogrify otherwise 
   */
function rotateFile(&$tof,$file, $angle) {
	$tof->debug(sprintf(_('Rotate %s %s&deg;'),$file, $angle));
	if (!$tof->jpegtranTested) {
		// This is probably not portable
		exec("jpegtran",$out,$status);
		$tof->haveJpegtran = ($status!=127);
		$tof->jpegtranTested = true;
	}
	if ($tof->haveJpegtran) {
		$cmd = sprintf('jpegtran -rotate %d -copy all -trim -outfile "%s.rot" "%s"',
					   $angle,$file,$file);
		exec($cmd,$output,$status);
		if ($status!=0) {
			$tof->error(sprintf(_("failed to rotate %s"),$file));
			$tof->error($cmd);
			$tof->error(join($output,"<br>"));
		} else {
			if (!rename($file.'.rot',$file)) {
				$tof->error(sprintf(_("failed to rename %s into %s"),$file.'.rot',$file));
			}
		}
	} else {
		$tof->log("jpegtran is not available");
		$cmd = sprintf('mogrify -rotate %d "%s"',$angle,$file);
		exec($cmd,$output,$status);
		if ($status!=0) {
			$tof->error(sprintf(_("failed to rotate %s"),$file));
			$tof->error($cmd);
			$tof->error(join($output,"<br>"));
		}
	}
}
?>