<?php
function getFileData(&$tof,$pictureID,$suffix) {
	$picture = $tof->ct->getPicture($pictureID,$tof->uid);
	if ($picture) {
		$filename = $tof->basePath . $picture['RollID'] . "/" . 
			 $picture['FrameID'] . $suffix;
		  
		$mtime = filemtime($filename);
		$gmdate_mod = gmdate('D, d M Y H:i:s', $mtime) . ' GMT';
		// handle If-Modified-Since header
		global $HTTP_IF_MODIFIED_SINCE;
		if (isset($HTTP_IF_MODIFIED_SINCE)) {
			$if_modified_since = preg_replace('/;.*$/', '', $HTTP_IF_MODIFIED_SINCE);
			if (strtotime($if_modified_since) >= $mtime) {
				header("HTTP/1.0 304 Not Modified");
				return true;
			}
		}
		header("Last-Modified: $gmdate_mod");
		header("Content-Type: image/jpeg");
		header("Cache-Control: private");
		header("Content-Length: "+filesize($filename));
		//		header("Pragma: ");

		readfile($filename);
		return true;
	} else {
		// Let's find why we didn't have a picture
		if ($tof->ct->getPicture($pictureID)) {
			header("HTTP/1.0 403 forbidden");
			header("Content-Type: image/jpeg");
			header("Cache-Control: private");
			header("Pragma: ");
			readfile("forbidden.jpg");
		} else {
			header("HTTP/1.0 404 Not Found");
			header("Content-Type: text/plain");
			echo sprintf(_('No such picture: %s'),$pictureID);
		}
		return false;
	}
}
?>
