
/* This file is created by the "tcl2c" utility, which is included in
 * most "plus"-patches (e.g. for Tcl7.6 and Tcl8.0). Standalone
 * executables can be made by providing alternative initialization
 * functions which don't read files any more. Sometimes, small
 * adaptations to the original libraries are needed to get the
 * application truly standalone. The "plus"-patches contain these
 * adaptations for Tcl and Tk. If you just create your own
 * Xxx_InitStandAlone() function for your package, you can
 * easyly extend the "tcl2c" utility to your own requirements.
 *
 *	Jan Nijtmans
 *	NICI (Nijmegen Institute of Cognition and Information)
 *	email: nijtmans@nici.kun.nl
 *	url:   http://www.cogsci.kun.nl/~nijtmans/
 */
#include "tcl.h"

/*
 * Defines to replace the standard Xxx_Init calls to Xxx_InitStandAlone.
 * If you don't have this function, just delete the corresponding
 * define such that the normal initialization function is used.
 * Similar: If SafeInit functions exists, you can use these
 * by commenting out the corresponding lines below.
 */

#ifdef TCL_ACTIVE
#define Tcl_Init Tcl_InitStandAlone
#define Tk_Init Tk_InitStandAlone
#endif

#define Tcl_SafeInit (Tcl_PackageInitProc *) NULL
#define Tk_SafeInit (Tcl_PackageInitProc *) NULL

/*
 * Prototypes of all initialization functions and the free() function.
 * So, only "tcl.h" needs to be included now.
 */

#ifdef __cplusplus
extern "C" {
#endif

extern void free _ANSI_ARGS_((void *));
extern int  Tcl_Init _ANSI_ARGS_((Tcl_Interp *interp));
#ifndef Tcl_SafeInit
extern int  Tcl_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
extern int  Tk_Init _ANSI_ARGS_((Tcl_Interp *interp));
#ifndef Tk_SafeInit
extern int  Tk_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif

#ifdef __cplusplus
}
#endif

/*
 * The array "script" contains the script that is compiled in.
 * It will be executed in tclAppInit() after the other initializations.
 */

static int line = (__LINE__ + 1);
static char *script[] = {
"if {[file exists ~/.wishrc]} {\n\
	catch {source ~/.wishrc}\n\
}",
"wm iconify .",
"wm withdraw .",
"variable background {darkslateblue}",
"variable foreground {white}",
"variable active_foreground {cyan}",
"variable gadget_color {darkslateblue}",
"variable show_at_startup {true}",
"variable height 48",
"variable pad_x 7",
"variable quick_launch",
"variable font_to_use {helvetica 10}",
"if {$argc != 0} {\n\
	switch [lindex $argv 0] {\n\
		{-r} {\n\
			exec pkill -fo [file tail [info nameofexecutable]]\n\
			exec [file tail [info nameofexecutable]] &\n\
			exit 0\n\
		}\n\
		{-l} {\n\
			puts \"TkLauncher version 0.32\\n\\nCopyright (c) 2016, Pasquale Frega\\n\\nAll rights reserved.\\n\\nRedistribution and use in source and binary forms, with or without\\nmodification, are permitted provided that the following conditions are met:\\n\\n1. Redistributions of source code must retain the above copyright notice, this\\n   list of conditions and the following disclaimer.\\n2. Redistributions in binary form must reproduce the above copyright notice,\\n   this list of conditions and the following disclaimer in the documentation\\n   and/or other materials provided with the distribution.\\n\\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \\\"AS IS\\\" AND\\nANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\\nDISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR\\nANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\\n(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\\nLOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\\nON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\\nSOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\"\n\
			exit 0\n\
		}\n\
		default {\n\
			puts \"Usage: [file tail [info nameofexecutable]] \\[option\\]\\nOption could be:\\n\\t-r\\tReset process\\n\\t-l\\tShow version and license\"\n\
			exit 0\n\
		}\n\
	}\n\
}",
"proc ErrMsg {} {\n\
	tk_messageBox -icon error -message {PROGRAM ERROR}\n\
	exit 1\n\
}",
"if {![file exist ~/.tklauncherrc]} {\n\
	if {[catch {file copy [file dirname [file dirname [info nameofexecutable]]]/share/tklauncher/tklauncherrc ~/.tklauncherrc}]} {\n\
		ErrMsg\n\
	}\n\
}",
"if {[catch {open /tmp/tklauncher.log w} chid]} {\n\
	ErrMsg\n\
} else {\n\
	close $chid\n\
}",
"proc BadConf {} {\n\
	tk_messageBox -icon warning -message {Check ~/.tklauncherrc}\n\
	exit 0\n\
}	",
"if {[catch {package require img::png; package require img::xpm}]} {\n\
	tk_messageBox -icon error -message {Could not load package Img}	\n\
	exit 1\n\
}",
"if {![catch {open ~/.tklauncherrc} chid]} {\n\
	set launcher_number 0	\n\
	while {![eof $chid]} {\n\
		set got_list [gets $chid]\n\
		switch [lindex $got_list 0] {\n\
			{Background} {\n\
				set background [lindex $got_list 1]\n\
			}\n\
			{Foreground} {\n\
				set foreground [lindex $got_list 1]\n\
			}\n\
			{ActiveForeground} {\n\
				set active_foreground [lindex $got_list 1]\n\
			}\n\
			{Gadget} {\n\
				set gadget_color [lindex $got_list 1]\n\
			}\n\
			{ShowAtStartup} {\n\
				if {[string is boolean [lindex $got_list 1]]} {\n\
					set show_at_startup [lindex $got_list 1]\n\
				} else {\n\
					set show_at_startup {true}\n\
				}\n\
			}\n\
			{Height} {\n\
				if {[string is integer [lindex $got_list 1]]} {\n\
					set height [lindex $got_list 1]\n\
				} else {\n\
					BadConf\n\
				}\n\
			}	\n\
			{PadX} {\n\
				if {[string is integer [lindex $got_list 1]]} {\n\
					set pad_x [lindex $got_list 1]\n\
				} else {\n\
					BadConf\n\
				}\n\
			}\n\
			{QuickLaunch} {\n\
				set quick_launch [lindex $got_list 1]\n\
			}\n\
			{FontToUse} {\n\
				set font_to_use [lindex $got_list 1]\n\
			}\n\
			{Launcher} {\n\
				set launcher($launcher_number) [lindex $got_list 1]\n\
				if {[catch {toplevel .$launcher($launcher_number) -borderwidth 1 -relief raised -background $background}]} {\n\
					BadConf\n\
				}\n\
				wm overrideredirect .$launcher($launcher_number) yes\n\
				raise .$launcher($launcher_number)\n\
				wm withdraw .$launcher($launcher_number)\n\
				set icon_number 0\n\
				set to_grid {grid}\n\
				while {![string equal [lindex $got_list 0] {End}]} {\n\
					set got_list [gets $chid]\n\
					if {[string equal [lindex $got_list 0] {Icon}]} {\n\
						if {[catch {button .$launcher($launcher_number).$icon_number -image [image create photo -file [lindex $got_list 1] -height $height] -command \"catch {exec [lindex $got_list 2] 2>>/tmp/tklauncher.log &}\" -font $font_to_use -text [lindex $got_list 3] -compound top -borderwidth 0 -pady 1 -padx $pad_x -highlightbackground $background -background $background -activebackground $background -foreground $foreground -activeforeground $active_foreground}]} {\n\
							BadConf\n\
						}\n\
						lappend to_grid .$launcher($launcher_number).$icon_number\n\
						incr icon_number\n\
					}\n\
				}\n\
				eval \"$to_grid -sticky news\"\n\
				update idletasks\n\
				wm geometry .$launcher($launcher_number) +[expr {[winfo screenwidth .] - [winfo width .$launcher($launcher_number)] - 18}]+[expr {[winfo screenheight .] - ($height + 23)}]\n\
				incr launcher_number\n\
			}\n\
		}\n\
	}	\n\
	close $chid\n\
} else {\n\
	ErrMsg\n\
}",
"if {[catch {toplevel .gadget -relief raised -borderwidth 1 -background $gadget_color}]} {\n\
	BadConf\n\
}",
"wm overrideredirect .gadget yes",
"raise .gadget",
"wm geometry .gadget 18x[expr {$height + 23}]+[expr {[winfo screenwidth .] - 18}]+[expr {[winfo screenheight .] - ($height + 23)}]",
"bind .gadget <Double-1> {\n\
	if {![string equal [wm state .$selected_launcher] {withdrawn}]} {\n\
		wm withdraw .$selected_launcher\n\
	} else {\n\
		wm deiconify .$selected_launcher\n\
	}\n\
}",
"bind .gadget <ButtonPress-3> {\n\
	catch {exec {*}$quick_launch 2>>/tmp/tklauncher.log &}\n\
}",
"set lmenu_icon [image create photo -data {/* XPM */\n\
static char * lmenu_xpm[] = {\n\
\"14 15 4 1\",\n\
\" 	g None\",\n\
\".	g #000000\",\n\
\"+	g #A9A9A9\",\n\
\"@	g #767676\",\n\
\"..............\",\n\
\".++++++++++++.\",\n\
\".+.++++++++.+.\",\n\
\".+..++++++..+.\",\n\
\".+@..++++..@+.\",\n\
\".++@..++..@++.\",\n\
\".+++@....@+++.\",\n\
\".++++@..@++++.\",\n\
\".+++++@@+++++.\",\n\
\".++++++++++++.\",\n\
\".+..........+.\",\n\
\".+@@@@@@@@@@+.\",\n\
\".++++++++++++.\",\n\
\".++++++++++++.\",\n\
\"..............\"};\n\
}]",
"menubutton .gadget.lmenu_button -direction left -image $lmenu_icon -relief raised -menu .gadget.lmenu_button.lmenu",
"bind .gadget.lmenu_button <ButtonRelease-1> {\n\
	.gadget.lmenu_button.lmenu entryconfigure end -state active\n\
}",
"proc LMenuCommand {launcher} {\n\
	global selected_launcher\n\
	\n\
	if {![string equal [wm state .$selected_launcher] {withdrawn}]} {\n\
		wm withdraw .$selected_launcher\n\
	}\n\
	set selected_launcher $launcher\n\
	wm deiconify .$selected_launcher\n\
}",
"menu .gadget.lmenu_button.lmenu -background white -activebackground black -foreground black -activeforeground white -tearoff 0",
".gadget.lmenu_button.lmenu add command -font $font_to_use -label {About} -command {tk_messageBox -title {About} -message \"TkLauncher 0.32\\n\\nCopyright (C) 2016 Pasquale Frega\\n\\nAll rights reserved\\n\\npasquale_frega@tiscali.it\\n\\nReleased under the simplified\\nBSD license\"}",
".gadget.lmenu_button.lmenu add separator",
"for {set idx [expr {$launcher_number - 1}]} {$idx >= 0} {incr idx -1} {\n\
	.gadget.lmenu_button.lmenu add command -font $font_to_use -label $launcher($idx) -command \"LMenuCommand $launcher($idx)\"\n\
}",
"pack .gadget.lmenu_button -side bottom",
"set selected_launcher $launcher(0)",
"if {$show_at_startup} {\n\
	wm deiconify .$selected_launcher\n\
}",
(char *) NULL
};

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

void
#ifdef _USING_PROTOTYPES_
main (int    argc,		/* Number of command-line arguments. */
      char **argv)		/* Values of command-line arguments. */
#else
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
#endif
{
    Tcl_Interp *interp;
    char **p = script;
    char *q, buffer[10];
    Tcl_DString data;
    Tcl_Channel inChannel, outChannel, errChannel;

    Tcl_FindExecutable(argv[0]);
    interp = Tcl_CreateInterp();

    q = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", q, TCL_GLOBAL_ONLY);
    ckfree(q);
    sprintf(buffer, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buffer, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", argv[0],TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tcl_interactive","0", TCL_GLOBAL_ONLY);

    if (Tcl_Init(interp) != TCL_OK) {
        goto error;
    }
    if (Tk_Init(interp) != TCL_OK) {
        goto error;
    }
    Tcl_StaticPackage(interp, "Tk", Tk_Init, Tk_SafeInit);

    /*
     * Execute the script that is compiled in.
     */

    inChannel = Tcl_GetStdChannel(TCL_STDIN);
    outChannel = Tcl_GetStdChannel(TCL_STDOUT);
    Tcl_DStringInit(&data);
    while(*p) {
	Tcl_DStringSetLength(&data,0);
	Tcl_DStringAppend(&data,*p++,-1);
	if (Tcl_Eval(interp,Tcl_DStringValue(&data)) != TCL_OK) {
	    Tcl_DStringFree(&data);
	    while (p-- != script) {
		for (q = *p;*q; q++) {
		    if (*q=='\n') line++;
		}
		line++;
	    }
	    sprintf(buffer,"%d",line);
	    Tcl_AddErrorInfo(interp,"\n	( Error in file: \"");
	    Tcl_AddErrorInfo(interp,__FILE__);
	    Tcl_AddErrorInfo(interp,"\", line: ");
	    Tcl_AddErrorInfo(interp,buffer);
	    Tcl_AddErrorInfo(interp,")");
	    errChannel = Tcl_GetStdChannel(TCL_STDERR);
	    if (errChannel) {
		Tcl_Write(errChannel,
			Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY), -1);
		Tcl_Write(errChannel, "\n", 1);
	    }
	    sprintf(buffer, "exit %d", 1);
	    Tcl_Eval(interp, buffer);
	}
    }
    Tcl_DStringFree(&data);

    while (Tcl_DoOneEvent(0)) {
	/* empty loop body */ ;
    }
    sprintf(buffer, "exit %d", 0);
    Tcl_Eval(interp, buffer);

error:
    errChannel = Tcl_GetStdChannel(TCL_STDERR);
    if (errChannel) {
	Tcl_Write(errChannel,
		"application-specific initialization failed: ", -1);
	Tcl_Write(errChannel, interp->result, -1);
	Tcl_Write(errChannel, "\n", 1);
    }
    sprintf(buffer, "exit %d", 1);
    Tcl_Eval(interp, buffer);
}
