#    $Id: irclog_log.py,v 1.25 2002/07/02 14:18:38 tilk Exp $
#    tilkIRClog
#    Copyright (C) 2001  Marek "Tilk" Materzok
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from irclog_confclass import irclog_config
import time
import os
import quopri
import base64
import gzip
import StringIO
import prefixes
import string
import zipfile
import re
import threading

class LogFile:
    def __init__(self):
	self.openall ("a")

    def __del__(self):
	self.closeall ()

    def genfilename (self, channame, datestring = ""):
	cn = "log." + channame.replace("/", "_")
	if datestring != "":
	    cn = cn + "." + datestring
	return cn.lower()
	
    def openall (self, tmode):
	if tmode not in "wa":
	    return
	self.files = {}
	for file in irclog_config.channels+["private"]:
	    self.files[file.lower()] = open ("%s/%s" % (irclog_config.directory, 
		self.genfilename(file)), tmode) 
	    if irclog_config.mircformat:
		self.files[file.lower()].write("\nSession Start: " + time.asctime() + "\n")
		self.files[file.lower()].write("Session Ident: " + file + "\n")
	if irclog_config.mircformat:
	    self.local_msg ("private", prefixes.Slog, "Started logging")
	else:
	    self.global_msg (prefixes.Slog, "Started logging")

    def closeall (self):
	if irclog_config.mircformat:
	    self.global_unformatted ("Session Close: " + time.asctime())
	else:
	    self.global_msg (prefixes.Elog, "Stopped logging")
	for file in self.files.items():
	    file[1].close()
	    del self.files[file[0]]

    def moveall (self, datestring):
	chans = irclog_config.channels[:]
	chans.append("private")
	for file in chans:
	    source = "%s/%s"  % (irclog_config.directory, self.genfilename(file))
	    destin = "%s/%s"  % (irclog_config.directory, self.genfilename(file,datestring))
	    os.rename (source, destin)

    def format_time (self,mtime):
	tt = time.localtime(mtime)
	if irclog_config.timestamp == "dmyhms":
	    return "[%.2d/%.2d/%.4d %.2d:%.2d:%.2d]" % (tt[2],tt[1],tt[0],tt[3],tt[4],tt[5])
	if irclog_config.timestamp == "dmhms":
	    return "[%.2d/%.2d %.2d:%.2d:%.2d]" % (tt[2],tt[1],tt[3],tt[4],tt[5])
	if irclog_config.timestamp == "hms":
	    return "[%.2d:%.2d:%.2d]" % (tt[3],tt[4],tt[5])
	if irclog_config.timestamp == "hm":
	    return "[%.2d:%.2d]" % (tt[3],tt[4])
	return ""

    def linewrap (self,prefix,msg):
	mesg = "%s %s" % (prefix, msg)
	if irclog_config.line_wrap:
	    if mesg <= irclog_config.line_wrap:
		return mesg
	    rmesg = ""
	    while len(mesg) > irclog_config.line_wrap:
		pos = string.rfind (mesg, " ", 0, irclog_config.line_wrap)
		if pos <= len(prefix) + 1:
		    pos = string.find (mesg, " ", irclog_config.line_wrap)
		    if pos == -1:
			break;
		rmesg = rmesg + mesg[:pos] + "\n"
		mesg = ' ' * len(prefix) + mesg[pos:]
	    rmesg = rmesg + mesg
	    return rmesg + "\n"
	else:
	    return mesg + "\n"

    def global_msg (self,prefix,msg):
	output = self.linewrap ("%s %s" % (self.format_time(time.time()), prefix), msg)
	for file in self.files.values():
	    file.write(output)
	    file.flush()

    def global_unformatted (self,output):
	for file in self.files.values():
	    file.write(output + "\n")
	    file.flush()

    def local_msg (self,to,prefix,msg):
	if self.files.has_key(to.lower()):
	    output = self.linewrap ("%s %s" % (self.format_time(time.time()), prefix), msg)
	    file = self.files[to]
	    file.write (output)
	    file.flush()

    def mail_logs (self):
	irclog_config.lock()
	tt = time.localtime(time.time())
	datestring = "%.2d.%.2d.%.4d" % (tt[2],tt[1],tt[0])
	mtext = "Now sending logs (%s)" % datestring
	if irclog_config.mircformat:
	    self.local_msg ("private", prefixes.Info, mtext)
	else:
	    self.global_msg (prefixes.Info, mtext)
	self.closeall()
	self.moveall(datestring)
	thread = threading.Thread(None,self.mail_logs_do,None,[datestring],{})
	thread.start()
	self.openall("w")
	mtext = "Starting new log (%s)" % datestring
	if irclog_config.mircformat:
	    self.local_msg ("private", prefixes.Info, mtext)
	else:
	    self.global_msg (prefixes.Info, mtext)
	irclog_config.unlock()

    def mail_logs_do (self, datestring):
	for file_mail in irclog_config.emails.items():
	    channame = file_mail[0].lower()
	    if channame != "private" and file_mail[0] not in irclog_config.channels:
		continue 
	    formats = {None: [], "GZ": [], "BZ2": [], "ZIP": []}
	    for mail in file_mail[1]:
		if irclog_config.compmail.has_key(mail):
		    formats[irclog_config.compmail[mail]].append(mail)
		else:
		    formats[irclog_config.compress].append(mail)
	    for pair in formats.items():
		if len(pair[1]) <= 0:
		    continue
		self.mail_to (string.join(pair[1],","), pair[0], channame, datestring)

	chans = irclog_config.channels[:]
	chans.append("private")
	for chan in chans:
	    fname = "%s/%s" % (irclog_config.directory, self.genfilename(chan, datestring))
	    if chan in irclog_config.archivize:
		name = self.compress(fname,irclog_config.comparch)
		logpr = name[name.rfind("/"):]
		os.rename(name,"%s/%s"%(irclog_config.archdir,logpr))
	    os.unlink(fname)

    def compress(self,filename,format):
	if format == None:
	    format = ""
	logname_prefix = filename[filename.rfind("/"):]
	file = open(filename, "r")
	if format.upper() == "GZ":
	    outn = "%s/%s.gz" % (irclog_config.directory, logname_prefix)
	    sio = open(outn, "w")
	    cobj = gzip.GzipFile("%s.txt" % logname_prefix, "wb", 9, sio)
	    d = " "
	    while d:
		d = file.readline()
		cobj.write(d)
	    cobj.close()
	    sio.close()
	elif format.upper() == "BZ2":
	    outn = "%s/%s.bz2" % (irclog_config.directory, logname_prefix)
	    out = os.popen("bzip2 > %s" % outn, "w")
	    d = " "
	    while d:
		d = file.readline()
		out.write(d)
	    out.close()
	elif format.upper() == "ZIP":
	    outn = "%s/%s.zip" % (irclog_config.directory, logname_prefix)
	    out = zipfile.ZipFile(outn, "w", zipfile.ZIP_DEFLATED)
	    zinfo = zipfile.ZipInfo()
	    zinfo.filename = "%s.txt" % logname_prefix
	    zinfo.date_time = (2000,1,1,0,0,0)
	    zinfo.compress_type = zipfile.ZIP_DEFLATED
	    d = " "
	    s = ""
	    while d:
		d = file.readline()
		s = s + d
	    out.writestr(zinfo,s)
	    del s	    
	    out.close()
	else:
	    outn = filename+".txt"
	    outf = open(outn, "w")
	    d = " "
	    while d:
		d = file.readline()
		outf.write(d)
	    outf.close()
	file.close()
	return outn

    def encrypt(self,filename,fd,format,mimeenc):
	outname = self.compress(filename,format)
	file = open(outname,"r")
	if mimeenc.lower() == "b64":
	    base64.encode(file,fd)
	else:
	    quopri.encode(file,fd,1)
	file.close()
	os.unlink(outname)

    def mail_to(self,emails, format, channame, datestring):	    
	fd = os.popen (irclog_config.sendmail, "w")
	logname_prefix = self.genfilename (channame, datestring)
	fd.write('Content-Type: multipart/mixed;\n  boundary="----=_Next_Attachment_0"\n')
	fd.write('From: tilkIRClog <%s>\n' % irclog_config.srcmail)
	if not irclog_config.dstmail:
	    fd.write('Bcc: %s\n' % emails)
	elif irclog_config.dstmail.lower() == "public":
	    fd.write('To: %s\n' % emails)
	else:
	    fd.write('To: %s\n' % irclog_config.dstmail)
	    fd.write('Bcc: %s\n' % emails)
	fd.write('Subject: %s\n' % (irclog_config.subject % {"n": channame, "d": datestring}))
	fd.write('MIME-Version: 1.0\n\nThis is multipart message in MIME format.\n\n')
	fd.write('------=_Next_Attachment_0\n')
	fd.write('Content-Type: text/plain; charset=%s\n' % irclog_config.charset)
	fd.write('Content-Transfer-Encoding: 8bit\n\n')
	fd.write('Here is the latest log for %s\n\n' % channame)
	fd.write('------=_Next_Attachment_0\n')
	if format == "GZ":
	    fd.write('Content-Type: application/x-gzip;\n  name="%s.txt.gz"\n' % logname_prefix)
	    fd.write('Content-Transfer-Encoding: base64\n')
	    fd.write('Content-Disposition: attachment;\n  filename="%s.txt.gz"\n\n' % logname_prefix)
	    mimef = "b64"
	elif format == "BZ2":
	    fd.write('Content-Type: application/x-bzip2;\n  name="%s.txt.bz2"\n' % logname_prefix)
	    fd.write('Content-Transfer-Encoding: base64\n')
	    fd.write('Content-Disposition: attachment;\n  filename="%s.txt.bz2"\n\n' % logname_prefix)
	    mimef = "b64"
	elif format == "ZIP":
	    fd.write('Content-Type: application/zip;\n  name="%s.zip"\n' % logname_prefix)
	    fd.write('Content-Transfer-Encoding: base64\n')
	    fd.write('Content-Disposition: attachment;\n  filename="%s.zip"\n\n' % logname_prefix)
	    mimef = "b64"
	else:
	    fd.write('Content-Type: text/plain;\n  charset=%s\n  name="%s.txt"\n' % (irclog_config.charset, logname_prefix))
	    fd.write('Content-Transfer-Encoding: quoted-printable\n')
	    fd.write('Content-Disposition: attachment;\n  filename="%s.txt"\n\n' % logname_prefix)
	    mimef = "qp"
	self.encrypt("%s/%s" % (irclog_config.directory, self.genfilename(channame, datestring)),fd,format,mimef)
	fd.write('\n------=_Next_Attachment_0--\n')
	fd.close()
