#!/usr/bin/python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cgi_config

import sys;
import os, os.path
import re
from urlparse import urlparse

import cgi;
import cgitb; cgitb.enable()

import ac_config
from td_config import config,read_config
import td_tools
from td_parse_bibtex import parse_bibtex_entry

print "Content-type: text/html; charset=UTF-8"
print

form = cgi.FieldStorage()

print "<html>"
print "<head>"
print '<link rel="stylesheet" href="../style.css">'
print "</head>"
print "<body>"
print "<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"1\">"
print '<tr><td bgcolor=\"#CACAF7\" align=\"center\"><span class="pagetitle">-=[Upload a document]=-</a></span></td></tr></table><br>'

def error(msg):
  print "<H1>Error</H1>"
  print msg
  print "<br><br>"
  print "<hr>"
  raise Exception("Fatal error.")

def get_url(url):
  if not re.match("^(ht|f)tps?://", url):
    error("Bad url.")
    return
  
  docname = os.path.basename(urlparse(url)[2])
  orig_doc_url = url
  orig_doc_path = "/tmp/tidydoc_" + docname

  try:
    td_tools.exec_commands('wget --no-check-certificate "%s" -O %s\n' % (orig_doc_url, orig_doc_path))
  except Exception, e:
    error("%s <br> Could not download `%s', is wget installed?<br>" \
            % (e,orig_doc_url))
    return
  
  if not os.path.exists(orig_doc_path):
    error("`%s': not found.\n" % orig_doc_path)
    return

  return orig_doc_path

def get_file(fileitem):
  print "Document received."
  docname = form["document"].filename
  docpath = "/tmp/" + docname
  output = open(docpath, "w")
  while 1:
    line = fileitem.file.readline(65535)
    if not line: break
    output.write(line)
  output.close()
  return docpath

def process():
  if not (form.has_key("document") and form.has_key("url")
          and form.has_key("bibtex")):
    error("Please fill in the document, url and bibtex fields.")
    return
  
  values = {}

  url = form["url"].value
  if (url != ""):
    values['docpath'] = get_url(url)
  else:
    fileitem = form["document"]
    if (fileitem.filename != ""):
      values['docpath'] = get_file(fileitem)
    else:
      error("You must provide an url or file.")
  
  bibtex = form["bibtex"].value
  values['bibtex_dict'] = parse_bibtex_entry(bibtex)
  values['bibtex'] = bibtex
  return values

def create_html_view(values):
  orig_doc_path = values['docpath']
  if not re.search(r'\.pdf$', orig_doc_path):
    return None
  docname = os.path.basename(orig_doc_path)
  tempdir = config['output_path'] + "/temp"
  cmd = """
mkdir -p "%(tempdir)s" || exit 1
touch "%(tempdir)s/.td_raw_dir"
pdftohtml -zoom 10 -c -i -nomerge -f 1 -l 1 "%(orig_doc_path)s" "%(tempdir)s/%(docname)s.html"
""" % locals()
  try:
    td_tools.exec_commands(cmd)
  except Exception, e:
	print "<br><small>Warning: could not run pdftohtml. HTML Preview not available.</small><br>"
  return config['site_root'] + "/temp/" + docname + "-1.html"

def add_form(values):
  orig_doc_path = values['docpath']
  f = open(config['categories_path'], "r")
  categories = f.read()
  f.close()
  props = td_tools.guess_desc_from_doc(orig_doc_path)
  props['categories'] = categories
  props['url'] = form["url"].value
  props['nbrows'] = 80 + len(categories.splitlines())
  props['orig_doc_path'] = orig_doc_path  
  props.update(values['bibtex_dict'])
  props['bibtex'] = values['bibtex']
  print """
<br>
<form action="get_dsc.cgi" method="post">
<input type="hidden" name="docpath" value="%(orig_doc_path)s"/>
<TEXTAREA style="font-size: 8pt;" name="dsc" rows="40" cols="80">
Title: %(title)s

%% One per line. End by the last name. eg: D. Knuth
Author: %(author)s

%% End it by the year. eg: Oct 2004
Date: %(date)s

%% Use short names. eg: siggraph
Conf: %(conf)s

Pages: %(pages)s

Keywords: 

Link: %(url)s

%% Line breaks are taken into account.
Comment:

%% Line breaks are taken into account.
Abstract: 

Visibility: public

Language: english

Bibtex:
%(bibtex)s

%% Uncomment as many as you want, links will be created.
Categories:
%(categories)s
</TEXTAREA>
<br><br>
<input type="submit" name="submit" value="Submit"/>
</form>
""" % (props)

read_config(cgi_config.file)
values = process()
html_view = create_html_view(values)
if html_view:
  print '<a href="%s" target=_blank>[HTML view in new window]</a><br>' % (html_view)
add_form(values)

print "</body></html>"
