#!/usr/bin/python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cgi_config

import sys;
import os, os.path, glob
import re
import cgi;
import cgitb; cgitb.enable()
import shutil

import ac_config
from td_config import config,read_config
import td_tools
import td_doctree
import td_generate
import td_tools
import td_archive

import td_debug
td_debug.in_cgi = True

form = cgi.FieldStorage()

print "Content-type: text/html; charset=UTF-8"
print

print "<html>"
print "<head>"
print '<link rel="stylesheet" href="../style.css">'
print "</head>"
print "<body>"
print "<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"1\">"
print '<tr><td bgcolor=\"#CACAF7\" align=\"center\"><span class="pagetitle">-=[Create an archive]=-</span></a></td></tr></table><br>'

def error(msg):
  print "<H1>Error</H1>"
  print msg

def create_archive(category):
  zipname = category.replace('/','_') + ".zip"
  doctree = td_doctree.build(config['input_path'])
  td_archive.generate_category(doctree, 
                               category, 
                               config['archives_path'] + "/" + zipname)
  print 'Archive <a href="%s"> %s </a> ready.<br>' % (config['archives_url'] + "/" + zipname, zipname)

def process():
  read_config(cgi_config.file)
  if not form.has_key("category"):
    print "Category was not provided or empty category."
    return

  category = form["category"].value
  if len(category) == 0:
    print "Empty category."
    return
  
  create_archive(category)

process()
print "</body></html>"
