# -*- coding: utf-8 -*-
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import re

def latex_to_plain_text(s):
    # TODO: to be completed.
    substitutions = {
        r"\\'e": r"é",
        r"\\`e": r"è",
        r"\\`a": r"à"
    }
    s = re.sub("{|}", "", s)
    s = re.sub("[\n\r]+", " ", s)
    for (key,value) in substitutions.items():
        s = re.sub(key, value, s)
    return s

def parse_pages(s):
    pages = None
    try:
        (first,sep,last) = s.partition("--")
        pages = str(int(last)-int(first)+1)
    except:
        print "Could not parse pages."
    return pages

def parse_authors(s):
    authors = s.split("and")
    result = ""
    for author in authors:
        (lastname,sep,firstname) = author.partition(", ")
        author = firstname + " " + lastname
        result = result + re.sub("\s+", " ", author) + "\n"
    result = result.rstrip("\n")
    return result

def parse_bibtex_entry(entry):
    dict = {}
    keywords = ["title", "author", "pages", "year", "journal", "booktitle"]
    for keyword in keywords:
        m = re.search("%s\s*?=\s*?\{(.*?)\},?[\n\r]+" % keyword, 
                      entry, 
                      re.MULTILINE | re.DOTALL)
        if m:
            value = latex_to_plain_text(m.group(1))
            if (keyword == "year"):
                keyword = "date"
            if (keyword == "author"):
                value = parse_authors(value)
            if (keyword == "pages"):
                value = parse_pages(value)
            if (keyword == "journal" or keyword == "booktitle"):
                keyword = "conf"
            if value:
                dict[keyword] = value
    return dict

def main():
    parse_bibtex_entry("""
@article{muse2006contrario,
  title={{An a contrario decision method 
for shape element recognition}},
  author={Mus{\'e}, P. and Sur, F. and Cao, F. and Gousseau, Y. and Morel, J.M.},
  journal={International Journal of Computer Vision},
  volume={69},
  number={3},
  pages={295--315},
  year={2006},
  publisher={Springer}
}
""")

if __name__ == "__main__":
    main()
