#!/usr/bin/env python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, sys
from getopt import getopt
from BaseHTTPServer import HTTPServer
from CGIHTTPServer import CGIHTTPRequestHandler

import ac_config
import td_config
from td_config import config

class TidydocWebServer(CGIHTTPRequestHandler):
    pass

def print_help():
    sys.stderr.write(
"""Usage: td-web-server [options]

  Options

  -c, --config configfile  Config file to use.
  -v, --version            Print version number.

Nicolas Burrus <nicolas.burrus@ensta.fr>
""")

def parse_command_line(argv):
    try: (options, args) =  getopt(argv[1:], "vc:",
                                   ["version", "config"])
    except:
        print_help()
        sys.exit(1)

    if len(args) != 0:
        print_help()
        sys.exit(1)

    cmd_options = { 'config_file' : None }

    for option in options:
        if option[0] == "-v" or option[0] == "--version":
            print "Tidydoc " + ac_config.version
            print "Nicolas Burrus <nicolas.burrus@ensta.fr>"
            sys.exit(0)
        if option[0] == "-c" or option[0] == "--config":
            cmd_options['config_file'] = option[1]
    return cmd_options


def main():
    cmd_options = parse_command_line(sys.argv)
    try:
        td_config.read_config(cmd_options['config_file'])
    except:
        sys.stderr.write(str(sys.exc_info()[0]) + "\n")
        sys.exit(1)

    try:
        os.chdir(config['output_path'])
        port = config['webserver_port']
        interface = config['webserver_interface']
        server = HTTPServer((interface, port), TidydocWebServer)
        print 'Tidydoc web server started on port %s' % str(port)
        server.serve_forever()
    except KeyboardInterrupt:
        print '^C received, shutting down server'
        server.socket.close()

if __name__ == '__main__':
    main()
