# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import re
from glob import glob

def clean_lines(lines):
  while (len(lines) > 0) and (lines[0] == ''):
    lines.pop(0)
  while (len(lines) > 0) and (lines[-1] == ''):
    lines.pop()

def parse(desc_file):
  f = open(desc_file, "r")
  lines = f.readlines()
  f.close()
  sections = {
    'Title'        : [],
    'Author'       : [],
    'Date'         : [],
    'Conf'         : [],
    'Pages'        : [],
    'Keywords'     : [],
    'Link'         : [],
    'Abstract'     : [],
    'Visibility'   : [],
    'Language'     : [],
    'Bibtex'       : [],
    'Comment'      : [],
    'Categories'   : []
  }
  current_section = ""
  current_lines = []
  for line in lines:
    new_section = False
    for sec in sections.keys():
      m = re.match('^' + sec + ':\s*(.*)', line)
      if m != None:
        # A new section has been found.
        clean_lines(current_lines)
        sections[current_section] = current_lines
        if (m.group(1) != ''):
          current_lines = [m.group(1)]
        else:
          current_lines = []
        current_section = sec
        new_section = True
        break
    if not new_section:
      m = re.match('^\s*(.*)$',line)
      text = m.group(1)
      if (text == '') or (text[0] != '%'):
        current_lines.append(text)
    
  clean_lines(current_lines)
  sections[current_section] = current_lines
  del sections['']
  return sections

def docname_from_dsc(sections, orig_file):
  try:
    title = sections['Title'][0].lower()
    title = re.sub('[^\w]+', '_', title.rstrip(" \r\n"))
  except:
    raise Exception("no title")

  try:
    conf = sections['Conf'][0].lower()
    conf = re.sub('[^\w]+', '_', conf.rstrip(" \r\n"))
  except:
    conf = ""

  try:
    author = sections['Author'][0].lower().rstrip(" \r\n")
    author = author.split(' ')[-1]
    author = re.sub('[^\w]+', '_', author)
  except:
    author = "unknown"

  try:
    date = re.match('.*\d\d(\d\d).*', sections['Date'][0]).group(1).rstrip(" \r\n")
  except:
    date = ""

  ext = None
  m = re.match('^.*\.(\w+)$', orig_file)
  if m:
    ext = m.group(1)
  if ext == None:
    raise Exception("no extension on the document filename.")

  filename = author + '.' + date + '.' + conf + '.' + title + '.' + ext
  return filename

def doc_filename_from_dsc(dsc):
  return dsc.rstrip('.dsc')
