#!/usr/bin/env python
#
# Copyright (C) 2005, 2006, 2008, 2009 Nicolas Burrus
# This file is part of Tidydoc.
#
# Tidydoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Tidydoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from glob import glob
import os, re, sys

import td_tools
from td_tools import is_more_recent
import td_config
import td_debug
import td_xml
from td_config import config

import pickle

class DirNode:
  def __init__(self, path, subdirs, docs):
    self.path = path
    self.subdirs = subdirs
    self.docs = docs

class DocNode:
  def __init__(self, content):
    self.content = content

def build(directory):
  # Create subdirs nodes
  subdirs = td_tools.listdirs(directory)
  subdirs.sort()
  subdir_nodes = []
  for subdir in subdirs:
    subdir_path = os.path.join(directory, subdir)
    if not os.path.exists(os.path.join(subdir_path, ".td_raw_dir")):
      if os.path.basename(subdir_path) != ".svn":
        subdir_nodes.append(build(subdir_path))

  # Create document nodes
  xml_files = glob(directory + '/*.xml')
  doc_nodes = []
  for f in xml_files:
    dump_fname = f + ".dump"
    node = None
    if os.path.exists(dump_fname) and is_more_recent(dump_fname, f):
      #td_debug.debug("Loading from: " + dump_fname)      
      node = pickle.load(open(dump_fname, "rb"))
    else:
      try:
        node = DocNode(td_xml.parse(f))
      except Exception, e:
        print str(e)
        raise "Could not parse `%s'" % f
      # Cache for next time.
      try:
        dumpfile = open(dump_fname, "wb")
        if dumpfile:
          pickle.dump(node, dumpfile)
      except:
        sys.stderr.write(str(sys.exc_info()[0]) + "\n")
        print "Serialization error."
    doc_nodes.append(node)

  doc_nodes.sort(lambda d1,d2: cmp(d2.content['date'],
                                   d1.content['date']))

  return DirNode(directory, subdir_nodes, doc_nodes)

def dump(doctree, indent=0):
  for subdir in doctree.subdirs:
    print " " * indent, "`--", os.path.basename(subdir.path)
    dump(subdir, indent+6)
  for doc in doctree.docs:
    print " " * indent, doc.content['title'][0].encode("utf_8")

def nb_docs(doctree):
  n = len(doctree.docs)
  for subdir in doctree.subdirs:
    n += nb_docs(subdir)
  return n

if __name__ == '__main__':
  td_config.read_config()
  doctree = build(config['input_path'])
  dump(doctree)
