#!/usr/bin/env python
#
# Copyright (C) 2005, 2006, 2008, 2009 Nicolas Burrus
# This file is part of Tidydoc.
#
# Tidydoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Tidydoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, re, sys

from td_tools import *
import td_config
import td_xml
import td_doctree
from td_config import config
import ac_config

def extract_initials(name):
  parts = name.split(' ')
  s = ""
  for i in range(0, len(parts)-1):
    if len(parts[i]) > 0:
      s += parts[i][0] + '. '
  s += parts[-1]
  return s

def generate_bibtex_entry(doc):
  bibtex = doc.content['bibtex'][0]
  if (len(bibtex) != 0):
    lines = bibtex.splitlines()
    for i in range(1, len(lines)-1):
      lines[i] = "  " + lines[i].lstrip()
    return "\n".join(lines)
  bibtex_type = "misc"
  authors = [extract_initials(x) for x in doc.content['author']]
  authors = " and ".join(authors)
  title = doc.content['title'][0]
  name = doc.content['author'][0].split(' ')[-1].lower()
  m = re.match('.*\d\d(\d\d).*', doc.content['date'][0])
  if m:
    name += m.group(1)
  year = "xxxx"
  m = re.match('.*(\d\d\d\d).*', doc.content['date'][0])
  if m:
    year = m.group(1)
  return \
("""
@%(bibtex_type)s{%(name)s,
  author = {%(authors)s},
  title = {%(title)s},
  year = {%(year)s},
}
""" % locals())

def generate_bibtex(doctree, f):
  if len(doctree.docs) > 0:
    f.write("%%-- " + rel_path(doctree.path) + " --%%\n")
  for doc in doctree.docs:
    entry = generate_bibtex_entry(doc)
    f.write(entry.encode("utf_8"))
  f.write("\n")

  for subdir in doctree.subdirs:
    generate_bibtex(subdir, f)

def generate(doctree):
  f = open(config['bibtex_file'], "w")
  generate_bibtex(doctree, f)
  f.close()
