# Copyright (C) 2005, 2009 Nicolas Burrus
# This file is part of Tidydoc.
#
# Tidydoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Tidydoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import xml.dom.minidom

def get_text(nodelist):
    rc = ""
    for node in nodelist:
        if node.nodeType == node.TEXT_NODE:
            rc = rc + node.data
    return rc

fields = [ 'author',
           'comment',
           'conf',
           'date',
           'file',
           'language',
           'nbpages',
           'summary',
           'title',
           'type',
           'url',
           'bibtex_type',
           'bibtex_fields'
           ]

def parse(fname):  
  dom = xml.dom.minidom.parse(fname)
  dom = dom.getElementsByTagName("document")[0]

  doc = {}  
  for field in fields:
    try:
      content_list = dom.getElementsByTagName(field)
    except:
      content_list = None
    if content_list:
      doc[field] = []
      for content in content_list:
        doc[field].append(get_text(content.childNodes))
    else:
      doc[field] = [""]
  return doc
