/*
 * $Log: ua.js,v $
 * Revision 1.1  2005/11/06 11:39:17  nes
 * 2005-11-06  Nicolas Burrus  <nicolas.burrus@lrde.epita.fr>
 *
 * 	Support automatic document reorganization.
 *
 * 	* td-reorganize-doc/: New dir.
 * 	* td-reorganize-doc/td-reorganize-doc.in,
 * 	  td-reorganize-doc/td_reorganize_doc.py: New.
 * 	* td-common/td_dsc.py(doc_filename_from_dsc): New.
 * 	* Makefile.am: Adjust.
 * 	* configure.ac: Adjust.
 *
 * 2005-11-06  Nicolas Burrus  <nicolas.burrus@lrde.epita.fr>
 *
 * 	Update documentation.
 *
 * 	* doc/examples/treeview: New.
 * 	* doc/Makefile.am: Include treeview.
 * 	* doc/tidydoc.texi: Update.
 *
 * 2005-11-06  Nicolas Burrus  <nicolas.burrus@lrde.epita.fr>
 *
 * 	Add bibtex support.
 *
 * 	* td-generate/td_bibtex.py: New.
 * 	* td-generate/td_generate.py: Adjust.
 * 	* td-generate/td_html.py: Adjust.
 *
 * 	* td-common/td_xml.py: Adjust.
 * 	* td-common/td_dsc.py: Adjust.
 *
 * 	* doc/examples/tidydoc.conf.in: Adjust.
 * 	* configure.ac: Adjust.
 * 	* Makefile.am: Adjust.
 *
 * 2005-11-06  Nicolas Burrus  <nicolas.burrus@lrde.epita.fr>
 *
 * 	Reorganize files.
 *
 * 	* contrib/td_add_doc.py: Move ...
 * 	* td-add-doc/td_add_doc.py: ... here.
 *
 * 	* contrib/td-add-doc.in: Move ...
 * 	* td-add-doc/td-add-doc.in: ... here.
 *
 * 	* contrib/td_upload.py: Move ...
 * 	* td-add-doc/td_upload.py: ... here.
 *
 * 	* contrib/td-upload.in: Move ...
 * 	* td-add-doc/td-upload.in: ... here.
 *
 * 	* contrib/td_dsc_to_xml.py: Move ...
 * 	* td-generate/td_dsc_to_xml.py: ... here.
 *
 * 	* contrib/td-dsc-to-xml.in: Move ...
 * 	* td-generate/td-dsc-to-xml.in: ... here.
 *
 * 	* contrib/Makefile.am: Adjust.
 * 	* td-generate/Makefile.am: Adjust.
 * 	* td-add-doc/Makefile.am: Adjust.
 *
 * Revision 1.9  2002/07/22 14:06:21  bc6ix
 * fix license path, change version reporting to use 2 digits for each level
 *
 * Revision 1.8  2002/07/07 08:23:07  bc6ix
 * fix line endings
 *
 * Revision 1.7  2002/05/14 16:52:52  bc6ix
 * use CVS Log for revision history
 *
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://bclary.com/lib/js/license/mpl-tri-license.txt
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Netscape code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <bclary@netscape.com>
 *
 * ***** END LICENSE BLOCK ***** */

function xbDetectBrowser()
{
  var oldOnError = window.onerror;
  var element = null;

  window.onerror = null;
  
  // work around bug in xpcdom Mozilla 0.9.1
  window.saveNavigator = window.navigator;

  navigator.OS    = '';
  navigator.version  = parseFloat(navigator.appVersion);
  navigator.org    = '';
  navigator.family  = '';

  var platform;
  if (typeof(window.navigator.platform) != 'undefined')
  {
    platform = window.navigator.platform.toLowerCase();
    if (platform.indexOf('win') != -1)
      navigator.OS = 'win';
    else if (platform.indexOf('mac') != -1)
      navigator.OS = 'mac';
    else if (platform.indexOf('unix') != -1 || platform.indexOf('linux') != -1 || platform.indexOf('sun') != -1)
      navigator.OS = 'nix';
  }

  var i = 0;
  var ua = window.navigator.userAgent.toLowerCase();
  
  if (ua.indexOf('safari') != -1)
  {
    i = ua.indexOf('safari');
    navigator.family = 'safari';
    navigator.org = 'safari';
    navigator.version = parseFloat('0' + ua.substr(i+7), 10);
  }
  else if (ua.indexOf('opera') != -1)
  {
    i = ua.indexOf('opera');
    navigator.family  = 'opera';
    navigator.org    = 'opera';
    navigator.version  = parseFloat('0' + ua.substr(i+6), 10);
  }
  else if ((i = ua.indexOf('msie')) != -1)
  {
    navigator.org    = 'microsoft';
    navigator.version  = parseFloat('0' + ua.substr(i+5), 10);
    
    if (navigator.version < 4)
      navigator.family = 'ie3';
    else
      navigator.family = 'ie4'
  }
  else if (ua.indexOf('gecko') != -1)
  {
    navigator.family = 'gecko';
    var rvStart = ua.indexOf('rv:');
    var rvEnd   = ua.indexOf(')', rvStart);
    var rv      = ua.substring(rvStart+3, rvEnd);
    var rvParts = rv.split('.');
    var rvValue = 0;
    var exp     = 1;

    for (var i = 0; i < rvParts.length; i++)
    {
      var val = parseInt(rvParts[i]);
      rvValue += val / exp;
      exp *= 100;
    }
    navigator.version = rvValue;

    if (ua.indexOf('netscape') != -1)
      navigator.org = 'netscape';
    else if (ua.indexOf('compuserve') != -1)
      navigator.org = 'compuserve';
    else
      navigator.org = 'mozilla';
  }
  else if ((ua.indexOf('mozilla') !=-1) && (ua.indexOf('spoofer')==-1) && (ua.indexOf('compatible') == -1) && (ua.indexOf('opera')==-1)&& (ua.indexOf('webtv')==-1) && (ua.indexOf('hotjava')==-1))
  {
    var is_major = parseFloat(navigator.appVersion);
    
    if (is_major < 4)
      navigator.version = is_major;
    else
    {
      i = ua.lastIndexOf('/')
      navigator.version = parseFloat('0' + ua.substr(i+1), 10);
    }
    navigator.org = 'netscape';
    navigator.family = 'nn' + parseInt(navigator.appVersion);
  }
  else if ((i = ua.indexOf('aol')) != -1 )
  {
    // aol
    navigator.family  = 'aol';
    navigator.org    = 'aol';
    navigator.version  = parseFloat('0' + ua.substr(i+4), 10);
  }
  else if ((i = ua.indexOf('hotjava')) != -1 )
  {
    // hotjava
    navigator.family  = 'hotjava';
    navigator.org    = 'sun';
    navigator.version  = parseFloat(navigator.appVersion);
  }

  window.onerror = oldOnError;
}

xbDetectBrowser();

