# Copyright (C) 2005 Nicolas Burrus
# This file is part of Tidydoc.
#
# Tidydoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Tidydoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from glob import glob
import popen2
import os.path
import re

from td_config import config

def listdirs(directory):
  entries = os.listdir(directory)
  subdirs = []
  for entry in entries:
    if os.path.isdir(os.path.join(directory, entry)):
      subdirs.append(entry)
  return subdirs

def replace_in_template(tpl_file, subs):
  """Replace entries in tpl_file using subs"""
  f = open(tpl_file, "r")
  s = f.read()
  f.close()
  for key,item in subs.items():
    s = re.sub(key, item, s)
  return s

def rel_path(input_path):
  dir_basename = re.sub(config['input_path'], '', input_path)
  if len(dir_basename) > 0 and dir_basename[0] == '/':
    dir_basename = dir_basename[1:]
  return dir_basename

def get_output_path(input_path):
  return os.path.join(config['output_path'], rel_path(input_path))

def get_site_path(input_path):
  return os.path.join(config['site_root'], rel_path(input_path))

def exec_commands(cmds):
  subprocess = popen2.Popen4 ("sh")
  subprocess.tochild.write(cmds)
  subprocess.tochild.write("exit\n")
  subprocess.tochild.flush()
  lines = subprocess.fromchild.readlines()
  subprocess.tochild.close()
  subprocess.fromchild.close()
  status = subprocess.wait()
  return status, lines

def guess_desc_from_pdf(desc, doc_path):
  cmd = "pdfinfo \"%s\" 2> /dev/null | grep Title: | sed 's/Title:[ \t]\+//'\n" \
        % doc_path
  (status, output) = exec_commands(cmd)
  if status == 0 and len(output) > 0:
    desc['title'] = output[0].strip("\n")

  cmd = "pdfinfo \"%s\" 2> /dev/null | grep Author: | sed 's/Author:[ \t]\+//'\n" \
        % doc_path
  (status, output) = exec_commands(cmd)
  if status == 0 and len(output) > 0:
    desc['author'] = output[0].strip("\n")

  cmd = "pdfinfo \"%s\" 2> /dev/null | grep Pages: | sed 's/Pages:[ \t]\+//'\n" \
        % doc_path
  (status, output) = exec_commands(cmd)
  if status == 0 and len(output) > 0:
    desc['pages'] = output[0].strip("\n")

  cmd = "pdfinfo \"%s\" 2> /dev/null | grep CreationDate: | sed 's/CreationDate:[ \t]\+//'\n" \
        % doc_path
  (status, output) = exec_commands(cmd)
  if status == 0 and len(output) > 0:
    desc['date'] = output[0].strip("\n")
  return desc

def guess_desc_from_doc(doc_path):
  desc = { 'author' : "",
           'date'   : "",
           'pages'  : "",
           'title'  : ""}
  if re.match(".*\.pdf$", doc_path):
    return guess_desc_from_pdf(desc, doc_path)
  return desc
