# Copyright (C) 2005 Nicolas Burrus
# This file is part of Tidydoc.
#
# Tidydoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Tidydoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import re
from glob import glob

def parse(desc_file):
  f = open(desc_file, "r")
  lines = f.readlines()
  f.close()
  sections = {
    'Title'        : [],
    'Author'       : [],
    'Date'         : [],
    'Conf'         : [],
    'Pages'        : [],
    'Keywords'     : [],
    'Link'         : [],
    'Abstract'     : [],
    'Visibility'   : [],
    'Language'     : [],
    'Bibtex type'  : [],
    'Bibtex fields': [],
    'Comment'      : [],
    'Categories'   : []
  }
  current_section = ""
  current_lines = []
  for line in lines:
    new_section = False
    for sec in sections.keys():
      m = re.match('^' + sec + ':\s*(.*)', line)
      if m != None:
        # A new section has been found.
        sections[current_section] = current_lines
        if (m.group(1) != ''):
          current_lines = [m.group(1)]
        else:
          current_lines = []
        current_section = sec
        new_section = True
        break
    if not new_section:
      m = re.match('^\s*(.*)$',line)
      if (m.group(1) != '' and m.group(1)[0] != '%'):
        current_lines.append(m.group(1))
  sections[current_section] = current_lines
  del sections['']
  return sections

def docname_from_dsc(sections, orig_file):
  try:
    title = sections['Title'][0].lower()
    title = re.sub('[^\w]+', '_', title)
  except:
    raise "Error: no title"

  try:
    conf = sections['Conf'][0].lower()
    conf = re.sub('[^\w]+', '_', conf)
  except:
    conf = ""

  try:
    author = sections['Author'][0].lower()
    author = author.split(' ')[-1]
  except:
    author = "unknown"

  try:
    date = re.match('.*\d\d(\d\d).*', sections['Date'][0]).group(1)
  except:
    date = ""

  ext = None
  m = re.match('^.*\.(\w+)$', orig_file)
  if m:
    ext = m.group(1)
  if ext == None:
    raise "Error: no extension on the document filename."

  filename = author + '.' + date + '.' + conf + '.' + title + '.' + ext
  return filename

def doc_filename_from_dsc(dsc):
  files = glob(re.sub('\.dsc$', '*', dsc))
  for f in files:
    if not re.match('.*\.dsc$', f) and not re.match('.*\.xml$', f):
      return f
