# Copyright (C) 2005 Nicolas Burrus
# This file is part of Tidydoc.
#
# Tidydoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Tidydoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, sys

import ac_config

config = {}

def read_config(config_file = None):
  global config
  if (config_file):
    candidates = [config_file]
  else:
    candidates = [os.path.join(os.getenv("HOME"), ".tidydoc.conf"),
                  os.path.join(ac_config.prefix, "etc/tidydoc.conf"),
                  "/etc/tidydoc/tidydoc.conf",
                  "/etc/tidydoc.conf"]
  found = False
  for f in candidates:
    if not os.path.exists(f):
      continue
    else:
      found = True
      print "Reading from", f
      try:
        execfile(f, config, config)
        break
      except:
        sys.stderr.write(f + " is not a valid configuration file.")
        sys.stderr.write(sys.exc_info())
  
  if not found:
    raise "No configuration file found."
