#!/usr/bin/env python
#
# Copyright (C) 2005 Nicolas Burrus
# This file is part of Tidydoc.
#
# Tidydoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Tidydoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from getopt import getopt
from glob import glob
import os, re, sys

import ac_config
import td_config
from td_config import config
import td_doctree
import td_dsc_to_xml
import td_html
from td_tools import *

def print_help():
  sys.stderr.write(
"""Usage: td-generate [options]

  Options

  -c, --config configfile  Config file to use.
  -v, --version            Print version number.

Nicolas Burrus <nes@lrde.epita.fr>
""")

def parse_command_line(argv):
  try: (options, args) =  getopt(argv[1:], "vc:", ["version", "config"])
  except:
    print_help()
    sys.exit(1)

  if len(args) != 0:
    print_help()
    sys.exit(1)

  cmd_options = { 'config_file' : None }

  for option in options:
    if option[0] == "-v" or option[0] == "--version":
      print "Tidydoc " + ac_config.version
      print "Nicolas Burrus <nes@lrde.epita.fr>"
      sys.exit(0)
    if option[0] == "-c" or option[0] == "--config":
      cmd_options['config_file'] = option[1]      

  return cmd_options

def dump_categories(f, doctree, indent = 0):
  f.write("% " + " " * indent + rel_path(doctree.path) + "\n")
  for subdir in doctree.subdirs:
    dump_categories(f, subdir, indent + 2)

def __main__():
  cmd_options = parse_command_line(sys.argv)
  try:
    td_config.read_config(cmd_options['config_file'])
  except:
    sys.stderr.write(str(sys.exc_info()[0]) + "\n")
    sys.exit(1)

  # Convert dsc files.
  td_dsc_to_xml.run()

  doctree = td_doctree.build(config['input_path'])
  td_doctree.dump(doctree)
  f = open(config['categories_path'], "w")
  dump_categories(f, doctree)
  f.close()
  td_html.generate(doctree)
  td_html.generate_treeview(doctree)

if __name__ == "__main__":
  __main__()
  
