#!/usr/bin/env python
# -*- coding: utf8 -*-

##	Things Copyright(C) 2009 Donn.C.Ingle
##
##	Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##  This file is part of Things.
##
##  Things is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  Things is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with Things.  If not, see <http://www.gnu.org/licenses/>.


from Things.ThingsApp import *
from Things.Thinglets import *
from Things.BoxOfTricks import *

from math import radians as d2r # degrees to radians

zeropos = Props()

class Picture(Thing):
	def __init__(self,topid):
		Thing.__init__(self,"thepic")
		self.keys(  "#--#------#--#",Props(),Props(sz=0.5),Props(sz=1.2),zeropos )
		self.stops( "^")
		self.labels(".^","pulse")

		self.topid=topid
		self.pic_id=RootStore[topid].pic_key
	def draw(self,ctx,fr):
		BOS[self.pic_id].draw(ctx,-128,-128)

class SayWhat(Thing):
	"""
	This is a box with text on it.
	"""
	def __init__(self, topid):
		Thing.__init__(self,"some_text")
		self.keys(   "#----#-----#",Props(y=101),Props(y=0),Props(y=101))
		self.stops(  "^....^")
		self.labels( "......^","fade")

		self.topid = topid
		fname = "Iwona Condensed - Heavy Italic 12"
		self.text = '<span font_desc="%s" foreground="#ffffff">%s</span>' % (fname, RootStore[topid].text )

		self.tbox = TextBlock()
		self.tbox.setup(self.text, x=-100, y=20, align=pango.ALIGN_CENTER, width=200)

	def draw(self,ctx,fr):
		ctx.set_source_rgba(0.5,0.5,0.5,0.5)
		ctx.rectangle(-100,0,200,100)
		ctx.fill()
		self.tbox.draw(ctx)


class FrameClip(ClipThing):
	"""
	Holds and clips other objects.
	"""
	def __init__(self, topid):
		ClipThing.__init__(self,"boxclip")
		self.keys("#",zeropos)
		self.topid = topid

		## The FrameClip holds the Picture
		self.iPicture = Picture(topid)
		self.add( self.iPicture)

		# It also hold the SayWhat
		self.SW = SayWhat(topid)
		self.add(self.SW)

		self.RR = RoundRect()
		self.RR.setup(width=200,height=200,radius=5)

	def draw(self,ctx,fr):
		self.RR.draw(ctx)
	
class DragSignal( HitThing ):
	"""
	Indicates where the drag area is.
	"""
	def __init__ ( self ) :
		HitThing.__init__ ( self, "drag_signal")
		self.keys(  "#----#---#",Props(a=0),Props(a=0.4),Props(a=0,sz=0.1))
		self.stops( "^....^")
		self.labels("......^","fade")

		self.RR = RoundRect()
		self.RR.setup(width=90,height=90,radius=15)

	def draw(self,ctx,fr):
		if self.currentFrame.props.a == 0: return
		ctx.set_source_rgb(0,0,0)
		self.RR.draw(ctx)
		ctx.fill()

	def drawHitarea ( self, ctx, fr ):
		self.RR.draw(ctx)
	def onEnter(self,ux,uy):
		self.goPlay(2)
	def onLeave(self,ux,uy):
		self.goPlay("fade")

class HitBox( HitThing ):
	"""
	Control the dragging and rotating of the parentThing: a PictureControl.
	This is an odd design, the PictureControl may just as well have been 
	the HitThing.
	"""
	def __init__ ( self, topid ) :
		HitThing.__init__ ( self, "hitbox")
		self.keys("#",Props())

		self.topid=topid

		## The HitBox holds the FrameClip
		self.iFrameClip = FrameClip(topid)
		self.add(self.iFrameClip, layer=2)
		
		## It also holds the DragSignal
		self.add(DragSignal(), layer=3)

		self.RR = RoundRect()
		self.RR.setup(width=200,height=200,radius=5)

	def drawHitarea ( self, ctx, fr ):
		self.RR.draw(ctx)

	def onEnter ( self, ux, uy ):
		self.iFrameClip.SW.goPlay(1)	

	def onLeave(self,x,y):
		app.cursor()
		self.iFrameClip.SW.goPlay("fade")

	def onRollover(self,ux,uy):
		if self.inside(90,90,ux,uy):
			app.cursor("HAND1")
		else:
			app.cursor("STAR")

	def onDown ( self, x, y ):
		self.parentThing.setupRot()
		self.parentThing.toTop() # This works, but the events are haphazard. Bugs; I'm afraid to say :(

	def inside(self,w,h,x,y):
		## requires USER SPACE coords to look INSIDE this thing.
		cw = w/2
		ch = h/2
		if x < -cw: return False
		if x > cw: return False
		if y < -ch: return False
		if y > ch: return False
		return True
	
	def onDrag ( self, x, y, ux, uy ):
		# I only want to drag when the center is hit
		if self.inside(90,90,ux,uy):
			self.parentThing.changeProps(x=x,y=y)
		# Rotating happens on the edges
		else:
			self.parentThing.spinByXY()

	def onRelease ( self ):
		self.iFrameClip.iPicture.goPlay("pulse")

class PictureControl(Thing):
	def __init__(self, id, pic_key, text, props):
		Thing.__init__(self,id)
		self.keys( "#",props)

		self.text = text
		self.pic_key = pic_key

		RootStore[id]=self # Keep me in the 'store' so other things can find me quickly.

		## The PictureControl holds the HitBox
		self.HB=HitBox(topid=id)
		self.add(self.HB)

		self.oc=(0,0)
		self.iag = 0 #Initial Angle Gap

		self.RR = RoundRect()
		self.RR.setup(width=220,height=220,radius=15)

	def draw(self, ctx, fr):
		ctx.set_source_rgb(0.2,0.2,0.2)
		self.RR.draw(ctx)
		ctx.fill()

	def angleInc(self,rot):
		olda = self.currentFrame.props.rot
		da = rot - olda
		## Take into account the initial angle gap: iag
		a = olda + da - self.iag
		return a
	
	def getXYangle(self,x,y):
		dx = self.oc[0] - x
		dy = self.oc[1] - y
		r = math.atan2(dy, dx) #magically gets an angle from an xy pos. Thanks!
		return r

	def setupRot(self):
		x,y=app.mouse()
		self.iag = self.getXYangle(x,y) - self.currentFrame.props.rot

	def spinByXY(self):
		x,y=app.mouse()
		xya=self.getXYangle(x,y)
		a = self.angleInc(xya)
		self.changeProps ( rot=a )
	
class Backdrop(Thing):
	def __init__(self):
		Thing.__init__(self,id="backdrop")
		self.keys("#",Props())

		fname = "Comic Strip MN 11"
		txt="Drag from the middle, rotate from the edges.\n"
		txts='<span font_desc="7">Yeah, the handling is rough. I need help with the event code.</span>'
		self.text = '<span font_desc="%s" foreground="#ffffff">%s</span>' % (fname, txt + txts )

		self.tbox = TextBlock()
		self.tbox.setup(self.text, x=-300, y=250, align=pango.ALIGN_CENTER, width=600)

	def draw(self, ctx, fr):
		ctx.set_source_rgb(0, 0, 0)
		ctx.paint() # paint black
		self.tbox.draw(ctx) # plonk text down

	
RootStore = {} 

## Get a Bag of stuff
BOS = BagOfStuff()

# Add stuff to it
BOS.add("common.stuff/Comic.ttf","font")
BOS.add("common.stuff/IwonaCondHeavy-Italic.otf","font2")
BOS.add("images.stuff/evo1.png","evo1")
BOS.add("images.stuff/evo2.png","evo2")
BOS.add("images.stuff/evo3.png","evo3")
BOS.add("images.stuff/evo4.png","evo4")

## Get an app ref.
app = AllThings ( 600, 600, speed = 20, title = "TEST")

## Add Things to app
app.add(Backdrop())

app.add( PictureControl("picc1","evo1",'Can I haz<span foreground="#ff0000"> LOLZ</span> pleeze.', Props(x=100,y=5,rot=d2r(0))), layer=2)
app.add( PictureControl("picc2","evo2","Gone fishing. Not coming back.\nEver.", Props(x=-100,y=55,rot=d2r(60))), layer=3)
app.add( PictureControl("picc3","evo3","Images generated by Evolvotron!", Props(x=10,y=-155,rot=d2r(35))), layer=5)
app.add( PictureControl("picc4","evo4","Written in Python on Kubuntu Gnu/Linux.", Props(x=200,y=255,rot=d2r(20))), layer=6)

#app.showGrid() # optional for debugging

## My Flying-Spaghetti-Monster, it's full of stars :O
app.comeToLife ( )

