##	Things Copyright(C) 2009 Donn.C.Ingle
##
##	Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##  This file is part of Things.
##
##  Things is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  Things is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with Things.  If not, see <http://www.gnu.org/licenses/>.

"""Checks for all the necessary dependancies that Things needs to run."""
## 11 April 2009

import platform
v = [int(n) for n in platform.python_version().split('.')]
if v[0] > 2:
	print "Sorry, this API has not made it to Python 3. Try using Python 2.5 instead."
	raise SystemExit

## Have a look for psyco and use it.
## Dec 8 2007: Horrifyingly, this eats memory at such a rate that
## within a few minutes, the entire system dies.
## I am sure my code is shoddy and I am doing foolish things,
## but remarking psyco has vastly improved the problem.
##try:
##	import psyco
##	psyco.full()
##except ImportError:
##	print 'Info:\n "python-psyco" is not installed,\n the program will simply run slower.\n If you can install it, do so.'

## Check what modules the user has and report back on error.
_needsGtk, _needsPyparsing = False, False
_needsPythonCairo, _needsRSVG = False, False
_gtkTooOld = False
_cairoTooOld = False
_moduleProblem = False
_versTuple =()
_minGtkVers =(2, 12) # Set as needed
_minCairoVers =(1,4,0)

try:
	import pyparsing as PP
except:
	_needsPyparsing = True
	_moduleProblem = True
try:
	import gtk
	_versTuple = gtk.pygtk_version
	import gobject
	try:
		from gtk import gdk
	except: 
		pass # It complains here if gtk ain't around.
except:
	_needsGtk = True
	_moduleProblem = True
	
if not _needsGtk and _versTuple < _minGtkVers:
	vers = "%s.%s" %(_versTuple[0], _versTuple[1 ])
	rightver = "%s.%s" %(_minGtkVers[0 ], _minGtkVers[1 ])
	_gtkTooOld = True
	_moduleProblem = True
	
try:
	import cairo
	if cairo.version_info < _minCairoVers:
		_cairoTooOld = True
		cairoVers = cairo.cairo_version_string()
		rightCairoVers = "%s.%s" %(_minCairoVers[0 ], _minCairoVers[1 ])
		_moduleProblem = True
except: 
	_needsPythonCairo = True
	_moduleProblem = True

try:
	import rsvg
except:
	_needsRSVG = True
	_moduleProblem = True

if _moduleProblem:
	print "Oh darn, there's a problem. Here's some help for you.\n"
	
	generally = """
 General Info:
 Ensure these modules are all installed:
 1. python-gtk2
 2. python-gnome2-desktop
 3. python-gobject
 4. python-cairo
 5. python-pyparsing
  
 If you *still* cannot run this app, then you may have a
 system that is too far out of date, or badly broken.
 
 I would suggest making sure that GTK, Gnome, Python,
 Pyparsing and pyCairo are all installed and working.
 
 Failing this, I know it's a pain, but install a new distro.
 """
	
	if _gtkTooOld:
		print """ Your version of pygtk(%s) is out of date.
 This is either easy to fix, or complete hell on earth.
 
 Check that "python-gtk2" is at least %s""" %(vers, rightver)
		print generally
		raise SystemExit
	
	if _cairoTooOld:
		print """ Your version of python-cairo(%s) is out of date.
 This may be tough to fix.
 
 Check that "python-cairo" is at least %s""" %(cairoVers, rightCairoVers)
		print generally
		raise SystemExit
		
	## We have gtk and cairo versions done, now the rest
	mods =[]

	if _needsPyparsing:
		mods.append('"python-pyparsing"')
	if _needsGtk:
		mods.append('"python-gtk2"')
	if _needsPythonCairo:
		mods.append('"python-cairo"')
	if _needsRSVG:
		mods.append('"python-gnome2-desktop" -- to get rsvg"')
		
	if len(mods) == 1: plural = "package" 
	else: plural = "packages"
	
	if mods: 
		print ' This program relies on other software\n that must be installed first.\n\n'
		' You can clear this up by installing the %s named:\n' % plural
  
		for m in mods:
			print " ", m
		print '\n When you have done that, try this program again.'
 
	print generally
	raise SystemExit	
