<?php

/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

/* 
  * donations_1_year.php
  * this is a "chart" for use with the pChart module
  *  
  * the purpose of this chart is to show the donations and
  * interactions grouped and totalled by month for
  * the last year.  it is used on the front page after login
  * 
  * please see the /pChart/readme.txt for more info
  * 
  */ 

/* mneme project includes */
@define('MnemeConst', TRUE); // to allow access to include
require_once('../../../include/common.php');

// dont let non logged in users to access this png directly
// here we'll check if they are logged in
if (empty($_SESSION['is_logged_in'])) {
	// what's my directory minus the document root?
	$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
	// chop off the last two directories to get error path
	$he_is_there = dirname(dirname(dirname($i_am_here)));
	header("Location: $he_is_there/error.php?error=cannot view png error 32588");
	exit;
}

 /* pChart library inclusions */
 include("../class/pData.class.php");
 include("../class/pDraw.class.php");
 include("../class/pImage.class.php");

/* Create and populate the pData object */
 $MyData = new pData();  
 
//$MyData->addPoints(array(8,10,24,25,25,24,23,22,20,12,10,4),"Interactions");
//$MyData->addPoints(array(2,4,6,4,5,3,6,4,5,8,6,1),"Donations");
 
 /*****  Interactions Array Building Code Begin  ****/
/* create array to populate interactions */
 $array_of_year = array(
    1 => 0,
    2 => 0,
    3 => 0,
    4 => 0,
    5 => 0,
    6 => 0,
    7 => 0,
    8 => 0,
    9 => 0,
    10 => 0,
    11 => 0,
    12 => 0
);

// make the query
$select_interactions_1yr = "select date_part('mon', int_date), count(*)
from constituents_interactions
where int_date > (now() - interval '1 year')
group by date_part('mon', int_date)
order by date_part;";

// execute it
$select_interactions_1yr_result = pg_query($dbconn, $select_interactions_1yr);

if (!$select_interactions_1yr_result) {
	echo 'the select interactions failed';  // send to error page from here?
} else {
	while ($row = pg_fetch_row($select_interactions_1yr_result)) {
	$array_of_year[$row[0]] = $row[1];
	}
}

/* Create and populate the pData object */ 
 $MyData = new pData();

$MyData->addPoints(array(
 $array_of_year[1],
 $array_of_year[2],
 $array_of_year[3],
 $array_of_year[4],
 $array_of_year[5],
 $array_of_year[6],
 $array_of_year[7],
 $array_of_year[8],
 $array_of_year[9],
 $array_of_year[10],
 $array_of_year[11],
 $array_of_year[12] ),"Interactions");
/*****  Interactions Array Building Code End  ****/

/*****  Donations Array Building Code Begin  ****/
/* create array to populate interactions */
 $array_of_year_2 = array(
    1 => 0,
    2 => 0,
    3 => 0,
    4 => 0,
    5 => 0,
    6 => 0,
    7 => 0,
    8 => 0,
    9 => 0,
    10 => 0,
    11 => 0,
    12 => 0
);

// make the query
$select_donations_1yr = "select date_part('mon', int_date), 
cast( sum(amount) as numeric ) as total 
from constituents_interactions where int_date > (now() - interval '1 year') 
group by date_part('mon', int_date) order by date_part;";

// execute it
$select_donations_1yr_result = pg_query($dbconn, $select_donations_1yr);

if (!$select_donations_1yr_result) {
	echo 'the select donations failed';  // send to error page from here?
} else {
	while ($row2 = pg_fetch_row($select_donations_1yr_result)) {
	$array_of_year_2[$row2[0]] = $row2[1];
	}
}

/* Populate the pData object */ 
$MyData->addPoints(array(
 $array_of_year_2[1],
 $array_of_year_2[2],
 $array_of_year_2[3],
 $array_of_year_2[4],
 $array_of_year_2[5],
 $array_of_year_2[6],
 $array_of_year_2[7],
 $array_of_year_2[8],
 $array_of_year_2[9],
 $array_of_year_2[10],
 $array_of_year_2[11],
 $array_of_year_2[12] ),"Donations");
/*****  Donations Array Building Code End  ****/
 
 $MyData->setSerieDrawable("Donations",FALSE);
 $MyData->setAxisName(0,"Interactions");
 
 $MyData->addPoints(array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"),"Labels");
 $MyData->setSerieDescription("Labels","Months");
 $MyData->setAbscissa("Labels");

/* Create the pChart object */
 $myPicture = new pImage(700,370,$MyData);

 /* Turn of Antialiasing */
 $myPicture->Antialias = FALSE;

 /* Add a border to the picture */
 $myPicture->drawGradientArea(0,0,700,370,DIRECTION_VERTICAL,array("StartR"=>240,"StartG"=>240,"StartB"=>240,"EndR"=>80,"EndG"=>80,"EndB"=>80,"Alpha"=>100));
 $myPicture->drawGradientArea(0,0,700,370,DIRECTION_HORIZONTAL,array("StartR"=>240,"StartG"=>240,"StartB"=>240,"EndR"=>80,"EndG"=>80,"EndB"=>80,"Alpha"=>20));
 $myPicture->drawRectangle(0,0,699,369,array("R"=>0,"G"=>0,"B"=>0));

 /* Set the default font */
 $myPicture->setFontProperties(array("FontName"=>"../fonts/pf_arma_five.ttf","FontSize"=>6));

 /* Write the chart title */ 
 $myPicture->setFontProperties(array("FontName"=>"../fonts/verdana.ttf","FontSize"=>11));
 $myPicture->drawText(350,20,"Interactions and Donations 12 Months",array("FontSize"=>10,"Align"=>TEXT_ALIGN_BOTTOMMIDDLE));
 
  /* Define the 1st chart area */
 $myPicture->setGraphArea(60,40,660,170); // 60, top, 660, bottom  (60,70,660,200)
 $myPicture->setFontProperties(array("FontName"=>"../fonts/verdana.ttf","FontSize"=>6));

 /* Draw the scale */
 $scaleSettings = array("DrawSubTicks"=>TRUE,"CycleBackground"=>TRUE,"RemoveXAxis"=>TRUE);
 $myPicture->drawScale($scaleSettings);
 $myPicture->drawBarChart(array("Surrounding"=>-30,"InnerSurrounding"=>30));

 /* Define the 2nd chart area */
 $myPicture->setGraphArea(60,190,660,330);  // 60, top, 660, bottom  (60,220,660,360)
 $myPicture->setFontProperties(array("FontName"=>"../fonts/verdana.ttf","FontSize"=>6));

 /* Draw the scale */
 $scaleSettings = array("DrawSubTicks"=>TRUE,"CycleBackground"=>TRUE);
 $MyData->setSerieDrawable("Interactions",FALSE);
 $MyData->setSerieDrawable("Donations",TRUE);
 $MyData->setAxisName(0,"Donations");
 $myPicture->drawScale($scaleSettings);
 $myPicture->drawBarChart(array("Surrounding"=>-30,"InnerSurrounding"=>30));
 
 /* Turn on shadow computing */ 
 $myPicture->setShadow(TRUE,array("X"=>1,"Y"=>1,"R"=>0,"G"=>0,"B"=>0,"Alpha"=>10));

 /* Draw the chart */
 $myPicture->autoOutput("pictures/example.drawScale.labels.png");
 
?>
