<?php
/* ***************************************************************************

    A Constituent management module for the mneme project.
    Copyright (C) 2013 AACA
    support@aaca-boston.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("../include_mod.php");

// tell the browser what we're about to do
header("Content-type: application/csv");
header("Content-Disposition: attachment; filename=top_40_donors_2_years.csv");
header("Pragma: no-cache");
header("Expires: 0");

$query_select_group_top20 = "select ci.user_id, sum(ci.amount) as total, cm.individual_prefix, cm.first_name, cm.middle_name, cm.last_name, ";
$query_select_group_top20 .= "cm.display_name, cm.current_employer, cm.organization_name, cm.individual_suffix, cm.email, cm.alt_email "; 
$query_select_group_top20 .= "from constituents_members cm, constituents_interactions ci ";
$query_select_group_top20 .= "where cm.user_id = ci.user_id ";
$query_select_group_top20 .= "and ci.int_date > now() - interval '2 years' ";
$query_select_group_top20 .= "and ci.amount > '$0.01' ";
$query_select_group_top20 .= "group by ci.user_id, cm.individual_prefix, cm.first_name, cm.middle_name, cm.last_name,  ";
$query_select_group_top20 .= "cm.display_name, cm.current_employer, cm.organization_name, cm.individual_suffix, cm.email, cm.alt_email  ";
$query_select_group_top20 .= "order by total desc limit 40;";

$query_select_group_top20_1 = pg_query($dbconn, $query_select_group_top20) or die('Query failed: ' . pg_last_error());

$my_array_top20 = pg_fetch_all($query_select_group_top20_1);

// i'm having output issues.  using strip_tags, str_replace and trim to help
$find_new_lines = array("\r\n", "\n", "\r", ",");
$replace_new_lines = '';

// top row
echo "user_id, total, individual_prefix, first_name, middle_name, last_name, display_name, current_employer, organization_name, individual_suffix, email, alt_email \n";

foreach ($my_array_top20 as $v_element) {
	
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['user_id'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['total'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['individual_prefix'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['first_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['middle_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['last_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['current_employer'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['organization_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['individual_suffix'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['email'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['alt_email'])));

	echo "\n";
		
}

?>
