<?php
/* ***************************************************************************

    The Mneme Project
    Copyright (C) 2012 AACA
    support@aaca-boston.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("../include_mod.php");

$today = date("Ymd");

// tell the browser what we're about to do
header("Content-type: application/csv");
header("Content-Disposition: attachment; filename=$today.all_constituents.csv");
header("Pragma: no-cache");
header("Expires: 0");

/*
 * select everybody except the following:
 * 1.  no do not mail, email, phone, sms or trade
 * 2.  no deceased
 * 3.  display_name must be > 1 character
 * 
 * select:
 * 1.  preferred contact info
 * 
 */
 
$query_select_group = "select user_id, individual_prefix, first_name, middle_name, last_name, ";
$query_select_group .= "display_name, current_employer, organization_name, individual_suffix ";
$query_select_group .= "from constituents_members  ";
$query_select_group .= "where (donotmail is null or donotmail = '' or donotmail = ' ') ";
$query_select_group .= "and (is_deceased is null or is_deceased = '' or is_deceased = ' ' or is_deceased = 'n') ";
$query_select_group .= "and (donotphone is null or donotphone = '' or donotphone = ' ') ";
$query_select_group .= "and (donotsms is null or donotsms = '' or donotsms = ' ') ";
$query_select_group .= "and (donottrade is null or donottrade = '' or donottrade = ' ') ";
$query_select_group .= "and (donotemail is null or donotemail = '' or donotemail = ' ') ";
$query_select_group .= "and character_length(display_name) > 1;";

$query_select_group_1 = pg_query($dbconn, $query_select_group) or die('Query failed: ' . pg_last_error());

$my_array3 = pg_fetch_all($query_select_group_1);

// i'm having output issues.  using strip_tags, str_replace and trim to help
$find_new_lines = array("\r\n", "\n", "\r", ",");
$replace_new_lines = ' ';

// building top row
echo "user_id, individual_prefix, first_name, middle_name, last_name, display_name, current_employer, organization_name, individual_suffix, street_address, supplemental_address_1, supplemental_address_2, city, state1, zip, phone, email, website";

echo "\n";

foreach ($my_array3 as $v_element) {
	
			$an_id_num = $v_element['user_id'];
			$the_return=select_alt_choice("$an_id_num"); // using a function in include_mod.php to get preferred contact info
			
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($an_id_num)));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['individual_prefix'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['first_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['middle_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['last_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['current_employer'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['organization_name'])));
	echo ',';
	echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['individual_suffix'])));
	echo ',';
	
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy0'])));  // addy 1
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy1'])));  // addy 2
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy2'])));  // addy 3
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['city1'])));  // city
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['state1'])));  // state
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['zip1'])));  // zip
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[1]['tele1'])));  // tele
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[2]['email1'])));  // email
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[3]['website1'])));  // website 
		
	echo "\n";
			
}

echo "this report selects everybody except no do not mail email phone sms trade or is deceased and display_name must be > 1 character";

?>
