<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

// the purpose of this page is to process any variable reports (not canned)

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

// don't let volunteers access reports!
if ( $_SESSION['ses_user_group_1'] == 'volunteer' ) {
	# send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect volunteer permission. error 12287");
	exit;
}

// a couple of checks to verify they came from the correct form
// is this value set?  we do this again at the bottom
if (!isset($_GET['report'])) {
	
	// how did they get here?  send them to error form
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect report form value. error 23407");
	exit;
}
// then remove tags
$get_value=pg_escape_string(strip_tags(trim($_GET['report'])));

// use if statements to give the user the correct output

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

if ($get_value == 'group') {
	// tell the browser what we're about to do
	header("Content-type: application/csv");
	header("Content-Disposition: attachment; filename=constit_by_group.csv");
	header("Pragma: no-cache");
	header("Expires: 0");
	
	// sanatize
	$reports_process_post_group=pg_escape_string($_POST['group']);
	
	$query_select_group = "select user_id, display_name, organization_name, current_employer ";
	$query_select_group .= "from constituents_members where $reports_process_post_group = 'x';";

	$query_select_group_results = pg_query($dbconn, $query_select_group) or die('Query failed: ' . pg_last_error());

	$my_array3 = pg_fetch_all($query_select_group_results);

	// i'm having output issues.  using strip_tags, str_replace and trim to help
	$find_new_lines = array("\r\n", "\n", "\r", ",");
	$replace_new_lines = ' ';

	// top row
	echo "user_id,display_name,organization_name, current_employer, street_address,supplemental_address_1,supplemental_address_2,city,state1,zip,phone,email,website \n";

	foreach ($my_array3 as $v_element) {
		
		$an_id_num = $v_element['user_id'];
		$the_return=select_alt_choice("$an_id_num"); // using a function in include_mod.php
		
		echo $an_id_num;
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['organization_name'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['current_employer'])));
		echo ',';
		
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy0'])));  // addy 1
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy1'])));  // addy 2
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy2'])));  // addy 3
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['city1'])));  // city
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['state1'])));  // state
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['zip1'])));  // zip
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[1]['tele1'])));  // tele
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[2]['email1'])));  // email
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[3]['website1'])));  // website 
			
		echo "\n";

	}
}

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

if ($get_value == 'campaign') {
	
	// sanatize
	$reports_process_post_group=pg_escape_string($_POST['campaign']);
	
	// tell the browser what we're about to do
	header("Content-type: application/csv");
	header("Content-Disposition: attachment; filename=int_by_campaign.csv");
	header("Pragma: no-cache");
	header("Expires: 0");

	$query_select_group = "select ci.campaign_id, ci.int_type, ci.medium, ci.int_date,  ";
	$query_select_group .= "ci.amount, ci.int_notes, cm.display_name, email, alt_email, ";
	$query_select_group .= "cm.organization_name, cm.current_employer ";
	$query_select_group .= "from constituents_interactions ci, constituents_members cm ";
	$query_select_group .= "where ci.user_id = cm.user_id ";
	$query_select_group .= "and lower(ci.campaign_id) = lower('$reports_process_post_group');";

	$query_select_group_1 = pg_query($dbconn, $query_select_group) or die('Query failed: ' . pg_last_error());

	$my_array4 = pg_fetch_all($query_select_group_1);

	// i'm having output issues.  using strip_tags, str_replace and trim to help
	$find_new_lines = array("\r\n", "\n", "\r", ",");
	$replace_new_lines = ' ';

	// top row
	echo "campaign_id,int_type,medium,int_date,amount,int_notes,display_name,email,alt_email,organization_name,current_employer \n";

	foreach ($my_array4 as $v_element) {
		
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['campaign_id'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_type'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['medium'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_date'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['amount'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_notes'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['email'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['alt_email'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['organization_name'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['current_employer'])));

		echo "\n";
			
		}
}

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

if ($get_value == 'date_range') {
	
	// sanatize
	$reports_process_post_date_start=pg_escape_string(trim($_POST['date_range_start']));
	$reports_process_post_date_end=pg_escape_string(trim($_POST['date_range_end']));
	
	// let's verify they typed in a correctly formatted date using our check_date function
	$is_the_date_correct = valid_date($reports_process_post_date_start, $format='YYYY-MM-DD');
	if ($is_the_date_correct) {
		// all is well.  continue on
	} else {
		// they did the date wrong
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=not a valid date. error 21871");
		exit;
	}
	
	$is_the_date_correct = valid_date($reports_process_post_date_end, $format='YYYY-MM-DD');
	if ($is_the_date_correct) {
		// all is well.  continue on
	} else {
		// they did the date wrong
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=not a valid date. error 21871");
		exit;
	}
	
	// tell the browser what we're about to do
	header("Content-type: application/csv");
	header("Content-Disposition: attachment; filename=int_by_date_range.csv");
	header("Pragma: no-cache");
	header("Expires: 0");

	$query_select_group = "select ci.campaign_id, ci.int_type, ci.medium, ci.int_date,  ";
	$query_select_group .= "ci.amount, ci.amount_type, ci.int_notes, cm.user_id, cm.display_name, cm.email, cm.alt_email ";
	$query_select_group .= "from constituents_interactions ci, constituents_members cm ";
	$query_select_group .= "where ci.user_id = cm.user_id ";
	//$query_select_group .= "and amount > '$0.01' ";
	$query_select_group .= "and int_date > '$reports_process_post_date_start' ";
	$query_select_group .= "and int_date < '$reports_process_post_date_end';";

	$query_select_group_1 = pg_query($dbconn, $query_select_group) or die('Query failed: ' . pg_last_error());

	$my_array4 = pg_fetch_all($query_select_group_1);

	// i'm having output issues.  using strip_tags, str_replace and trim to help
	$find_new_lines = array("\r\n", "\n", "\r", ",");
	$replace_new_lines = '';

	// top row
	echo "campaign_id,int_type,medium,int_date,amount,amount_type,int_notes,user_id,display_name,email,alt_email \n";

	foreach ($my_array4 as $v_element) {
		
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['campaign_id'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_type'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['medium'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_date'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['amount'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['amount_type'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_notes'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['user_id'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['email'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['alt_email'])));

		echo "\n";
			
		}
} 

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

if ($get_value == 'email_address') {
	// sanatize
	$reports_process_post_group=pg_escape_string($_POST['v_email_address']);
	
	// tell the browser what we're about to do
	header("Content-type: application/csv");
	header("Content-Disposition: attachment; filename=int_by_email_address.csv");
	header("Pragma: no-cache");
	header("Expires: 0");

	$query_select_group = "select ci.campaign_id, ci.int_type, ci.medium, ci.int_date,  ";
	$query_select_group .= "ci.amount, ci.int_notes, cm.display_name, email, alt_email ";
	$query_select_group .= "from constituents_interactions ci, constituents_members cm ";
	$query_select_group .= "where ci.user_id = cm.user_id ";
	$query_select_group .= "and ( lower(cm.email) = lower('$reports_process_post_group') ";
	$query_select_group .= "or lower(cm.alt_email) = lower('$reports_process_post_group') ) ;";

	$query_select_group_1 = pg_query($dbconn, $query_select_group) or die('Query failed: ' . pg_last_error());

	$my_array4 = pg_fetch_all($query_select_group_1);

	// i'm having output issues.  using strip_tags, str_replace and trim to help
	$find_new_lines = array("\r\n", "\n", "\r", ",");
	$replace_new_lines = ' ';

	// top row
	echo "campaign_id,int_type,medium,int_date,amount,int_notes,display_name,email, alt_email \n";

	foreach ($my_array4 as $v_element) {
		
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['campaign_id'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_type'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['medium'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_date'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['amount'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_notes'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['email'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['alt_email'])));

		echo "\n";
			
		}
}

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

if ($get_value == 'display_name') {
	// sanatize
	$reports_process_post_group=pg_escape_string($_POST['v_display_name']);
	
	// tell the browser what we're about to do
	header("Content-type: application/csv");
	header("Content-Disposition: attachment; filename=int_by_display_name.csv");
	header("Pragma: no-cache");
	header("Expires: 0");

	$query_select_group = "select ci.campaign_id, ci.int_type, ci.medium, ci.int_date,  ";
	$query_select_group .= "ci.amount, ci.int_notes, cm.display_name, email, alt_email ";
	$query_select_group .= "from constituents_interactions ci, constituents_members cm ";
	$query_select_group .= "where ci.user_id = cm.user_id ";
	$query_select_group .= "and lower(cm.display_name) = lower('$reports_process_post_group');";

	$query_select_group_1 = pg_query($dbconn, $query_select_group) or die('Query failed: ' . pg_last_error());

	$my_array4 = pg_fetch_all($query_select_group_1);

	// i'm having output issues.  using strip_tags, str_replace and trim to help
	$find_new_lines = array("\r\n", "\n", "\r", ",");
	$replace_new_lines = ' ';

	// top row
	echo "campaign_id,int_type,medium,int_date,amount,int_notes,display_name,email, alt_email \n";

	foreach ($my_array4 as $v_element) {
		
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['campaign_id'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_type'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['medium'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_date'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['amount'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['int_notes'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['email'])));
		echo ',';
		echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['alt_email'])));

		echo "\n";
			
		}
}

?>
