<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

/* the purpose of the page is to scan the /sql directory for files and list 
 * them here.  the goal was to make an easy way to add new reports.  
 * just write up the select statement and drop it in the /sql directory.
 */

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

// don't let volunteers access reports!
if ( $_SESSION['ses_user_group_1'] == 'volunteer' ) {
	# send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect volunteer permission. error 12287");
	exit;
}

include("../../header.php");
?>
<div class="features">

<h2>Welcome to the Reports Page</h2>

On this page there are multiple ways to export data.  It will be in a <a href="http://en.wikipedia.org/wiki/Comma-separated_values">CSV</a> file that can be opened by any spreadsheet software.  

<span class="colorme">Please note that these reports are not for campaign list generation.</span>  For that functionality please use the campaign manger under settings.

<!--  ----------------------------------------------------------------  -->

<h4><img src="<?php echo $header_dirname; ?>/images/news_icon.gif" />  Constituents by Group</h4>

Please select which <i>group</i> you would like to export below.

<?php

echo '<form method="post" action="reports_process.php?report=group">';
echo '<select name="group">';

// group lists
$reports_my_array = select_groups("group_list");
foreach ($reports_my_array as $v_element) {
	
// echo "$v_element['column_name'].<br />";

echo '"<option value="';
echo $v_element['column_name'];
echo  '">';
echo $v_element['column_name'];
echo '</option>';

}

// group only
$reports_my_array_1 = select_groups("group");
foreach ($reports_my_array_1 as $v_element) {
	
// echo "$v_element['column_name'].<br />";

echo '"<option value="';
echo $v_element['column_name'];
echo  '">';
echo $v_element['column_name'];
echo '</option>';

}

echo '</select>';
echo '&nbsp;&nbsp;';
echo '<input type="submit" value="Submit"/></form>';

?>

<!--  ----------------------------------------------------------------  -->

<h4><img src="<?php echo $header_dirname; ?>/images/news_icon.gif" />  Interactions by Campaign or Service</h4>

Please select which <i>campaign</i> you would like to export below.

<?php

    $select_campaign_ids_int = "select campaign_id from constituents_campaigns order by campaign_id;";
	$select_campaign_ids_int_results = pg_query($dbconn, $select_campaign_ids_int) or die('Query failed: ' . pg_last_error());
	$rows = pg_num_rows($select_campaign_ids_int_results);
	
	echo '<form method="post" action="reports_process.php?report=campaign">';
		
	echo '<select name="campaign">';
	
		$i = 1;
		while ($i <= $rows) {
		$arr = pg_fetch_array($select_campaign_ids_int_results);
		echo '"<option value="';
		echo $arr["campaign_id"];
		echo  '">';
		echo $arr["campaign_id"];
		echo '</option>';
		$i++;
		}
		
	echo '</select>';
	echo '&nbsp;&nbsp;';
	echo '<input type="submit" value="Submit"/></form>';
?>

<!--  ----------------------------------------------------------------  -->

<h4><img src="<?php echo $header_dirname; ?>/images/news_icon.gif" />  Interactions by Date</h4>

Please select the <i>date range</i> for the interactions you want to export.<br />
<form method="post" action="reports_process.php?report=date_range">
	
	<b>Start Date:</b> <input type="text" name="date_range_start" MAXLENGTH="12" />  <i>YYYY-MM-DD.</i> <br />
	<b>End Date:</b> <input type="text" name="date_range_end" MAXLENGTH="12" />  <i>YYYY-MM-DD.</i> <br />
	
	<input type="submit" value="Submit"/></form>

<br />

<!--  ----------------------------------------------------------------  -->

<h4><img src="<?php echo $header_dirname; ?>/images/news_icon.gif" />  Interactions by Email</h4>

Please enter the <i>email address</i> of a constituent.  This will export all related interactions.<br />
<form method="post" action="reports_process.php?report=email_address">
	
	<b>Email:</b> <input type="text" name="v_email_address" MAXLENGTH="25" />  <i>somebody@someplace.foo</i> <br />
	
	<input type="submit" value="Submit"/></form>

<br />

<!--  ----------------------------------------------------------------  -->

<h4><img src="<?php echo $header_dirname; ?>/images/news_icon.gif" />  Interactions by Display Name</h4>

Please enter the <i>display name</i> of a constituent.  This will export all related interactions.<br />
Note that the display name must be exact and that it is possible for duplicate display names.<br />
<form method="post" action="reports_process.php?report=display_name">
	
	<b>Display Name:</b> <input type="text" name="v_display_name" MAXLENGTH="25" />  <i>Richard S. Stallman</i> <br />
	
	<input type="submit" value="Submit"/></form>

<br />

<!--  ----------------------------------------------------------------  -->

<h4><img src="<?php echo $header_dirname; ?>/images/news_icon.gif" />  Static Reports</h4>
If you would like a custom static report created please contact the IT department.<br /><br />

<?php

function getDirectoryList ($directory) 
  {

    // create an array to hold directory list
    $results = array();

    // create a handler for the directory
    $handler = opendir($directory);

    // open directory and walk through the filenames
    while ($file = readdir($handler)) {

      // if file isn't this directory or its parent, add it to the results
      if ($file != "." && $file != "..") {
        $results[] = $file;
      }

    }

    // tidy up: close the handler
    closedir($handler);

    // done!
    return $results;

}

$directory = './sql';
$my_array = getDirectoryList ($directory);

natsort($my_array);

foreach ($my_array as $v_element) {

	echo '<a href="'.$header_dirname.'/module/constituents/sql/'.$v_element.'">'.$v_element.'</a><br />';

}

?>

</div>


<?php include("../../footer.php");?>
