<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

// a couple of checks to verify they came from the correct form
// is this value set?
if (!isset($_POST['hidden_form_value'])) {
	
	// how did they get here?  send them to error form
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect modify form. error 8004");
	exit;
}
// then remove tags
$hidden_form_value = strip_tags($_POST['hidden_form_value']);
// is it set to the correct value?
if ($hidden_form_value != 'member_modify_process_3') {
	
	// how did they get here?  send them to error form
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect modify form. error 19739");
	exit;
}

// sanatize user input and update database
$hidden_user_id=pg_escape_string($_POST['hidden_user_id']);
$contact_type=pg_escape_string($_POST['contact_type']);
$donotemail=pg_escape_string($_POST['donotemail']);
$donotphone=pg_escape_string($_POST['donotphone']);
$donotmail=pg_escape_string($_POST['donotmail']);
$donotsms=pg_escape_string($_POST['donotsms']);
$donottrade=pg_escape_string($_POST['donottrade']);
$display_name=pg_escape_string($_POST['display_name']);
$nick_name=pg_escape_string($_POST['nick_name']);
$preferredcommunicationmethod=pg_escape_string($_POST['preferredcommunicationmethod']);
$source_of_contact_data=pg_escape_string($_POST['source_of_contact_data']);
$first_name=pg_escape_string($_POST['first_name']);
$middle_name=pg_escape_string($_POST['middle_name']);
$last_name=pg_escape_string($_POST['last_name']);
$job_title=pg_escape_string($_POST['job_title']);
$birth_date=pg_escape_string($_POST['birth_date']);
$is_deceased=pg_escape_string($_POST['deceased']);
$organization_name=pg_escape_string($_POST['organization_name']);
$gender=pg_escape_string($_POST['sex']);
$individual_prefix=pg_escape_string($_POST['individual_prefix']);
$individual_suffix=pg_escape_string($_POST['individual_suffix']);
$current_employer=pg_escape_string($_POST['current_employer']);

// business address below
$post_street_address=pg_escape_string(trim($_POST['street_address']));
$post_supplemental_address_1=pg_escape_string(trim($_POST['supplemental_address_1']));
$post_supplemental_address_2=pg_escape_string(trim($_POST['supplemental_address_2']));
$post_city=pg_escape_string(trim($_POST['city']));
$post_State=pg_escape_string(trim($_POST['State']));
$post_country=pg_escape_string(trim($_POST['country']));
$post_zip_code=pg_escape_string(trim($_POST['zip_code']));
$post_phone=pg_escape_string(trim($_POST['phone']));
$post_fax=pg_escape_string(trim($_POST['fax']));
$post_email=pg_escape_string(trim($_POST['email']));
$post_website=pg_escape_string(trim($_POST['website']));
// home address below
$post_alt_street_address=pg_escape_string(trim($_POST['alt_street_address']));
$post_alt_supplemental_address_1=pg_escape_string(trim($_POST['alt_supplemental_address_1']));
$post_alt_supplemental_address_2=pg_escape_string(trim($_POST['alt_supplemental_address_2']));
$post_alt_city=pg_escape_string(trim($_POST['alt_city']));
$post_alt_State=pg_escape_string(trim($_POST['alt_State']));
$post_alt_country=pg_escape_string(trim($_POST['alt_country']));
$post_alt_zip_code=pg_escape_string(trim($_POST['alt_zip_code']));
$post_alt_phone=pg_escape_string(trim($_POST['alt_phone']));
$post_alt_email=pg_escape_string(trim($_POST['alt_email']));
$post_alt_website=pg_escape_string(trim($_POST['alt_website']));

$post_pref_address=pg_escape_string(trim($_POST['pref_address']));
$post_pref_email=pg_escape_string(trim($_POST['pref_email']));
$post_pref_phone=pg_escape_string(trim($_POST['pref_phone']));
$post_pref_website=pg_escape_string(trim($_POST['pref_website']));

// ---------------------------------------------------------------------
// 
// let's verify they typed in a correctly formatted date using our check_date function
if (!empty($birth_date)) {

    $is_the_date_correct = valid_date($birth_date, $format='YYYY-MM-DD');
    
        if ($is_the_date_correct) {
                // all is well.  continue on
        } else {
                // they did the date wrong
                // what's my directory minus the document root?
                $i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
                // chop off the last two directories to get error path
                $he_is_there = dirname(dirname($i_am_here));
                header("Location: $he_is_there/error.php?error=not a valid birth date. error 29709d");
                exit;
        }
}

// ---------------------------------------------------------------------

// what are the post values for group_* ?
// all post vars are hard coded here except groups
//$process_results =  $_POST;
$column_array = array(); // used to keep track of the columns we select

$my_array = select_groups("group_list"); // call to function select_group in include_mod.php
foreach ($my_array as $v_element) {
	array_push($column_array, $v_element['column_name']);
}

$my_array2 = select_groups("group");
foreach ($my_array2 as $v_element) {
	array_push($column_array, $v_element['column_name']);
}

// declare some variables to avoid notice errors
$insert_query_2 = null;
$insert_query_3 = null;
// using a variable variable $$ to set the variable name and value
foreach ($column_array as $v_element) {
	$$v_element=pg_escape_string(trim($_POST[$v_element]));

	// build a part of our sql statement to be used later
	$insert_query_2 .= ", ";
	$insert_query_2 .= "$v_element";  // this is the column name

	// build the second part of our sql statement to be used later
	$insert_query_3 .= ', \'';
	//$insert_query_3 .= "$$v_element";
	$insert_query_3 .= $$v_element; // this is the value
	$insert_query_3 .= '\'';

}

// do update
$update_donor_db = "UPDATE constituents_members SET (";
$update_donor_db .= "contact_type, donotemail, donotphone, donotmail,";
$update_donor_db .= "donotsms, donottrade, display_name, nick_name, ";
$update_donor_db .= "preferredcommunicationmethod, source_of_contact_data, first_name,";
$update_donor_db .= "middle_name, last_name, job_title,";
$update_donor_db .= "birth_date,";

// legacy
// to avoid an invalid date error 1 of 2
//if (!empty($birth_date)) {
//	$update_donor_db .= "birth_date,";
//	}

$update_donor_db .= " is_deceased, organization_name,";
$update_donor_db .= "gender, individual_prefix, individual_suffix, current_employer,";
$update_donor_db .= "street_address, supplemental_address_1, supplemental_address_2,";
$update_donor_db .= "city, state1, country, zip_code, phone, fax, email, website, ";

$update_donor_db .= "alt_street_address, alt_supplemental_address_1,"; 
$update_donor_db .= "alt_supplemental_address_2, alt_city,"; 
$update_donor_db .= "alt_state1, alt_country,"; 
$update_donor_db .= "alt_zip_code, alt_phone,"; 
$update_donor_db .= "alt_email, alt_website,"; 
$update_donor_db .= "alt_choice_address, alt_choice_phone,"; 
$update_donor_db .= "alt_choice_email, alt_choice_website ";

$update_donor_db .= $insert_query_2; // $insert_query_2 is our group column names

$update_donor_db .= ") = (";
$update_donor_db .= "'$contact_type',";
$update_donor_db .= "'$donotemail',";
$update_donor_db .= "'$donotphone',";
$update_donor_db .= "'$donotmail',";
$update_donor_db .= "'$donotsms',";
$update_donor_db .= "'$donottrade',";
$update_donor_db .= "'$display_name',";
$update_donor_db .= "'$nick_name',";
$update_donor_db .= "'$preferredcommunicationmethod',";
$update_donor_db .= "'$source_of_contact_data',";
$update_donor_db .= "'$first_name',";
$update_donor_db .= "'$middle_name',";
$update_donor_db .= "'$last_name',";
$update_donor_db .= "'$job_title',";
//$update_donor_db .= "'$birth_date',";

// to avoid an invalid date error 2 of 2
if (!empty($birth_date)) {
	$update_donor_db .= "'$birth_date',";
    } else {
        $update_donor_db .= "NULL,";
    }

$update_donor_db .= "'$is_deceased',";
$update_donor_db .= "'$organization_name',";
$update_donor_db .= "'$gender',";
$update_donor_db .= "'$individual_prefix',";
$update_donor_db .= "'$individual_suffix',";
$update_donor_db .= "'$current_employer',";

$update_donor_db .= "'$post_street_address',";
$update_donor_db .= "'$post_supplemental_address_1',";
$update_donor_db .= "'$post_supplemental_address_2',";
$update_donor_db .= "'$post_city',";
$update_donor_db .= "'$post_State',";
$update_donor_db .= "'$post_country',";
$update_donor_db .= "'$post_zip_code',";
$update_donor_db .= "'$post_phone',";
$update_donor_db .= "'$post_fax',";
$update_donor_db .= "'$post_email',";
$update_donor_db .= "'$post_website',";

$update_donor_db .= "'$post_alt_street_address', '$post_alt_supplemental_address_1', ";
$update_donor_db .= "'$post_alt_supplemental_address_2', '$post_alt_city', '$post_alt_State', '$post_alt_country', '$post_alt_zip_code', ";
$update_donor_db .= "'$post_alt_phone', '$post_alt_email', '$post_alt_website',";
	
$update_donor_db .= "'$post_pref_address', '$post_pref_phone', '$post_pref_email', '$post_pref_website'";

$update_donor_db .= $insert_query_3;

$update_donor_db .= ") where user_id = '$hidden_user_id';";

// ---------------------------------------------------------------------

/*
 * here we will update the constituents_members_fields table
 * incase any custom fields were modified

update constituents_members_fields set
(field1, field2) =
('foo', 'bar')
where user_id = '20407'

*/

// get the column names
$select_columns = pg_query($dbconn, "select column_name from constituents_members_fnames;");
if (!$select_columns) {
  die('Query failed: ' . pg_last_error());
}

while ($row0 = pg_fetch_row($select_columns, NULL, PGSQL_ASSOC)) {
	
	$a_temp_var=$row0["column_name"];  // we have the column name
	$a_temp_var_2=pg_escape_string(trim($_POST[$a_temp_var])); // we have the form post
	
	// build our update query
	$update_fields = "update constituents_members_fields set ";
	$update_fields .= "($a_temp_var) = ";
	$update_fields .= "('$a_temp_var_2') ";
	$update_fields .= "where user_id = '$hidden_user_id';";
	
	// process it
	$update_fields_1 = pg_query($dbconn, $update_fields) or die('Query failed: ' . pg_last_error());
	
	}

// ---------------------------------------------------------------------



$update_donor_db_1 = pg_query($dbconn, $update_donor_db) or die('Query failed: ' . pg_last_error());

$process_results = "Success!  You have updated User ID $hidden_user_id.";
$process_results .= '<p>What would you like to do next? ';
$process_results .= '<a href="member_create.php">Create</a>, ';
$process_results .= '<a href="member_modify.php">modify</a>, ';
$process_results .= 'or <a href="reports.php">report</a>?</p>';

include("../../header.php");
?>

<div id="content" class="narrowcolumn">
	<div class="post">
	<h2>Modify Constituent Page.</h2>
	<div class="entry">

<?php
echo $process_results;
?>

	</div>
	</div>
</div>

<?php include("../../footer.php");?>
