<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

// the first thing we do here is check if the user_id they want to 
// delete or modify actually exists.  avoid me trying to modify a user_id
// that somebody just deleted
if (isset($_GET['delete'])) {
	$get_user_id_check=pg_escape_string(trim($_GET['delete']));
} elseif (isset($_GET['modify'])) {
	$get_user_id_check=pg_escape_string(trim($_GET['modify']));
} else {
// how did they get here?  send them to error form
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect modify form. error 29739a");
	exit;
}

$user_id_check_sql = "select count(*) from constituents_members ";
$user_id_check_sql .= "where user_id = '$get_user_id_check';";
$user_id_check_sql_results = pg_query($dbconn, $user_id_check_sql) or die('Query failed: ' . pg_last_error());
$user_id_check_sql_results_1 = pg_fetch_result($user_id_check_sql_results,0,0);
	
if ($user_id_check_sql_results_1 > 0) {
	// all is well.  continue on.
	} else {
		// no such user_id
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=user_id does not exist. error 294087");
	exit;
	
}
	
// ok.  now let's process their request	

if (isset($_GET['delete'])) {
	
	// before we process this request to delete a constituent
	// we want to make sure there are no interactions and verify
	// the user _really_ wants to delete constituent
	
	// cleanup user input
	$get_delete_id=pg_escape_string(trim($_GET['delete']));
	
	// do interactions exist?
	$lookup_interactions = "select count(*) from constituents_interactions ";
	$lookup_interactions .= "where user_id = '$get_delete_id';";
	$lookup_interactions_results = pg_query($dbconn, $lookup_interactions) or die('Query failed: ' . pg_last_error());
    
    $lookup_interactions_results_1 = pg_fetch_result($lookup_interactions_results,0,0);
    
		if ($lookup_interactions_results_1 > 0) {
			$result = "Unable to delete user ID $get_delete_id because it has interactions.";
		} else {
		
		// delete this user id
		$v_delete_query= "delete from constituents_members where user_id = '$get_delete_id';";
		$v_delete_query.= "delete from constituents_members_fields where user_id = '$get_delete_id';";
		
		$v_delete_query_results = pg_query($dbconn, $v_delete_query) or 
			die('Query failed: ' . pg_last_error());
			
		$result = "User ID $get_delete_id has been deleted from the database.";
		$process_results .= '<br />';
		$process_results .= '<p>What would you like to do next? ';
		$process_results .= '<a href="member_create.php">Create</a>, ';
		$process_results .= '<a href="member_modify.php">modify</a>, ';
		$process_results .= 'or <a href="reports.php">report</a>?</p>';
				
		}
        
} elseif (isset($_GET['modify'])) {

	// populate form and modify user
	$get_id=pg_escape_string(trim($_GET['modify']));
	
	$member_lookup_0 = "select contact_type, donotemail, donotphone, donotmail,";
	$member_lookup_0 .= "donotsms, donottrade, display_name, nick_name, ";
	$member_lookup_0 .= "preferredcommunicationmethod, source_of_contact_data, first_name,";
	$member_lookup_0 .= "middle_name, last_name, job_title, birth_date, is_deceased,";
	$member_lookup_0 .= "organization_name,";
	$member_lookup_0 .= "gender, individual_prefix, individual_suffix, current_employer,";
	$member_lookup_0 .= "street_address, supplemental_address_1, supplemental_address_2,";
	$member_lookup_0 .= "city, state1, country, zip_code, phone, fax, email, website,";
	
	$member_lookup_0 .= "alt_street_address, alt_supplemental_address_1, alt_supplemental_address_2,";
	$member_lookup_0 .= "alt_city, alt_state1, alt_country, alt_zip_code, alt_phone,";
	$member_lookup_0 .= "alt_email, alt_website, alt_choice_address, ";
	$member_lookup_0 .= "alt_choice_phone, alt_choice_email, alt_choice_website";
	
	// voodoo to get the group_* column names
	$column_array = array(); // used to keep track of the group columns we select
	$my_array = select_groups("group_list"); // call to function select_group in include_mod.php
	foreach ($my_array as $v_element) {
		array_push($column_array, $v_element['column_name']);
	}
	$my_array2 = select_groups("group");
	foreach ($my_array2 as $v_element) {
		array_push($column_array, $v_element['column_name']);
	}
	// using a variable variable $$ to set the variable name and value
	foreach ($column_array as $v_element) {
		$$v_element=pg_escape_string(trim($_POST[$v_element]));

		// build a part of our sql statement to be used later
		$member_lookup_0 .= ", ";
		$member_lookup_0 .= "$v_element"; //name of column
	}
	
	$member_lookup_0 .= " from constituents_members where user_id = '$get_id';";

	$member_lookup_1 = pg_query($dbconn, $member_lookup_0) or die('Query failed: ' . pg_last_error());
	$member_lookup_2 = pg_fetch_array($member_lookup_1, NULL, PGSQL_ASSOC);
	
	$v_contact_type = $member_lookup_2["contact_type"];
	$v_donotemail = $member_lookup_2["donotemail"];
	$v_donotphone = $member_lookup_2["donotphone"];
	$v_donotmail = $member_lookup_2["donotmail"]; 
	$v_donotsms = $member_lookup_2["donotsms"]; 
	$v_donottrade = $member_lookup_2["donottrade"]; 
	$v_display_name = $member_lookup_2["display_name"]; 
	$v_nick_name = $member_lookup_2["nick_name"]; 
	$v_preferredcommunicationmethod = $member_lookup_2["preferredcommunicationmethod"]; 
	$v_source_of_contact_data = $member_lookup_2["source_of_contact_data"]; 
	$v_first_name = $member_lookup_2["first_name"]; 
	$v_middle_name = $member_lookup_2["middle_name"]; 
	$v_last_name = $member_lookup_2["last_name"]; 
	$v_job_title = $member_lookup_2["job_title"]; 
	$v_birth_date = $member_lookup_2["birth_date"]; 
	$v_is_deceased = $member_lookup_2["is_deceased"]; 
	$v_organization_name = $member_lookup_2["organization_name"]; 
	$v_gender = $member_lookup_2["gender"]; 
	$v_individual_prefix = $member_lookup_2["individual_prefix"]; 
	$v_individual_suffix = $member_lookup_2["individual_suffix"]; 
	$v_current_employer = $member_lookup_2["current_employer"]; 
	$v_street_address = $member_lookup_2["street_address"]; 
	$v_supplemental_address_1 = $member_lookup_2["supplemental_address_1"]; 
	$v_supplemental_address_2 = $member_lookup_2["supplemental_address_2"]; 
	$v_city = $member_lookup_2["city"]; 
	$v_state1 = $member_lookup_2["state1"]; 
	$v_country = $member_lookup_2["country"]; 
	$v_zip_code = $member_lookup_2["zip_code"]; 
	$v_phone = $member_lookup_2["phone"];
	$v_fax = $member_lookup_2["fax"];
	$v_email = $member_lookup_2["email"]; 
	$v_website = $member_lookup_2["website"];
	
	$v_alt_street_address = $member_lookup_2["alt_street_address"];
	$v_alt_supplemental_address_1 = $member_lookup_2["alt_supplemental_address_1"];
	$v_alt_supplemental_address_2 = $member_lookup_2["alt_supplemental_address_2"];
	$v_alt_city = $member_lookup_2["alt_city"];
	$v_alt_state1 = $member_lookup_2["alt_state1"];
	$v_alt_country = $member_lookup_2["alt_country"];
	$v_alt_zip_code = $member_lookup_2["alt_zip_code"];
	$v_alt_phone = $member_lookup_2["alt_phone"];
	$v_alt_email = $member_lookup_2["alt_email"];
	$v_alt_website = $member_lookup_2["alt_website"];
	$v_alt_choice_address = $member_lookup_2["alt_choice_address"];
	$v_alt_choice_phone = $member_lookup_2["alt_choice_phone"];
	$v_alt_choice_email = $member_lookup_2["alt_choice_email"];
	$v_alt_choice_website = $member_lookup_2["alt_choice_website"];
	
} else {
	
	// how did they get here?  send them to error form
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect modify form. error 29739b");
	exit;
	
}

include("../../header.php");
?>

<div class="features">
<h2>Modify Constituent Page.</h2>

<?php

if (!isset($get_id)) {
	echo $result;
} else { // show form and populate it

?>

<p>Here you can modify database members.  Please fill in as much information as possible 
and then click submit.<br />Information we already have is populated.</p>

<br />

<form method="post" action="member_modify_process_3.php">
	<input name="hidden_form_value" type="hidden" value="member_modify_process_3" />
	<input name="hidden_user_id" type="hidden" value="<?php echo $get_id; ?>" />
	

<p>Contact type:
<select name="contact_type">
<option value="Individual" <?php if ($v_contact_type=='Individual') {echo 'selected = "yes"';} ?> >Individual</option>
<option value="Organization" <?php if ($v_contact_type=='Organization') {echo 'selected = "yes"';} ?> >Organization</option>
</select>
</p>

<p>Source of Contact Data: <input type="text" name="source_of_contact_data" size="50" MAXLENGTH="50" value="<?php echo $v_source_of_contact_data; ?>"/></p>

<p>Notes: <br /> <TEXTAREA name="preferredcommunicationmethod" rows="5" cols="60" MAXLENGTH="300" /><?php echo $v_preferredcommunicationmethod; ?></textarea></p>

<input type="checkbox" name="donotemail" value="x" <?php if ($v_donotemail=='x') {echo 'checked';} ?>/> Do not email<br />
<input type="checkbox" name="donotphone" value="x" <?php if ($v_donotphone=='x') {echo 'checked';} ?>/> Do not phone<br />
<input type="checkbox" name="donotmail" value="x" <?php if ($v_donotmail=='x') {echo 'checked';} ?>/> Do not mail<br />
<input type="checkbox" name="donotsms" value="x" <?php if ($v_donotsms=='x') {echo 'checked';} ?>/> Do not sms<br />
<input type="checkbox" name="donottrade" value="x" <?php if ($v_donottrade=='x') {echo 'checked';} ?>/> Do not trade<br />

<hr /><hr />

<p>Prefix:
<select name="individual_prefix">
<option value="" >unknown</option>
<option value="Mr." <?php if ($v_individual_prefix=='Mr.') {echo 'selected = "yes"';} ?> >Mr.</option>
<option value="Ms." <?php if ($v_individual_prefix=='Ms.') {echo 'selected = "yes"';} ?> >Ms.</option>
<option value="Mrs." <?php if ($v_individual_prefix=='Mrs.') {echo 'selected = "yes"';} ?> >Mrs.</option>
<option value="Dr." <?php if ($v_individual_prefix=='Dr.') {echo 'selected = "yes"';} ?> >Dr.</option>
</select>
</p>

<p>First Name: <input type="text" name="first_name" size="35" value="<?php echo $v_first_name; ?>"/></p>
<p>Middle Name: <input type="text" name="middle_name" size="40" MAXLENGTH="50" value="<?php echo $v_middle_name; ?>"/></p>
<p>Last Name: <input type="text" name="last_name" size="40" MAXLENGTH="50" value="<?php echo $v_last_name; ?>"/></p>
<p>Nick Name: <input type="text" name="nick_name" size="40" MAXLENGTH="50" value="<?php echo $v_nick_name; ?>"/></p>
<span class="colorme">Display name is particularly important as it used to find duplicates.  
It is usually a persons first, middle (if applicable) and last name.</span>
<p><b>Display Name</b>: <input type="text" name="display_name" size="40" MAXLENGTH="100" value="<?php echo $v_display_name; ?>"/></p>

<p>Suffix: <input type="text" name="individual_suffix" size="6" value="<?php echo $v_individual_suffix; ?>"/></p>

<p>Job Title: <input type="text" name="job_title" size="40" MAXLENGTH="70" value="<?php echo $v_job_title; ?>"/></p>
<p>Birth Date <span class="colorme"><i>(YYYY-MM-DD)</i>: <input type="text" name="birth_date" size="10" value="<?php echo $v_birth_date; ?>"/></p>

<p>Deceased?: <span class="colorme">If you select 'yes' we will retain interactions but no longer attempt communication.</span><br />
<input type="radio" name="deceased" value="y" <?php if ($v_is_deceased=='y') {echo 'checked';} ?>/> Yes<br />
<input type="radio" name="deceased" value="n" <?php if ($v_is_deceased=='n') {echo 'checked';} ?>/> No

<p>Gender: <br />
<input type="radio" name="sex" value="m" <?php if ($v_gender=='m') {echo 'checked';} ?>/> Male<br />
<input type="radio" name="sex" value="f" <?php if ($v_gender=='f') {echo 'checked';} ?>/> Female<br />
<input type="radio" name="sex" value="u" <?php if ($v_gender=='u') {echo 'checked';} ?>/> Unknown

<p>Current Employer (for individuals): <input type="text" name="current_employer" size="40" MAXLENGTH="100" value="<?php echo $v_current_employer; ?>" /></p>

<p>Organization Name (for Businesses): <input type="text" name="organization_name" size="40" MAXLENGTH="100" value="<?php echo $v_organization_name; ?>"/></p>

<hr /><hr />

<b>Business address</b>
<p>Street Address: <input type="text" name="street_address" size="40" MAXLENGTH="100" value="<?php echo $v_street_address; ?>" /></p>
<p>Supplemental Address 1: <input type="text" name="supplemental_address_1" size="40" MAXLENGTH="100" value="<?php echo $v_supplemental_address_1; ?>" /></p>
<p>Supplemental Address 2: <input type="text" name="supplemental_address_2" size="40" MAXLENGTH="100" value="<?php echo $v_supplemental_address_2; ?>" /></p>
<p>City: <input type="text" name="city" size="40" MAXLENGTH="50" value="<?php echo $v_city; ?>" /></p>
<p>State: <input type="text" name="State" size="40" MAXLENGTH="50" value="<?php echo $v_state1; ?>" /></p>
<p>Country: <input type="text" name="country" size="10" MAXLENGTH="10" value="<?php echo $v_country; ?>" /></p>
<p>Zip Code: <input type="text" name="zip_code" size="10" MAXLENGTH="10" value="<?php echo $v_zip_code; ?>" /></p>
<p>Phone: <input type="text" name="phone" size="30" MAXLENGTH="30" value="<?php echo $v_phone; ?>" /></p>
<p>Fax: <input type="text" name="fax" size="30" MAXLENGTH="30" value="<?php echo $v_fax; ?>" /></p>

<span class="colorme">Email is also very important as it is used to find duplicates.</span>
<p>Email: <input type="text" name="email" size="40" MAXLENGTH="50" value="<?php echo $v_email; ?>" /></p>
<p>Website: <input type="text" name="website" size="35" MAXLENGTH="50" value="<?php echo $v_website; ?>" /></p>

<hr />

<b>Home address</b>
<p>Street Address: <input type="text" name="alt_street_address" size="40" MAXLENGTH="100" value="<?php echo $v_alt_street_address; ?>" /></p>
<p>Supplemental Address 1: <input type="text" name="alt_supplemental_address_1" size="40" MAXLENGTH="100" value="<?php echo $v_alt_supplemental_address_1; ?>"/></p>
<p>Supplemental Address 2: <input type="text" name="alt_supplemental_address_2" size="40" MAXLENGTH="100" value="<?php echo $v_alt_supplemental_address_2; ?>"/></p>
<p>City: <input type="text" name="alt_city" size="40" MAXLENGTH="50" value="<?php echo $v_alt_city; ?>"/></p>
<p>State: <input type="text" name="alt_State" size="40" MAXLENGTH="50" value="<?php echo $v_alt_state1; ?>"/></p>
<p>Country: <input type="text" name="alt_country" size="10" MAXLENGTH="10" value="<?php echo $v_alt_country; ?>" /></p>
<p>Zip Code: <input type="text" name="alt_zip_code" size="10" MAXLENGTH="10" value="<?php echo $v_alt_zip_code; ?>" /></p>
<p>Phone: <input type="text" name="alt_phone" size="30" MAXLENGTH="30" value="<?php echo $v_alt_phone; ?>" /></p>
<span class="colorme">Email is also very important as it is used to find duplicates.</span>
<p>Email: <input type="text" name="alt_email" size="40" MAXLENGTH="40" value="<?php echo $v_alt_email; ?>"/></p>
<p>Website: <input type="text" name="alt_website" size="35" MAXLENGTH="50" value="<?php echo $v_alt_website; ?>" /></p>

<hr />
<b>Preferences</b>
<p>Preferred address: </p>
<input type="radio" name="pref_address" value="b" <?php if ($v_alt_choice_address=='b') {echo 'checked';} ?>/> Business<br />
<input type="radio" name="pref_address" value="h" <?php if ($v_alt_choice_address=='h') {echo 'checked';} ?>/> Home

<p>Preferred email: </p>
<input type="radio" name="pref_email" value="b" <?php if ($v_alt_choice_email=='b') {echo 'checked';} ?>/> Business<br />
<input type="radio" name="pref_email" value="h" <?php if ($v_alt_choice_email=='h') {echo 'checked';} ?>/> Home

<p>Preferred telephone: </p>
<input type="radio" name="pref_phone" value="b" <?php if ($v_alt_choice_phone=='b') {echo 'checked';} ?>/> Business<br />
<input type="radio" name="pref_phone" value="h" <?php if ($v_alt_choice_phone=='h') {echo 'checked';} ?>/> Home

<p>Preferred website: </p>
<input type="radio" name="pref_website" value="b" <?php if ($v_alt_choice_website=='b') {echo 'checked';} ?>/> Business<br />
<input type="radio" name="pref_website" value="h" <?php if ($v_alt_choice_website=='h') {echo 'checked';} ?>/> Home

<hr /><hr />

<?php
// the purpose of this query to display all custom fields
// for more on custom fields please see the admin settings
// we use another similar query on the process page
// i'm doing this because the columns are variable

echo '<p><b>Custom Member Fields</b>:</p>';
echo '<span class="colorme">For dates please always use this format:  yyyy-mm-dd </span> <br /><br />';

$select_columns = pg_query($dbconn, "select * from constituents_members_fnames;");
if (!$select_columns) {
  die('Query failed: ' . pg_last_error());
}

while ($row9 = pg_fetch_row($select_columns, NULL, PGSQL_ASSOC)) {

	echo $row9["human_name"];
	echo ' <input type="text" name="';
	echo $row9["column_name"];
	echo '" size="50" MAXLENGTH="100" value="';
	
		// here we get the value if exists and populate value
		$column_name_sub_qry=$row9["column_name"];
		$da_query="select $column_name_sub_qry from constituents_members_fields where user_id = '$get_id';";
		$select_column_value=pg_query($dbconn, $da_query);
		if (!$select_column_value) {
		  die('Query failed: ' . pg_last_error());
		}
		
		echo pg_fetch_result($select_column_value, 0, 0);

	echo '"/>';
	echo '<br />';
  
}
?>

<hr /><hr />

<b>Lists and Groups</b>:  You may select more than one.<br />
Note that the current naming convention has <i>group_*</i> for groups and <i>group_list_*</i> for mailing lists.<br />
<br />

<?php  
foreach ($column_array as $v_element) {  // note that $column_array is used at the beginning of this script
$group_output = null;
$group_output .= '<input type="checkbox" name="';
$group_output .= $v_element;
$group_output .= '" value="x" ';
if (!empty($member_lookup_2[$v_element])) {$group_output .= 'checked';}
$group_output .= '/> ';
$group_output .= $v_element;
$group_output .= '<br />';
echo $group_output;
}
?>

<br />

<p><p><input type="submit" value="Submit"/></p></p>
</form>

<br />

Or you can <a href="member_modify.php">Cancel</a>

<?php
} // close else statement
?>


</div> <!-- close of class features -->

<?php include("../../footer.php");?>
