<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

// sanatize user input
$post_member_modify=pg_escape_string(trim($_POST['hidden_form_value']));

// case statement to deal with the search
switch ($post_member_modify) {
    case "member_search_email":
                
        // sanatize user input
		$post_member_modify_email=pg_escape_string(trim($_POST['email']));
		
		// check to make sure they have filled in the form
        if (!empty($post_member_modify_email)) {
		
			// search for email
			$v_select_email = "select user_id, contact_type, display_name, email, alt_email, organization_name ";
			$v_select_email .= "from constituents_members where (lower(email) = lower('$post_member_modify_email') ";
			$v_select_email .= "or lower(alt_email) = lower('$post_member_modify_email'));";
			$v_select_query_results = pg_query($dbconn, $v_select_email) or 
			die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($v_select_query_results);  // count up rows in query
			//$rows = $rows -1;  // avoids an index not found error
        
		} else {
			// send them to the error page for not filling out the form
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=no info in search form. error 6929");
			exit;
		}
        
        break;
        
    case "member_search_display":
        
        // sanatize user input
		$post_member_modify_name=pg_escape_string(trim($_POST['display_name']));
		
		// check to make sure they have filled in the form
        if (!empty($post_member_modify_name)) {
		
		// search for email
        $v_select_email = "select user_id, contact_type, display_name, email, alt_email, organization_name ";
        $v_select_email .= "from constituents_members where lower(display_name) = lower('$post_member_modify_name');";
		$v_select_query_results = pg_query($dbconn, $v_select_email) or 
        die('Query failed: ' . pg_last_error());
		$rows = pg_num_rows($v_select_query_results);  // count up rows in query
		//$rows = $rows -1;  // avoids an index not found error
        
        } else {
			// send them to the error page for not filling out the form
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=no info in search form. error 69292");
			exit;
		}
        
        break;
        
    case "member_search_fulltext":
        
        // sanatize user input
		$post_member_modify_text=pg_escape_string(trim($_POST['member_fulltext']));
		
		// check to make sure they have filled in the form
        if (!empty($post_member_modify_text)) {
		
		// search for email
        $v_select_email = "select user_id, contact_type, display_name, email, alt_email, organization_name ";
        $v_select_email .= "from constituents_members ";
        $v_select_email .= "where lower(display_name) like lower('%$post_member_modify_text%') ";
        $v_select_email .= "or lower(organization_name) like lower('%$post_member_modify_text%') ";
        $v_select_email .= "or lower(current_employer) like lower('%$post_member_modify_text%') ";
        $v_select_email .= "or (lower(email) like lower('%$post_member_modify_text%') or lower(alt_email) like lower('%$post_member_modify_text%')) ";
        $v_select_email .= "or (lower(website) like lower('%$post_member_modify_text%') or lower(alt_website) like lower('%$post_member_modify_text%'));";
        
		$v_select_query_results = pg_query($dbconn, $v_select_email) or 
        die('Query failed: ' . pg_last_error());
		$rows = pg_num_rows($v_select_query_results);  // count up rows in query
		//$rows = $rows -1;  // avoids an index not found error
        
        } else {
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=no info in search form. error 69293");
			exit;
		}
        
        break;
        
    default:
    // they shouldn't be here.  send them to error page.
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect search form. error 24212");
		exit;
}

include("../../header.php");

?>

<div class="features">

<h2>Search Results</h2>

<?php

if ($rows == 0) {
	echo 'There are no constituents matching that search.  Please try again 
	or create a new entry.  Thanks.';
} else {
	// loop through rows and display
	$i = 1;
	while ($i <= $rows) {
	$arr = pg_fetch_array($v_select_query_results);
	//user_id, contact_type, display_name, email, organization_name
	echo '<p><b>User ID: </b>' .$arr['user_id'] . '&nbsp;&nbsp;<b>Contact Type: </b>' . $arr['contact_type'] . '&nbsp;&nbsp;<b>Display Name: </b>'. $arr['display_name'] . '&nbsp;&nbsp;<b>Email: </b>' . $arr['email']. '&nbsp;&nbsp;<b>Alt Email: </b>' . $arr['alt_email']. '&nbsp;&nbsp;<b>Organization: </b>' . $arr['organization_name'] . '&nbsp;&nbsp;
	<i>
	<a href="'.$header_dirname.'/module/constituents/member_modify_process_2.php?delete=' . $arr['user_id'] .'">delete</a> or 
	<a href="'.$header_dirname.'/module/constituents/member_modify_process_2.php?modify=' . $arr['user_id'] .'">modify</a> or 
	<a href="'.$header_dirname.'/module/constituents/interaction.php?inter_id=' . $arr['user_id'] .'">interactions</a>.
	</i>
	</p><br />';
	$i++;
	}
}

?>

</div> <!-- close of class features -->

<?php include("../../footer.php");?>
