<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

// sanatize user input
$post_member_create_form=pg_escape_string(trim($_POST['hidden_form_value']));
// just a quick check to see if we came from the correct form
$post_contact_type=pg_escape_string(trim($_POST['contact_type']));
$post_source_of_contact_data=pg_escape_string(trim($_POST['source_of_contact_data']));
$post_preferredcommunicationmethod=pg_escape_string(trim($_POST['preferredcommunicationmethod']));

// these 4 vars were causing php warnings so i set them to white space if empty
if (empty($_POST['donotemail'])) {$post_donotemail = ' ';}
else {$post_donotemail=pg_escape_string(trim($_POST['donotemail']));}

if (empty($_POST['donotphone'])) {$post_donotphone = ' ';}
else {$post_donotphone=pg_escape_string(trim($_POST['donotphone']));}

if (empty($_POST['donotmail'])) {$post_donotmail = ' ';}
else {$post_donotmail=pg_escape_string(trim($_POST['donotmail']));}

if (empty($_POST['donotsms'])) {$post_donotsms = ' ';}
else {$post_donotsms=pg_escape_string(trim($_POST['donotsms']));}

if (empty($_POST['donottrade'])) {$post_donottrade = ' ';}
else {$post_donottrade=pg_escape_string(trim($_POST['donottrade']));}

$post_individual_prefix=pg_escape_string(trim($_POST['individual_prefix']));
$post_first_name=pg_escape_string(trim($_POST['first_name']));
$post_middle_name=pg_escape_string(trim($_POST['middle_name']));
$post_last_name=pg_escape_string(trim($_POST['last_name']));
$post_nick_name=pg_escape_string(trim($_POST['nick_name']));
$post_display_name=pg_escape_string(trim($_POST['display_name']));
$post_individual_suffix=pg_escape_string(trim($_POST['individual_suffix']));
$post_job_title=pg_escape_string(trim($_POST['job_title']));
$post_birth_date=pg_escape_string(trim($_POST['birth_date']));
$post_sex=pg_escape_string(trim($_POST['sex']));
$post_current_employer=pg_escape_string(trim($_POST['current_employer']));
$post_organization_name=pg_escape_string(trim($_POST['organization_name']));
//$post_addressee=pg_escape_string(trim($_POST['addressee']));
//$post_email_greeting=pg_escape_string(trim($_POST['email_greeting']));
//$post_postal_greeting=pg_escape_string(trim($_POST['postal_greeting']));

// business address below
$post_street_address=pg_escape_string(trim($_POST['street_address']));
$post_supplemental_address_1=pg_escape_string(trim($_POST['supplemental_address_1']));
$post_supplemental_address_2=pg_escape_string(trim($_POST['supplemental_address_2']));
$post_city=pg_escape_string(trim($_POST['city']));
$post_State=pg_escape_string(trim($_POST['State']));
$post_country=pg_escape_string(trim($_POST['country']));
$post_zip_code=pg_escape_string(trim($_POST['zip_code']));
$post_phone=pg_escape_string(trim($_POST['phone']));
$post_email=pg_escape_string(trim($_POST['email']));
$post_fax=pg_escape_string(trim($_POST['fax']));
$post_website=pg_escape_string(trim($_POST['website']));
// home address below
$post_alt_street_address=pg_escape_string(trim($_POST['alt_street_address']));
$post_alt_supplemental_address_1=pg_escape_string(trim($_POST['alt_supplemental_address_1']));
$post_alt_supplemental_address_2=pg_escape_string(trim($_POST['alt_supplemental_address_2']));
$post_alt_city=pg_escape_string(trim($_POST['alt_city']));
$post_alt_State=pg_escape_string(trim($_POST['alt_State']));
$post_alt_country=pg_escape_string(trim($_POST['alt_country']));
$post_alt_zip_code=pg_escape_string(trim($_POST['alt_zip_code']));
$post_alt_phone=pg_escape_string(trim($_POST['alt_phone']));
$post_alt_email=pg_escape_string(trim($_POST['alt_email']));
$post_alt_website=pg_escape_string(trim($_POST['alt_website']));

$post_pref_address=pg_escape_string(trim($_POST['pref_address']));
$post_pref_email=pg_escape_string(trim($_POST['pref_email']));
$post_pref_phone=pg_escape_string(trim($_POST['pref_phone']));
$post_pref_website=pg_escape_string(trim($_POST['pref_website']));

// ---------------------------------------------------------------------

// let's verify they typed in a correctly formatted date using our check_date function
if (!empty($post_birth_date)) {

    $is_the_date_correct = valid_date($post_birth_date, $format='YYYY-MM-DD');
    if ($is_the_date_correct) {
            // all is well.  continue on
    } else {
            // they did the date wrong
            // what's my directory minus the document root?
            $i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
            // chop off the last two directories to get error path
            $he_is_there = dirname(dirname($i_am_here));
            header("Location: $he_is_there/error.php?error=not a valid birth date. error 29706c");
            exit;
    }
}

// ---------------------------------------------------------------------

// what are the post values for group_* ?
// all post vars are hard coded here except groups and custom fields
//$process_results =  $_POST;
$column_array = array(); // used to keep track of the columns we select

$my_array = select_groups("group_list"); // call to function select_group in include_mod.php
foreach ($my_array as $v_element) {
	array_push($column_array, $v_element['column_name']);
}

$my_array2 = select_groups("group");
foreach ($my_array2 as $v_element) {
	array_push($column_array, $v_element['column_name']);
}

// using a variable variable $$ to set the variable name and value
foreach ($column_array as $v_element) {
	$$v_element=pg_escape_string(trim($_POST[$v_element]));

	// build a part of our sql statement to be used later
	$insert_query_2 .= ", ";
	$insert_query_2 .= "$v_element";

	// build the second part of our sql statement to be used later
	$insert_query_3 .= ', \'';
	//$insert_query_3 .= "$$v_element";
	$insert_query_3 .= $$v_element;
	$insert_query_3 .= '\'';

}

// ---------------------------------------------------------------------

// are we coming from the correct form?  not the most secure check but 
// it will keep noobs from directly accessing this page
if ($post_member_create_form!='member_create_form') {
	# send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect form. error 31288");
	exit;
}

// did the user fill out any of the form?
if ((empty($post_first_name)) and (empty($post_last_name)) and (empty($post_display_name)) 
and (empty($post_organization_name)) and (empty($post_email)) and (empty($post_alt_email)) ) {
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=not enough information. error 15183");
	exit;
}

// below we check if the user is trying to enter a constituent that already exists

// check if constituent already exists.  here we use *home* email
if (!empty($post_email)) {
	// simple check currently only looks for exact match of email
	$query_constituent_check = "select count(*) from constituents_members where lower(email) = lower('$post_email');";
	$query_constituent_check_1 = pg_query($dbconn, $query_constituent_check) or die('Query failed: ' . pg_last_error());
	$query_constituent_check_2 = pg_fetch_result($query_constituent_check_1, 0, 0);
		// if the query returns anything other than 0 then the email address already exists
		if (!empty($query_constituent_check_2)) {
			$process_results = 'There already is a constituent with that exact email address.';
			$process_results .= ' Please search for this user and modify existing records.';
		}
}

// check if constituent already exists.  here we use *business* email
if (!empty($post_alt_email)) {
	// simple check currently only looks for exact match of email
	$query_constituent_check = "select count(*) from constituents_members where lower(alt_email) = lower('$post_alt_email');";
	$query_constituent_check_1 = pg_query($dbconn, $query_constituent_check) or die('Query failed: ' . pg_last_error());
	$query_constituent_check_2 = pg_fetch_result($query_constituent_check_1, 0, 0);
		// if the query returns anything other than 0 then the email address already exists
		if (!empty($query_constituent_check_2)) {
			$process_results = 'There already is a constituent with that exact email address.';
			$process_results .= ' Please search for this user and modify existing records.';
		}
}

// if the query returned zero then no such email exists.  insert new donor into db
// notice we are using the variable from the duplicate check above
if (empty($query_constituent_check_2)) {
	//$process_results = 'That would be a new member!';

	$insert_query = "insert into constituents_members ( ";
	$insert_query .= "contact_type, donotemail, donotphone, donotmail, donotsms,";
	$insert_query .= "donottrade, display_name, nick_name, preferredcommunicationmethod,";
	$insert_query .= "source_of_contact_data, first_name, middle_name, last_name,";
	$insert_query .= "job_title,";
	
	// to avoid an invalid date error 1 of 2
	if (!empty($post_birth_date)) {
	$insert_query .= "birth_date,";
	}
	
	$insert_query .= "organization_name, ";
	$insert_query .= "gender, individual_prefix,";
	$insert_query .= "individual_suffix, current_employer, street_address, supplemental_address_1,";
	$insert_query .= "supplemental_address_2, city, state1, country, zip_code, phone, fax,";
	$insert_query .= "email, website,"; 
	
	$insert_query .= "alt_street_address, alt_supplemental_address_1,"; 
	$insert_query .= "alt_supplemental_address_2, alt_city,"; 
	$insert_query .= "alt_state1, alt_country,"; 
	$insert_query .= "alt_zip_code, alt_phone,"; 
	$insert_query .= "alt_email, alt_website,"; 
	$insert_query .= "alt_choice_address, alt_choice_phone,"; 
	$insert_query .= "alt_choice_email, alt_choice_website "; // notice no ',' here.  on purpose
	
	$insert_query .= $insert_query_2; // $insert_query_2 is our group column names
	
	$insert_query .= ") values ( ";
	$insert_query .= "'$post_contact_type', '$post_donotemail', '$post_donotphone', '$post_donotmail', '$post_donotsms', ";
	$insert_query .= "'$post_donottrade', '$post_display_name', '$post_nick_name', '$post_preferredcommunicationmethod', '$post_source_of_contact_data', ";
	$insert_query .= "'$post_first_name', '$post_middle_name', '$post_last_name', '$post_job_title',";
	
	// to avoid an invalid date error 2 of 2
	if (!empty($post_birth_date)) {
	$insert_query .= "'$post_birth_date', ";
	}
	 
	$insert_query .= "'$post_organization_name', '$post_sex', ";
	$insert_query .= "'$post_individual_prefix', '$post_individual_suffix', '$post_current_employer', '$post_street_address', '$post_supplemental_address_1', ";
	$insert_query .= "'$post_supplemental_address_2', '$post_city', '$post_State', '$post_country', '$post_zip_code', ";
	$insert_query .= "'$post_phone', '$post_fax', '$post_email', '$post_website',";
	
	$insert_query .= "'$post_alt_street_address', '$post_alt_supplemental_address_1', ";
	$insert_query .= "'$post_alt_supplemental_address_2', '$post_alt_city', '$post_alt_State', '$post_alt_country', '$post_alt_zip_code', ";
	$insert_query .= "'$post_alt_phone', '$post_alt_email', '$post_alt_website',";
	
	$insert_query .= "'$post_pref_address', '$post_pref_phone', '$post_pref_email', '$post_pref_website' ";
	
	$insert_query .= $insert_query_3;
	
	$insert_query .= ") returning user_id;";

//execute the query
$insert_query_result=pg_query($dbconn, $insert_query) or die('Query failed: ' . pg_last_error());
// get the returning user_id from above query so we can do our insert
$insert_user_id = pg_fetch_row($insert_query_result);
$insert_user_id_results = $insert_user_id[0];  //this is what we need!

// --------------------------------------------------------------------
/*
the purpose of this query to use all custom fields
for more on custom fields please see the admin settings
we use another similar query on member_create.php
i'm doing this because the columns are variable

note that this is placed after the constituents_members insert
because we need to get user_id via postgresql's returning clause
*/

$insert_query_4=null;  // to avoid php notice warning
$insert_query_5=null;

$select_columns = pg_query($dbconn, "select column_name from constituents_members_fnames;");
if (!$select_columns) {
  die('Query failed: ' . pg_last_error());
}

while ($row = pg_fetch_row($select_columns, NULL, PGSQL_ASSOC)) {

	// build a part of our sql statement to be used later
	// column names
	$insert_query_4 .= ", ";
	$insert_query_4 .= $row["column_name"];
	
	// sanatize user data
	$v_element_5=pg_escape_string(trim($_POST[$row["column_name"]]));

	// build the second part of our sql statement to be used later
	// values from form
	$insert_query_5 .= ', \'';
	$insert_query_5 .= $v_element_5;
	$insert_query_5 .= '\'';
	
}

// run the custom field insert here using the user_id from above
	$insert_custom_fields = "insert into constituents_members_fields ";
	$insert_custom_fields .= "(user_id $insert_query_4) ";
	$insert_custom_fields .= "values ('$insert_user_id_results' $insert_query_5);";

	$insert_custom_fields_results = pg_query($dbconn, $insert_custom_fields) or 
	die('Query failed: ' . pg_last_error());

// --------------------------------------------------------------------
		
$process_results = 'Success!  You have inserted a new constituent into the database.';
$process_results .= '<p>What would you like to do next? ';
$process_results .= '<a href="member_create.php">Create</a>, ';
$process_results .= '<a href="member_modify.php">Search</a>, ';
$process_results .= 'or <a href="reports.php">Report</a>?</p>';


// for debugging
//$process_results = $insert_query;
	
}

include("../../header.php");

?>

<div class="features">

<h2>Create Constituent Page.</h2>

<?php 

?>

<?php
echo $process_results;

?>

</div> <!-- close of class features -->

<?php include("../../footer.php");?>
