<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

include("../../header.php");
?>

<div class="features">
	
	<h2>Create Constituent Page.</h2>

<p>Here you can create a new member.  Please fill out as much information as possible 
and then click 'submit'.  A duplicate member will automatically be checked for 
using display name and email.</p>

<br />

<form method="post" action="member_create_process.php">
	<input name="hidden_form_value" type="hidden" value="member_create_form" />

<p>Contact type:
<select name="contact_type">
<option value="Individual">Individual</option>
<option value="Organization">Organization</option>
</select>
</p>

<p>Source of Contact Data: <input type="text" name="source_of_contact_data" size="50" MAXLENGTH="50" /></p>

<p>Notes: <br /> <TEXTAREA name="preferredcommunicationmethod" rows="5" cols="60" MAXLENGTH="300"/></textarea></p>

<input type="checkbox" name="donotemail" value="x"/> Do not email<br />
<input type="checkbox" name="donotphone" value="x"/> Do not phone<br />
<input type="checkbox" name="donotmail" value="x"/> Do not mail<br />
<input type="checkbox" name="donotsms" value="x"/> Do not sms<br />
<input type="checkbox" name="donottrade" value="x"/> Do not trade<br />

<hr /><hr />

<p>Prefix:
<select name="individual_prefix">
<option value="">unknown</option>
<option value="Mr.">Mr.</option>
<option value="Ms.">Ms.</option>
<option value="Mrs.">Mrs.</option>
<option value="Dr.">Dr.</option>
</select>
</p>

<p>First Name: <input type="text" name="first_name" size="35" MAXLENGTH="35"/></p>
<p>Middle Name: <input type="text" name="middle_name" size="40" MAXLENGTH="50" /></p>
<p>Last Name: <input type="text" name="last_name" size="40" MAXLENGTH="50" /></p>
<p>Nick Name: <input type="text" name="nick_name" size="40" MAXLENGTH="50" /></p>

<span class="colorme"><i>Display name is particularly important as it used to find duplicates and do searches.  
It is usually a person's first, middle (if applicable) and last name.<br />
Display name is used on printed media such as envelopes.</i></span>

<p><b>Display Name</b>: <input type="text" name="display_name" size="40" MAXLENGTH="100" /></p>

<p>Suffix: <input type="text" name="individual_suffix" size="6" MAXLENGTH="6"/></p>

<p>Job Title: <input type="text" name="job_title" size="40" MAXLENGTH="70"/></p>
<p>Birth Date <span class="colorme"><i>(YYYY-MM-DD)</i></span>: <input type="text" name="birth_date" size="10" MAXLENGTH="10"/></p>
<p>Gender: <br />
<input type="radio" name="sex" value="m" /> Male<br />
<input type="radio" name="sex" value="f" /> Female<br />
<input type="radio" name="sex" value="u" /> Unknown

<p>Current Employer <i>(for individuals)</i>: <input type="text" name="current_employer" size="40" MAXLENGTH="100"/></p>

<p>Organization Name <i>(for businesses)</i> <input type="text" name="organization_name" size="40" MAXLENGTH="100"/></p>

<hr /><hr />

<b>Business address</b>
<p>Street Address: <input type="text" name="street_address" size="40" MAXLENGTH="100"/></p>
<p>Supplemental Address 1: <input type="text" name="supplemental_address_1" size="40" MAXLENGTH="100"/></p>
<p>Supplemental Address 2: <input type="text" name="supplemental_address_2" size="40" MAXLENGTH="100"/></p>
<p>City: <input type="text" name="city" size="40" MAXLENGTH="50"/></p>
<p>State: <input type="text" name="State" size="40" MAXLENGTH="50"/></p>
<p>Country: <input type="text" name="country" size="10" MAXLENGTH="10"/></p>
<p>Zip Code: <input type="text" name="zip_code" size="10" MAXLENGTH="10"/></p>
<p>Phone: <input type="text" name="phone" size="30" MAXLENGTH="30"/></p>
<p>Fax: <input type="text" name="fax" size="30" MAXLENGTH="30"/></p>
<span class="colorme"><i>Email is also very important as it is used to find duplicates and do searches.</i></span>
<p><b>Email</b>: <input type="text" name="email" size="40" MAXLENGTH="40"/></p>
<p>Website: <input type="text" name="website" size="35" MAXLENGTH="35"/></p>

<hr />

<b>Home address</b>
<p>Street Address: <input type="text" name="alt_street_address" size="40" MAXLENGTH="100"/></p>
<p>Supplemental Address 1: <input type="text" name="alt_supplemental_address_1" size="40" MAXLENGTH="100"/></p>
<p>Supplemental Address 2: <input type="text" name="alt_supplemental_address_2" size="40" MAXLENGTH="100"/></p>
<p>City: <input type="text" name="alt_city" size="40" MAXLENGTH="50"/></p>
<p>State: <input type="text" name="alt_State" size="40" MAXLENGTH="50"/></p>
<p>Country: <input type="text" name="alt_country" size="10" MAXLENGTH="10"/></p>
<p>Zip Code: <input type="text" name="alt_zip_code" size="10" MAXLENGTH="10"/></p>
<p>Phone: <input type="text" name="alt_phone" size="30" MAXLENGTH="30"/></p>
<span class="colorme"><i>Email is also very important as it is used to find duplicates and do searches.</i></span>
<p><b>Email</b>: <input type="text" name="alt_email" size="40" MAXLENGTH="40"/></p>
<p>Website: <input type="text" name="alt_website" size="35" MAXLENGTH="35"/></p>

<hr />

<b>Preferences</b>
<p>Preferred address: </p>
<input type="radio" name="pref_address" value="b" checked /> Business<br />
<input type="radio" name="pref_address" value="h" /> Home

<p>Preferred email: </p>
<input type="radio" name="pref_email" value="b" checked /> Business<br />
<input type="radio" name="pref_email" value="h" /> Home

<p>Preferred telephone: </p>
<input type="radio" name="pref_phone" value="b" checked /> Business<br />
<input type="radio" name="pref_phone" value="h" /> Home

<p>Preferred website: </p>
<input type="radio" name="pref_website" value="b" checked /> Business<br />
<input type="radio" name="pref_website" value="h" /> Home

<hr /><hr />

<?php
// the purpose of this query to display all custom fields
// for more on custom fields please see the admin settings
// we use another similar query on the process page
// i'm doing this because the columns are variable

echo '<p><b>Custom Member Fields:</b></p>';
echo '<span class="colorme">For dates please always use this format:  yyyy-mm-dd </span> <br /><br />';

$select_columns = pg_query($dbconn, "select * from constituents_members_fnames;");
if (!$select_columns) {
  die('Query failed: ' . pg_last_error());
}

while ($row = pg_fetch_row($select_columns, NULL, PGSQL_ASSOC)) {

  // this alone can be used for creating a new constituent
	echo $row["human_name"];
	echo ' <input type="text" name="';
	echo $row["column_name"];
	echo '" size="50" MAXLENGTH="100"/>';
	echo '<br />';
  
}
?>

<hr /><hr />

<b>Lists</b>:  You may select more than one.<br />

<?php  
$my_array = select_groups("group_list"); // call to function select_group in include_mod.php
foreach ($my_array as $v_element) {
echo '
<input type="checkbox" name="'.$v_element['column_name'].'" value="x"/> '.$v_element['column_name'].'<br />
';
}
?>

<br />

<b>Groups</b>:  You may select more than one.<br />

<?php  // call to function select_group in include_mod.php
$my_array2 = select_groups("group");
foreach ($my_array2 as $v_element) {
echo '
<input type="checkbox" name="'.$v_element['column_name'].'" value="x"/> '.$v_element['column_name'].'<br />
';
}
?>

<br />

<p><p><input type="submit" value="Submit"/></p></p>
</form>

</div> <!-- close of class features -->
<?php include("../../footer.php");?>
