<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

// take the info from the previous page, interaction_2.php, and insert or update the record

// let's verify they typed in a correctly formatted date using our check_date function
$int_date_check = strip_tags(trim($_POST['int_date']));
$is_the_date_correct = valid_date($int_date_check, $format='YYYY-MM-DD');
if ($is_the_date_correct) {
	// all is well.  continue on
} else {
	// they did the date wrong
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=not a valid date. error 21871");
	exit;
}

// if is set member_id we are inserting a *new interaction*

// step 1 of 2: insert standard interaction info
if (isset ($_GET['member_id'])) {
	$get_member_id=pg_escape_string(trim($_GET['member_id']));
	$campaign_id=pg_escape_string(trim($_POST['campaign_id'])); // notice this is post
	$int_type=pg_escape_string(trim($_POST['int_type']));
	$medium=pg_escape_string(trim($_POST['medium']));
	$int_date=pg_escape_string(trim($_POST['int_date']));
	$amount=pg_escape_string(trim($_POST['amount']));
	$int_notes=pg_escape_string(trim($_POST['int_notes']));
	$amount_type=pg_escape_string(trim($_POST['amount_type']));
	$amount_items=pg_escape_string(trim($_POST['amount_items']));
		
	// if int_date is null make it now.  this should not be needed...
	if (empty($int_date)) { $int_date = 'now'; }
	
	// insert info
	$insert_query_interaction = "insert into constituents_interactions (campaign_id, ";
	$insert_query_interaction .= "user_id, int_type, medium, int_date, amount, amount_type, int_notes, amount_items)";
	$insert_query_interaction .= "values ('$campaign_id', '$get_member_id', '$int_type', ";
	$insert_query_interaction .= "'$medium', '$int_date', '$amount', '$amount_type', '$int_notes', '$amount_items');";

	$select_query_int_results = pg_query($dbconn, $insert_query_interaction) or 
	die('Query failed: ' . pg_last_error());
	
	/* step 2 of 2:  insert custom interaction fields
	
	we need the interaction_id which was just created with the insert
	and we need the custom fields in our global $_REQUEST array
	
	*/
	
	// get the newly created interaction id for this member
	//select max(interaction_id) from constituents_interactions where user_id = 2;
	$select_last_interaction_id = "select max(interaction_id) from constituents_interactions ";
	$select_last_interaction_id .= "where user_id = $get_member_id;";
	$select_last_interaction_id_results = pg_query($dbconn, $select_last_interaction_id) or die('Query failed: ' . pg_last_error());
	$interaction_id_max = pg_fetch_result($select_last_interaction_id_results, 0,0);  // use in query
	
	// get the name of the columns.  remove known posts.  left with custom fields
	unset($_REQUEST['member_id']);
	unset($_REQUEST['campaign_id']);
	unset($_REQUEST['int_type']);
	unset($_REQUEST['medium']);
	unset($_REQUEST['int_date']);
	unset($_REQUEST['amount']);
	unset($_REQUEST['amount_items']);
	unset($_REQUEST['amount_type']);
	unset($_REQUEST['int_notes']);
	
	//$int_array_dump = var_dump($_REQUEST);  // use in query 
	
	// escape form data and build part of query
	$build_query_vars = null;
	$build_query_key = null;
	
	// build the column names
	foreach(array_keys($_REQUEST) as $val_key) {
		$build_query_key .= ', ';
		$build_query_key.=pg_escape_string(trim($val_key));
		//$build_query_key .= ',';
	}
	
	// build the column values
	foreach($_REQUEST as $val) {
		//$int_array_list .= $val;
		$build_query_vars .= ', \'';
		$build_query_vars.=pg_escape_string(trim($val));
		$build_query_vars .= '\'';
	}
	
	$build_query = "insert into constituents_members_fields_int (interaction_id $build_query_key) ";
	$build_query .= "values ($interaction_id_max $build_query_vars);";
	
	// insert into table
	$build_query_insert_final = pg_query($dbconn, $build_query) or die('Query failed: ' . pg_last_error());
	
	// output
	$process_results = "Success!  You have created a new interaction for User ID $get_member_id.";
	$process_results .= '<p>What would you like to do next?</p>';
	$process_results .= '<ul>';
	$process_results .= '<li><a href="member_create.php">Create a new constituent</a></li>';
	$process_results .= '<li><a href="member_modify.php">Search for a consitiuent</a></li>';
	$process_results .= '<li><a href="reports.php">Go the reports page</a></li>';
	$process_results .= '<li><a href="';
	$process_results .= "interaction_2.php?var3=$get_member_id&var1=create";
	$process_results .= '">Create another interaction for the same User ID #';
	$process_results .= "$get_member_id";
	$process_results .= '</a></li>';
	$process_results .= '</ul>';
	
} elseif 
	// if is set interaction_id we are *updating a current interaction*
	(isset ($_GET['interaction_id'])) {
		$get_interaction_id=pg_escape_string(trim($_GET['interaction_id']));
		$campaign_id=pg_escape_string(trim($_POST['campaign_id'])); // notice this is post
		$int_type=pg_escape_string(trim($_POST['int_type']));
		$medium=pg_escape_string(trim($_POST['medium']));
		$int_date=pg_escape_string(trim($_POST['int_date']));
		$amount=pg_escape_string(trim($_POST['amount']));
		$int_notes=pg_escape_string(trim($_POST['int_notes']));
		$amount_type=pg_escape_string(trim($_POST['amount_type']));
		$amount_items=pg_escape_string(trim($_POST['amount_items']));
		
		
		//step 1 of 2.  update info in constituents_interactions table
		$update_query_interaction = "update constituents_interactions set ";
		$update_query_interaction .= "campaign_id = '$campaign_id', ";
		$update_query_interaction .= "int_type = '$int_type', medium = '$medium', ";
		$update_query_interaction .= "int_date = '$int_date', amount = '$amount', amount_type = '$amount_type', ";
		$update_query_interaction .= "int_notes = '$int_notes', amount_items = '$amount_items' where interaction_id = '$get_interaction_id';";
		
		$update_query_results = pg_query($dbconn, $update_query_interaction) or 
		die('Query failed: ' . pg_last_error());
		
		//step 2 of 2.  update info in constituents_members_fields_int
		// escape form data and build part of query
		$build_query_vars = null;
		$build_query_key = null;
		
		// unset the interaction_id and other suff. makes building the query slightly easier
		unset($_REQUEST['interaction_id']);
		unset($_REQUEST['member_id']);
		unset($_REQUEST['campaign_id']);
		unset($_REQUEST['int_type']);
		unset($_REQUEST['medium']);
		unset($_REQUEST['int_date']);
		unset($_REQUEST['amount']);
		unset($_REQUEST['amount_items']);
		unset($_REQUEST['amount_type']);
		unset($_REQUEST['int_notes']);
		
		// build the column names
		foreach(array_keys($_REQUEST) as $val_key) {
			$build_query_key .= ', ';
			$build_query_key.=pg_escape_string(trim($val_key));
			//$build_query_key .= ',';
		}
		
		// build the column values
		foreach($_REQUEST as $val) {
			//$int_array_list .= $val;
			$build_query_vars .= ', \'';
			$build_query_vars.=pg_escape_string(trim($val));
			$build_query_vars .= '\'';
		}
		
		$build_query = "update constituents_members_fields_int set (interaction_id $build_query_key) ";
		$build_query .= "= ($get_interaction_id $build_query_vars) where interaction_id = $get_interaction_id;";
		
		//$process_results = $build_query;
		
		// insert into table
		$build_query_insert_final = pg_query($dbconn, $build_query) or die('Query failed: ' . pg_last_error());
		
		// output
		$process_results = "Success!  You have updated interaction $get_interaction_id.";
		$process_results .= '<p>What would you like to do next? ';
		$process_results .= '<a href="member_create.php">Create</a>, ';
		$process_results .= '<a href="member_modify.php">search</a>, ';
		$process_results .= 'or <a href="reports.php">report</a>?</p>';
		
	} else {
		// they shouldn't be here
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect interaction get. error 12397");
		exit;
	}

include("../../header.php");

?>

<div class="features">

	<h2>Interactions Create and Modify Result</h2>
	
<?php 

echo $process_results;

?>

</div> <!-- close of class features -->

<?php include("../../footer.php");?>
