<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

/*
 * 1.  the purpose of this page is to make sure website members are allowed
 * to use the constituents module.  the only users who have access are:
 * user_group_1, user_group_2
 * admin, admin
 * exec, exec
 * user, user_dev
 * volunteer, vol_dev
 * 
 * 2.  it also contains useful functions we want to use on multiple pages
 * 
*/

# so we have access to the db and sessions
	@define('MnemeConst', TRUE); // to allow access to include
	// what's my directory minus the document root?
	//$include_mod_home = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
	$include_mod_home = (__DIR__);
	// chop off the last two directories
	$include_common_home = dirname(dirname($include_mod_home));
	require_once("$include_common_home/include/common.php");

// here we do a quick check to see if the user is logged in.
// if not send to error page.
// if yes, then below this we check their access level.
if (empty($_SESSION['is_logged_in'])) {
	# send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=not logged in include_mod.php");
	exit;
}
// they must also be a member of the following user groups
// if a page needs more fine grained access it can deal with the issue on the page
if ( $_SESSION['ses_user_group_2'] != 'admin' AND $_SESSION['ses_user_group_2'] != 'exec' 
	AND $_SESSION['ses_user_group_2'] != 'user_dev' AND $_SESSION['ses_user_group_2'] != 'vol_dev' ) {
	# send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect module permission. error 1221087");
	exit;
}

/* to not allow volunteers to view a page add this code:

if ( $_SESSION['ses_user_group_1'] == 'volunteer' ) {
	# send to error page
	$host  = $_SERVER['HTTP_HOST'];
	$extra = 'error.php';
	header("Location: http://$host/$extra?error=incorrect volunteer permission. error 12287");
	exit;
}

*/

/* ****************************************************************
 * below is a list of funcitons used in the constituents module
 * 
 * 1.  select_groups
 * 2.  select_alt_choice
 * 3.  valid_date
 * 
 * ****************************************************************
 */

function select_groups($arg_select_groups)
{
	/*
	 * all groups are currently columns that start with group_*
	 * this function differentiates between group_*, which is a general group and
	 * group_list_* which is a group specifically for (e)mail
	 * 
	 * the function gets the groups and returns them in an array
	 * 
	 * useage:  input is either group or group_list
	 * 
	 * $my_array = select_groups("group");
	 * foreach ($my_array as $v_element) {
	 * echo "$v_element['column_name'].<br />";
	 * }
	 * 
	 */
	 
	global $dbconn; // so we can connect to the database.  variable is out of scope.
	
	$select_group_switch=strip_tags(trim($arg_select_groups));
	
	if ($select_group_switch == 'group') {
	
	$query_select_groups = "select column_name ";
	$query_select_groups .= "from information_schema.columns ";
	$query_select_groups .= "where table_name = 'constituents_members'  ";
	$query_select_groups .= "and column_name like 'group_%' ";
	$query_select_groups .= "and column_name not like 'group_list%' ";
	$query_select_groups .= "order by column_name;";
	$result_select_groups = pg_query($dbconn, $query_select_groups) or die('Query failed: ' . pg_last_error());
	$arr_return_select_groups = pg_fetch_all($result_select_groups);
	return ($arr_return_select_groups);
}

	if ($select_group_switch == 'group_list') {
	
	$query_select_groups = "select column_name ";
	$query_select_groups .= "from information_schema.columns ";
	$query_select_groups .= "where table_name = 'constituents_members'  ";
	$query_select_groups .= "and column_name like 'group_list%' ";
	$query_select_groups .= "order by column_name;";
	$result_select_groups = pg_query($dbconn, $query_select_groups) or die('Query failed: ' . pg_last_error());
	$arr_return_select_groups = pg_fetch_all($result_select_groups);
	return ($arr_return_select_groups);
}

} 
// end function select_groups


function select_alt_choice($arg_select_alt_choice)
{
	/*
	 * this function will return the preferred address, phone, email and website
	 * for a given user_id which is $arg_select_alt_choice
	 * $arg_select_alt_choice_return is the return array
	 * 
	 * useage:
		$an_id_num = '20407';
		$the_return=select_alt_choice("$an_id_num");

		echo $the_return[0]['addy0'];  // addy0
		echo 'addy 1<br />';
		echo $the_return[0]['addy1'];  // addy1
		echo 'addy 2<br />';
		echo $the_return[0]['addy2'];  // addy2
		echo 'addy 3<br />';
		echo $the_return[0]['city1'];  // city1
		echo 'city<br />';
		echo $the_return[0]['state1'];  // state1
		echo 'state<br />';
		echo $the_return[0]['zip1'];  // zip1
		echo 'zip<br />';
		echo $the_return[1]['tele1'];  // tele1
		echo 'tele<br />';
		echo $the_return[2]['email1'];  // email1
		echo 'email<br />';
		echo $the_return[3]['website1'];  // website1
		echo 'website<br />';
	 * 
	 */
	 
	global $dbconn; // so we can connect to the database.  variable is out of scope.
	
	$arg_select_alt_choice=strip_tags(trim($arg_select_alt_choice));  // user_id
		
	// select alt_choice first as this is where we set the preferred contact method
	$query_select_pref = "select alt_choice_address, alt_choice_phone, alt_choice_email, alt_choice_website ";
	$query_select_pref .= "from constituents_members ";
	$query_select_pref .= "where user_id = '$arg_select_alt_choice';";
	$result_query_select_pref = pg_query($dbconn, $query_select_pref);
	//$arr_return_result_query_select_pref = pg_fetch_all($result_query_select_pref);
	$arr_return_result_query_select_pref = pg_fetch_array($result_query_select_pref, NULL, PGSQL_ASSOC);
	
	// populate our array with the correct values
	//alt_choice_address
	if ($arr_return_result_query_select_pref["alt_choice_address"] == 'b') {
		$query_select_address = "select street_address as addy0, supplemental_address_1 as addy1, supplemental_address_2 as addy2, city as city1, state1 as state1, zip_code zip1  
		from constituents_members where user_id = '$arg_select_alt_choice';";
	} else { 
		$query_select_address = "select alt_street_address as addy0, alt_supplemental_address_1 as addy1, alt_supplemental_address_2 as addy2, alt_city as city1, alt_state1 as state1, alt_zip_code as zip1 
		from constituents_members where user_id = '$arg_select_alt_choice';";
	}
	$query_select_address = pg_query($dbconn, $query_select_address);
	$query_select_address = pg_fetch_all($query_select_address);
		
	//alt_choice_phone
	if ($arr_return_result_query_select_pref["alt_choice_phone"] == 'b') {
		$query_select_phone = "select phone as tele1 
		from constituents_members where user_id = '$arg_select_alt_choice';";
	} else { 
		$query_select_phone = "select alt_phone as tele1 
		from constituents_members where user_id = '$arg_select_alt_choice';";
	}
	$query_select_phone = pg_query($dbconn, $query_select_phone);
	$query_select_phone = pg_fetch_all($query_select_phone);
	
	//alt_choice_email
	if ($arr_return_result_query_select_pref["alt_choice_email"] == 'b') {
		$query_select_email = "select email as email1
		from constituents_members where user_id = '$arg_select_alt_choice';";
	} else { 
		$query_select_email = "select alt_email as email1
		from constituents_members where user_id = '$arg_select_alt_choice';";
	}
	$query_select_email = pg_query($dbconn, $query_select_email);
	$query_select_email = pg_fetch_all($query_select_email);
	
	//alt_choice_website
	if ($arr_return_result_query_select_pref["alt_choice_website"] == 'b') {
		$query_select_website = "select website as website1
		from constituents_members where user_id = '$arg_select_alt_choice';";
	} else { 
		$query_select_website = "select alt_website as website1
		from constituents_members where user_id = '$arg_select_alt_choice';";
	}
	$query_select_website = pg_query($dbconn, $query_select_website);
	$query_select_website = pg_fetch_all($query_select_website);
	
	// build our array and return	
	$arg_select_alt_choice_return = array_merge ($query_select_address,
		$query_select_phone,$query_select_email,$query_select_website);	
	
	return ($arg_select_alt_choice_return);
	
}
// end function select_alt_choice

 
function valid_date($date, $format)
{
	/* posted on the php.net doc by pmmmm.
	 * 
	 * Here's a function that further builds on top of what was posted earlier 
	 * (bmauser and ystein M). It takes date and format (D, DD, M, MM, YY, YYYY) 
	 * and any seperator. Format example: YYYY-MM-DD. The previous functions 
	 * didn't take dashes and required specific order.
	 */
	
    if(strlen($date) >= 8 && strlen($date) <= 10){
        $separator_only = str_replace(array('M','D','Y'),'', $format);
        $separator = $separator_only[0];
        if($separator){
            $regexp = str_replace($separator, "\\" . $separator, $format);
            $regexp = str_replace('MM', '(0[1-9]|1[0-2])', $regexp);
            $regexp = str_replace('M', '(0?[1-9]|1[0-2])', $regexp);
            $regexp = str_replace('DD', '(0[1-9]|[1-2][0-9]|3[0-1])', $regexp);
            $regexp = str_replace('D', '(0?[1-9]|[1-2][0-9]|3[0-1])', $regexp);
            $regexp = str_replace('YYYY', '\d{4}', $regexp);
            $regexp = str_replace('YY', '\d{2}', $regexp);
            if($regexp != $date && preg_match('/'.$regexp.'$/', $date)){
                foreach (array_combine(explode($separator,$format), explode($separator,$date)) as $key=>$value) {
                    if ($key == 'YY') $year = '20'.$value;
                    if ($key == 'YYYY') $year = $value;
                    if ($key[0] == 'M') $month = $value;
                    if ($key[0] == 'D') $day = $value;
                }
                if (checkdate($month,$day,$year)) return true;
            }
        }
    }
    return false;
}

// end function valid_date


