<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

// this page is for manipulating interaction types
// these are used on the interaction page drop downs

// check why they are here.  action = Add, Modify, Delete or empty
// $_GET = action, $_POST = form values, $process_results is our output

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

#check to make sure user is admin
if ($_SESSION['ses_user_group_1'] != 'admin') {
	# send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=insufficient privileges 9805");
	exit;
}

if (isset ($_GET['action'])) {
	$get_action=pg_escape_string(trim($_GET['action']));
} else {
	$get_action = null;  // to surpress 'PHP Notice:  Undefined variable'
}

switch ($get_action) {
    case 'add':
    // here we will add a new type
		
		// verify the filled out the form
		if ( (!empty ($_POST['type_medium'])) && (!empty ($_POST['name_add'])) ) {
			// escape user input
			$post_type_medium=pg_escape_string(trim($_POST['type_medium']));
			$post_name_add=pg_escape_string(trim($_POST['name_add']));
			$post_desc_add=pg_escape_string(trim($_POST['desc_add']));
			
			// does this name_add already exist?
			$query_group_check = "select type_name ";
			$query_group_check .= "from constituents_interactions_types ";
			$query_group_check .= "where lower(type_name) = lower('$post_name_add')";

			$result_group_check = pg_query($dbconn, $query_group_check) or die('Query failed: ' . pg_last_error());
			
			$rows_group_check = pg_num_rows($result_group_check);
			
			if ($rows_group_check == 1) {
				$process_results = 'Sorry, that interaction type name already exists in the database.';
			} else {
				//That name does not exist.
				$query_group_alter = "insert into constituents_interactions_types" ;
				$query_group_alter .= "(type_medium, type_name, type_description) values " ;
				$query_group_alter .= "('$post_type_medium','$post_name_add','$post_desc_add');";
				
				$result_group_alter = pg_query($dbconn, $query_group_alter) or die('Query failed: ' . pg_last_error());
				$process_results = "You have successfully added $post_name_add to the database.";
			}
		
		} else {
			// it's their first time here.  show them the form.
			$process_results = 'Please add your new interaction type or medium here.  The current naming convention is to not use spaces.<br /><br />';
			$process_results .= 'Select the kind as "type" or "medium".<br /><br />Type is defined as <i>what</i> kind of interaction.<br />';
			$process_results .= 'Medium is defined as <i>how</i> they interacted with us.<br /><br />';
			$process_results .= 'For example you could add a type called donation.  Then add a medium of check.  Then an interaction where a donation made<br />with a check could be recorded.<br /><br />';
			
			$process_results .= '<form method="post" action="admin_int_type.php?action=add">';
			
			$process_results .= '<p><b>Kind:</b> <select name="type_medium">';
			$process_results .= '<option value="type" >Type</option>';
			$process_results .= '<option value="medium"  >Medium</option>';
			$process_results .= '</select>';
			
			$process_results .= '<p><b>Name:</b> <input type="text" name="name_add" size="35" /></p>';
			$process_results .= '<p><b>Description (optional):</b> <input type="text" name="desc_add" size="35" /></p>';
			
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';    
			}
    break;
        
    case 'modify':
    //here we will modify an existing type
	
		// verify the filled out the form
		if ( (!empty ($_POST['type_medium'])) && (!empty ($_POST['type_name'])) && (!empty ($_POST['pri_key'])) ) {
			// escape user input
			$post_pri_key=pg_escape_string(trim($_POST['pri_key']));
			$post_type_medium=pg_escape_string(trim($_POST['type_medium']));
			$post_type_name=pg_escape_string(trim($_POST['type_name']));
			$post_type_description=pg_escape_string(trim($_POST['type_description']));
			
			// does this type / name combo already exist?
			$query_group_check = "select type_name ";
			$query_group_check .= "from constituents_interactions_types ";
			$query_group_check .= "where lower(type_name) = lower('$post_type_name') ";
			$query_group_check .= "and lower(type_medium) = lower('$post_type_medium')";

			$result_group_check = pg_query($dbconn, $query_group_check) or die('Query failed: ' . pg_last_error());
			
			$rows_group_check = pg_num_rows($result_group_check);
			
			if ($rows_group_check == 1) {
				$process_results = 'Sorry, that interaction name and medium already exists in the database.';
			} else {
				//That name does not exist.
				$query_group_alter = "update constituents_interactions_types ";
				$query_group_alter .= "set type_medium = '$post_type_medium', ";
				$query_group_alter .= "type_name = '$post_type_name', ";
				$query_group_alter .= "type_description = '$post_type_description' ";
				$query_group_alter .= "where pri_key = $post_pri_key";
								
				$result_group_alter = pg_query($dbconn, $query_group_alter) or die('Query failed: ' . pg_last_error());
				$process_results = "You have successfully added $post_type_name to the database.";
			}

		} else {
			// it's their first time here.  show them the list of interaction types
			
			$query_int_type_modify = "select pri_key, type_medium, type_name, type_description ";
			$query_int_type_modify .= "from constituents_interactions_types order by type_medium, type_name;";
			$result_int_type_modify = pg_query($dbconn, $query_int_type_modify) or die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($result_int_type_modify);
			
			// a little text before our while
			$process_results = 'Below is a list of interaction types. Please select the item you want to modify.<br /><br />';
			
			// note that this is above the list of items as i need to use the pri_key value
			// to know what they want to modify
			$process_results .= '<form method="post" action="admin_int_type.php?action=modify">';
			
			$i = 1;
			while ($i <= $rows) {
			$arr = pg_fetch_array($result_int_type_modify);
			$process_results .= '<input type="radio" name="pri_key" value=';
			$process_results .= "$arr[pri_key]";
			$process_results .= " /> ";
			$process_results .= "<strong>Medium or Type:</strong>  $arr[type_medium] ";
			$process_results .= "<strong>Name:</strong>  $arr[type_name] ";
			$process_results .= "<strong>Description:</strong>  $arr[type_description] <br />";
			$process_results .= "<br />";
			$i++;
			}
			
			$process_results .= '<p>After selecting the item above please enter in below what you would like it changed to.</p>';
			$process_results .= 'Note that this will not change any past interactions.  This will only effect future interactions.<br /><br />';
			
			$process_results .= '<p>Medium or Type:';
			$process_results .= '<select name="type_medium">';
			$process_results .= '<option value="medium">Medium</option>';
			$process_results .= '<option value="type">Type</option>';
			$process_results .= '</select></p>';
			
			$process_results .= '<p>Name: <input type="text" name="type_name" size="50" /></p>';
			$process_results .= '<p>Description (optional): <input type="text" name="type_description" size="70" /></p>';
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '<br />';
			$process_results .= '<a href="admin_int_type.php">Cancel</a>';
			$process_results .= '</form>';

		}
			
    break;
    
    case 'delete':
    // here we will delete an existing type
    
		// verify the filled out the form
		if ( (!empty ($_POST['pri_key'])) ) {
			// escape user input
			$post_pri_key=pg_escape_string(trim($_POST['pri_key']));
			
			// does this key exist?
			$query_key_check = "select type_name ";
			$query_key_check .= "from constituents_interactions_types ";
			$query_key_check .= "where pri_key = $post_pri_key";

			$result_key_check = pg_query($dbconn, $query_key_check) or die('Query failed: ' . pg_last_error());
			
			$result_key_check = pg_num_rows($result_key_check);
			
			if ($result_key_check == 1) {
				$query_key_delete = "delete from constituents_interactions_types ";
				$query_key_delete .= "where pri_key = $post_pri_key";
								
				$result_query_key_delete = pg_query($dbconn, $query_key_delete) or die('Query failed: ' . pg_last_error());
				$process_results = "You have successfully deleted primary key $post_pri_key from the interactions table.";
				
			} else {
				$process_results = 'Sorry, no such key exists in the database. If you continue to see this error please contact your sys admin.';
			}

		} else {
			// it's their first time here.  show them the list of interaction types
			
			$query_int_type_modify = "select pri_key, type_medium, type_name, type_description ";
			$query_int_type_modify .= "from constituents_interactions_types order by type_medium, type_name;";
			$result_int_type_modify = pg_query($dbconn, $query_int_type_modify) or die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($result_int_type_modify);
			
			// a little text before our while
			$process_results = 'Below is a list of interaction types. Please select the item you want to delete.<br /><br />';
			
			// note that this is above the list of items as i need to use the pri_key value
			// to know what they want to modify
			$process_results .= '<form method="post" action="admin_int_type.php?action=delete">';
			
			$i = 1;
			while ($i <= $rows) {
			$arr = pg_fetch_array($result_int_type_modify);
			$process_results .= '<input type="radio" name="pri_key" value=';
			$process_results .= "$arr[pri_key]";
			$process_results .= " /> ";
			$process_results .= "<strong>Medium or Type:</strong>  $arr[type_medium] ";
			$process_results .= "<strong>Name:</strong>  $arr[type_name] ";
			$process_results .= "<strong>Description:</strong>  $arr[type_description] <br />";
			$process_results .= "<br />";
			$i++;
			}
			
			$process_results .= 'Note that this will not change any past interactions.  This will only effect future interactions.<br /><br />';

			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '<br />';
			$process_results .= '<a href="admin_int_type.php">Cancel</a>';
			$process_results .= '</form>';

		}
    
    break;
    
    default:  // they end up here if $get_action doesn't exist
	$process_results = 'What would you like to do?';
	$process_results .= '<ul>';
	
	$process_results .= '<li><a href="admin_int_type.php?action=add">Add a new interaction type</a></li>';
	
	$process_results .= '<li><a href="admin_int_type.php?action=modify">Modify an existing type</a></li>';
	
	$process_results .= '<li><a href="admin_int_type.php?action=delete">Delete an existing type</a></li>';
	
	$process_results .= '</ul>';
}
    


include("../../header.php");

?>

<div class="features">

<h2>Settings for Constituents Module</h2>
	
<?php echo $process_results; ?>


</div> <!-- close of class features -->

<?php include("../../footer.php");?>
