<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

include("../../header.php");

/*
 * the purpose of this page is to present a form where users can 
 * import interactions directly into the database from a csv file.
 * 
 * checks to perform:
 * step 1.  the csv must be structured just like the constituents_interactions
 *          table.  check columns and cell lengths / types.
 * step 2.  are there duplicates within the csv?
 * step 3.  would this upload create duplicates in the table?
 * step 4.  import them and report success
 * 
 */

// we can use this flag to end processing later in the script
$semaphore_admin_int_import = null;  

?>

<div class="features">

<h2>Import Interactions</h2>

<?php

// if exists sanatize user data
if (isset ($_POST['admin_int_import_value'])) {
	$admin_int_import_value=strip_tags(trim($_POST['admin_int_import_value']));
} else {
	$admin_int_import_value = null;  // to surpress 'PHP Notice:  Undefined variable'
}

// if it's their first time here show them the form, else process request
if ($admin_int_import_value == "process_form") {
	
/* ------------------------------------------------------------------------ */
	
	// step 1.  the csv must be structured just like the constituents_interactions table
	// - correct columns?  copy will spit out an error if this is wrong
	// - manditory cells populated?  copy will spit out an error if this is wrong
	// - cells under max length?  copy will spit out an error if this is wrong
	// - data valid?  copy will spit out an error if this is wrong
	// - user_id valid?
	// if there is a failure report what it is.
	
	//$uploaddir = '/var/www/module/constituents/import/';
	$uploaddir = "/var/www".$header_dirname."/module/constituents/import/";
	$uploadfile = $uploaddir . basename($_FILES['file']['name']);
        
        // we have an example file called "example.csv" that we do not want overwritten
        // so we do a check if the name of the file they are uploading is this
        if ($uploadfile == 'example.csv') {
                header("Location: $header_dirname/error.php?error=file name cannot be example. error 19768Z");
		exit;
        }

	if (move_uploaded_file($_FILES['file']['tmp_name'], $uploadfile)) {
		// file has been successfully uploaded into the /upload directory
		// create temp table and import
		
		// if an upload breaks the insert this table will be left behind.
		// if exists delete it
		$step0_query = 'drop table if exists constituents_int_upload_temp; ';
		$insert_step0_query=pg_query($dbconn, $step0_query) or die('Query failed: ' . pg_last_error());
		
		$step1_query = 'create table constituents_int_upload_temp as select * from constituents_interactions where false; ';
		$insert_step1_query=pg_query($dbconn, $step1_query) or die('Query failed: ' . pg_last_error());
		
		// new function to read csv and instert into temp table
		if (($handle = fopen("$uploadfile", "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 0, ",")) !== FALSE) {
				// insert each row here
				//campaign_id, user_id, int_type, medium, int_date, amount, int_notes, amount_type, amount_items
				$step1a_query = "insert into constituents_int_upload_temp ";
				$step1a_query .= "(campaign_id, user_id, int_type, medium, int_date, amount, int_notes, amount_type, amount_items) values ";
				$step1a_query .= "('";
				$step1a_query .="$data[0]";  //campaign_id
				$step1a_query .="',";
				$step1a_query .="$data[1]";  //user_id
				$step1a_query .=",'";
				$step1a_query .="$data[2]";  //int_type
				$step1a_query .="','";
				$step1a_query .="$data[3]";  //medium
				$step1a_query .="','";
				$step1a_query .="$data[4]";  //int_date
				$step1a_query .="','";
				$step1a_query .="$data[5]";  //amount
				$step1a_query .="','";
				$step1a_query .="$data[6]";  //int_notes
				$step1a_query .="','";
				$step1a_query .="$data[7]";  //amount_type
				$step1a_query .="',";
				$step1a_query .="$data[8]";  //amount_items
				$step1a_query .=");";
				// note that if the script dies here you have to manually drop constituents_int_upload_temp
				$insert_step1a_query=pg_query($dbconn, $step1a_query); //or die('Query failed: ' . pg_last_error());
				
					// catch any errors
					$catch_the_error = pg_last_error($dbconn);
					if (!empty($catch_the_error)) {
					$process_results = $catch_the_error;
					$semaphore_admin_int_import = 'x';  // end processing
						} else {
							// no errors so lets continue on
							$process_results = 'Step 1: import to table successful. <br /><br />';
						}
					}
			fclose($handle);
		}
		
	} else {
		// file upload failed.  they shouldn't ever see this
		//$host  = $_SERVER['HTTP_HOST'];
		//$extra = 'error.php';
		header("Location: $header_dirname/error.php?error=csv upload failed at step 1. error 26985");
		exit;
	}
	
	
	if ($semaphore_admin_int_import != 'x') {  // always start by checking this variable
		// user_id valid?
		$select_valid_user_id = 'select user_id from constituents_int_upload_temp ';
		$select_valid_user_id .= 'where user_id not in (select user_id from constituents_members)';
		$select_valid_user_id_results = pg_query($dbconn, $select_valid_user_id) or 
			die('Query failed: ' . pg_last_error());
		$user_id_rows = pg_num_rows($select_valid_user_id_results);
		
		if ($user_id_rows == 0) {
			// all is well
			$process_results .= "Step 1(a): there are no invalid user_ids. <br /><br />";
			} else {  // all is not well
			$process_results .= '<span class="colorme">Step 1(a): Failed!  The following are invalid user_ids:</span> <br />';
			
			//clean up
			$clean_up = 'drop table constituents_int_upload_temp;';
			$clean_up_results = pg_query($dbconn, $clean_up) or die('Query failed: ' . pg_last_error());
			
			// set semaphore
			$semaphore_admin_int_import = 'x';  // end processing
			
			$process_results .= "The following user_id(s) do not exist:<br /><br />";
			// loop through rows and display bad user_id's
			$i = 1;
			while ($i <= $user_id_rows) {
			$arr = pg_fetch_array($select_valid_user_id_results);
			$process_results .= $arr['user_id'];
			$process_results .= "<br />";
			$i++;
			}
		}
	}
	
/* ------------------------------------------------------------------------ */
	
	// step 2.  are there duplicates within the csv?
		
	if ($semaphore_admin_int_import != 'x') {  // always start by checking this variable
	
		$select_duplicates_csv = 'SELECT user_id, count(*) ';
		$select_duplicates_csv .= 'FROM constituents_int_upload_temp '; 
		$select_duplicates_csv .= 'GROUP BY user_id HAVING count(*) > 1;';
		
		$select_duplicates_csv_results = pg_query($dbconn, $select_duplicates_csv) or 
			die('Query failed: ' . pg_last_error());
		$user_id_rows = pg_num_rows($select_duplicates_csv_results);
		
		if ($user_id_rows == 0) {
			// all is well
			$process_results .= "Step 2: there are no duplicate user_ids in the CSV file. <br /><br />";
			} else {  // all is not well
			$process_results .= '<span class="colorme">Step 2 Failed!</span> <br />';
			
			//clean up
			$clean_up = 'drop table constituents_int_upload_temp;';
			$clean_up_results = pg_query($dbconn, $clean_up) or die('Query failed: ' . pg_last_error());
			
			// set semaphore
			$semaphore_admin_int_import = 'x';  // end processing
			
			$process_results .= "The following user_id(s) are duplicated in the CSV:<br /><br />";
			// loop through rows and display bad user_id's
			$i = 1;
			while ($i <= $user_id_rows) {
			$arr = pg_fetch_array($select_duplicates_csv_results);
			$process_results .= 'user_id: ' . $arr['user_id'] . ' duplicates: ' . $arr['count'];
			$process_results .= "<br />";
			$i++;
			}
			
			$process_results .= "<br />Please correct your spreadsheet and try again.";
		}
	
	}

/* ------------------------------------------------------------------------ */

	// step 3.  would this upload create duplicates in the table?
	// do any of these new interations already exist?
	// if there are dups report what to user
	
	if ($semaphore_admin_int_import != 'x') {  // always start by checking this variable
		
	$select_duplicates_temp = 'select distinct(t.user_id) ';
	$select_duplicates_temp .= 'from constituents_int_upload_temp t, constituents_interactions i ';
	$select_duplicates_temp .= 'where t.campaign_id = i.campaign_id  ';
	$select_duplicates_temp .= 'and t.user_id = i.user_id ';
	$select_duplicates_temp .= 'and t.int_type = i.int_type ';
	$select_duplicates_temp .= 'and t.medium = i.medium ';
	$select_duplicates_temp .= 'and t.int_date = i.int_date ';
	//and t.amount = i.amount // don't use this as null != null and will screw up the results
	
	$select_duplicates_temp_results = pg_query($dbconn, $select_duplicates_temp) or 
			die('Query failed: ' . pg_last_error());
		$user_id_rows = pg_num_rows($select_duplicates_temp_results);
		
		if ($user_id_rows == 0) {
			// all is well
			$process_results .= "Step 3: there are no duplicates in the interactions table. <br /><br />";
			} else {  // all is not well
			$process_results .= '<span class="colorme">Step 3 Failed!</span> <br />';
			
			//clean up
			$clean_up = 'drop table constituents_int_upload_temp;';
			$clean_up_results = pg_query($dbconn, $clean_up) or die('Query failed: ' . pg_last_error());
			
			// set semaphore
			$semaphore_admin_int_import = 'x';  // end processing
			
			$process_results .= "The following user_id(s) have duplicates in the interactions table:<br /><br />";
			// loop through rows and display bad user_id's
			$i = 1;
			while ($i <= $user_id_rows) {
			$arr = pg_fetch_array($select_duplicates_temp_results);
			$process_results .= 'user_id: ' . $arr['user_id'];
			$process_results .= "<br />";
			$i++;
			}
			
			$process_results .= "<br />Please correct your spreadsheet and try again.";
		}
			
	}

	// step 4.  import them and report success
	// tell them the number of imports just as quick sanity check
	
	if ($semaphore_admin_int_import != 'x') {  // always start by checking this variable
		
		$insert_interactions = 'INSERT INTO constituents_interactions (campaign_id, user_id, int_type, medium, int_date, amount, int_notes, amount_type, amount_items) ';
		$insert_interactions .= 'SELECT campaign_id, user_id, int_type, medium, int_date, amount, int_notes, amount_type, amount_items FROM constituents_int_upload_temp;';
		$insert_interactions_results = pg_query($dbconn, $insert_interactions);
		
			// catch any errors
			$catch_the_error = pg_last_error($dbconn);
			if (!empty($catch_the_error)) {
			$process_results = $catch_the_error;
			} else {
				// no errors so lets continue on
				$process_results .= 'Step 4:  You have successfully imported the interactions!';
			}
			
		//clean up
		$clean_up = 'drop table constituents_int_upload_temp;';
		$clean_up_results = pg_query($dbconn, $clean_up) or die('Query failed: ' . pg_last_error());
			
	}
	
/* ------------------------------------------------------------------------ */

} else {  // it's their first time here.  show them the form.
	
	$process_results = 'Below is a form where you can upload interactions from a CSV file.  

	<br /><br />

	<span class="colorme"><strong>Warning:</strong> the data from your CSV file will be directly imported into the interactions table.  
	Please verify your data is 100% accurate before doing this.  If you are unsure please contact the IT department for training or manually enter each interaction via the front end.</span>  Manually entering interactions is generally recommended for small to medium size data sets.

	<br /><br />Structure of the CSV file.

	<ul>
		<li>The delimiter is <strong>,</strong></li>
		<li>Cells cannot contain a <strong>,</strong> unless escaped.</li>
		<li>Columns are:  <strong>campaign_id, user_id, int_type, medium, int_date, amount, int_notes, amount_type, amount_items</strong></li>
		<li>Example format:  <strong>2013 Annual Appeal ,2597,Asked,Email,2013-01-20,$5.99,Just a test!,h,0</strong></li>
		<li>An example file:  <a href="'.$header_dirname.'/module/constituents/import/example.csv">example.csv</a></li>
		<li>Mandatory fields are: campaign_id, user_id, int_type, medium, int_date</li>
	</ul>

	The following will happen.

	<ul>
		<li>Check if the structure of the CSV is the same as the interactions table.</li>
		<li>Check if mandatory cells are populated.</li>
		<li>Verify cells do not exceed the maximum length.</li>
		<li>Verify the user_id\'s exist.  <i>Note that this merely checks if they exist, it is up to you to make sure they are correct.</i></li>
		<li>Verify dates are valid.</li>
		<li>Verify campaign_id is valid.</li>
		<li>Check if there are duplicates within the CSV.</li>
		<li>Check if the CSV would create duplicates in the interactions table.</li>
		<li>If all checks are OK process the request, else, report errors.</li>
	</ul>

	<form action="admin_int_import.php" method="post" enctype="multipart/form-data">
		<input name="admin_int_import_value" type="hidden" value="process_form" />
		<label for="file">Filename:</label>
		<input type="file" name="file" id="file" />
		<br />
		<br />
		<input type="submit" name="submit" value="Submit" />
	</form>';
}

echo $process_results;

?>

</div> <!-- close of class features -->

<?php include("../../footer.php");?>
