<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

// this page is for manipulating groups

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

#check to make sure user is admin
if ($_SESSION['ses_user_group_1'] != 'admin') {
	# send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=insufficient privileges 9805");
	exit;
}

// this page can be used for all group administration.
// check why they are here.  action = Add, Modify, Delete or empty
// $_GET = action, $_POST = form values, $process_results is our output

if (isset ($_GET['action'])) {
	$get_action=pg_escape_string(trim($_GET['action']));
} else {
	$get_action = null;  // to surpress 'PHP Notice:  Undefined variable'
}

switch ($get_action) {
    case 'add':
    
		if (isset ($_POST['group_name_add'])) {
			// they have already filled out the add new group form.  now we process it
			$post_group_name=pg_escape_string(trim($_POST['group_name_add']));
			$post_group_name="group_" . $post_group_name;
			
			// does this group already exist?
			$query_group_check = "select column_name ";
			$query_group_check .= "from information_schema.columns ";
			$query_group_check .= "where table_name = 'constituents_members' ";
			$query_group_check .= "and column_name = '$post_group_name';";
			$result_group_check = pg_query($dbconn, $query_group_check) or die('Query failed: ' . pg_last_error());
			
			$rows_group_check = pg_num_rows($result_group_check);
			
			if ($rows_group_check == 1) {
				$process_results = 'Sorry, that group name already exists in the database.';
			} else {
				//That group name does not exist.
				$query_group_alter = "alter table constituents_members add column $post_group_name character varying(2);";
				$result_group_alter = pg_query($dbconn, $query_group_alter) or die('Query failed: ' . pg_last_error());
				$process_results = "You have successfully added $post_group_name to the database.";
			}	
		
		} else {
			// it's their first time here.  show them the form.
			$process_results = 'Please add your new group / list name here.  The current naming convention is to not use spaces or capital letters.<br /><br />';
			$process_results .= 'Examples:<br />';
			$process_results .= '&rarr;donor.&nbsp;&nbsp;<i>this would be for a constituent segment called group_donor.</i><br />';
			$process_results .= '&rarr;list_newsletter.&nbsp;&nbsp;<i>this would be for an email or mail list called group_list_newsletter.</i><br /><br />';
			$process_results .= '<form method="post" action="admin_group.php?action=add">';
			
			$process_results .= '<p><b>Group Name:</b> group_ <input type="text" name="group_name_add" size="35" /></p>';
			
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';    
			}
    break;
        
    case 'modify':
    //alter table constituents_members
	//rename column group_test to group_test2;
	
		if ((isset ($_POST['group_name_current']) && (isset ($_POST['group_name_new'])))) {
			// they have already filled out the modify group form.  now we process it
			// sanitize variables and verify the begin with group_
			$post_group_name_current=pg_escape_string(trim($_POST['group_name_current']));
			$post_group_name_new=pg_escape_string(trim($_POST['group_name_new']));
			$findme   = 'group_';
			$pos_current = strpos($post_group_name_current, $findme);
			$pos_new = strpos($post_group_name_new, $findme);
			
			$process_results = 'Running your request.<br />';
			
				// Note our use of ===.  Simply == would not work as expected
				if ($pos_current === false) {
					$process_results .= '1. The current group name is not formatted properly.<br />';
				} else {
					$process_results .= '2. The current group name is ok.<br />';
				}
				
				if ($pos_new === false) {
					$process_results .= '3. The new group name is not formatted properly.<br />';
				} else {
					$process_results .= '4.The new group name is ok.<br />';
				}
			
				// does the current group name exist?
				$query_group_check = "select column_name ";
				$query_group_check .= "from information_schema.columns ";
				$query_group_check .= "where table_name = 'constituents_members' ";
				$query_group_check .= "and column_name = '$post_group_name_current';";
				$result_group_check = pg_query($dbconn, $query_group_check) or die('Query failed: ' . pg_last_error());
				
				$rows_group_check = pg_num_rows($result_group_check);
				
				if ($rows_group_check == 1) {
					$process_results .= '5. Current group name is valid.<br />';
					
					// run sql here to update name
					$query_group_modify_column = "alter table constituents_members ";
					$query_group_modify_column .= "rename column $post_group_name_current to $post_group_name_new;";
					$result_group_modify_column = pg_query($dbconn, $query_group_modify_column) or die('Query failed: ' . pg_last_error());
					
					$process_results .= '6. You have successfully updated the group name.<br />';
					
				} else {  // the current column name did not exist
					$process_results .= '7. Current group name does not exist in the database.<br />';
					$process_results .= '8. Update failed.<br />';
				}

		} else {
			// it's their first time here.  show them the list of groups and form.
			// select group_* and display
			$query_group_modify = "select column_name ";
			$query_group_modify .= "from information_schema.columns ";
			$query_group_modify .= "where table_name = 'constituents_members'  ";
			$query_group_modify .= "and column_name like 'group_%' ";
			$query_group_modify .= "order by column_name;";
			$result_group_modify = pg_query($dbconn, $query_group_modify) or die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($result_group_modify);
			
			// a little text before our while
			$process_results = '<strong>Below is a list of the current groups.</strong><br />';
			
			$i = 1;
			while ($i <= $rows) {
			$arr = pg_fetch_array($result_group_modify);
			$process_results .= "$arr[column_name] <br />";
			$i++;
			}
			
			$process_results .= '<p><strong>Please type in the current group name and the new group name you would like it
			changed to and then click submit.  Note that both fields are manditory, the current group name must 
			be listed exactly as above and all group names must be prepended with <i>group_</i>.</strong></p>';
			
			$process_results .= '<form method="post" action="admin_group.php?action=modify">';
			$process_results .= '<p>Current group name: <input type="text" name="group_name_current" size="35" /></p>';
			$process_results .= '<p>Modified group name: <input type="text" name="group_name_new" size="35" /></p>';
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';
		}
			
    break;
    
    case 'delete':
    //alter table constituents_members
	//drop column group_test2;
		if ((isset ($_POST['group_name_delete']))) {
			// they have already filled out the delete group form.  now we process it
			// sanitize variables and verify the begin with group_
			$post_group_name_delete=pg_escape_string(trim($_POST['group_name_delete']));
			// does the current group name exist?
			$query_group_check = "select column_name ";
			$query_group_check .= "from information_schema.columns ";
			$query_group_check .= "where table_name = 'constituents_members' ";
			$query_group_check .= "and column_name = '$post_group_name_delete';";
			$result_group_check = pg_query($dbconn, $query_group_check) or die('Query failed: ' . pg_last_error());
				
			$rows_group_check = pg_num_rows($result_group_check);
				
				if ($rows_group_check == 1) {
					// run sql here to update name
					$query_group_modify_column = "alter table constituents_members ";
					$query_group_modify_column .= "drop column $post_group_name_delete;";
					$result_group_modify_column = pg_query($dbconn, $query_group_modify_column) or die('Query failed: ' . pg_last_error());
					
					$process_results .= "You have successfully deleted $post_group_name_delete.";
					
				} else {  // the current column name did not exist
					$process_results = "The group name $post_group_name_delete does not exist in the database.<br />";
					$process_results .= "Update failed.<br />";
				}

		} else {
			// it's their first time here.  show them the list of groups and form.
			// select group_* and display
			$query_group_modify = "select column_name ";
			$query_group_modify .= "from information_schema.columns ";
			$query_group_modify .= "where table_name = 'constituents_members'  ";
			$query_group_modify .= "and column_name like 'group_%' ";
			$query_group_modify .= "order by column_name;";
			$result_group_modify = pg_query($dbconn, $query_group_modify) or die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($result_group_modify);
			
			// a little text before our while
			$process_results = '<strong>Below is a list of the current groups.</strong><br />';
			
			$i = 1;
			while ($i <= $rows) {
			$arr = pg_fetch_array($result_group_modify);
			$process_results .= "$arr[column_name] <br />";
			$i++;
			}
			
			$process_results .= '<p>Please type in the current group name that you would like deleted.  ';
			$process_results .= 'Note that if you delete a group all constituents will be removed from the group.</p>';
			
			$process_results .= '<form method="post" action="admin_group.php?action=delete">';
			$process_results .= '<p>Group to delete: <input type="text" name="group_name_delete" size="35" /></p>';
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';
		}
    
    break;
    
    default:  // they end up here if they come to this page with no get or post
	$process_results = 'What would you like to do?';
	$process_results .= '<ul>';
	
	$process_results .= '<li><a href="admin_group.php?action=add">Add a new group</a></li>';
	
	$process_results .= '<li><a href="admin_group.php?action=modify">Modify an existing group</a></li>';
	
	$process_results .= '<li><a href="admin_group.php?action=delete">Delete an existing group</a></li>';
	
	$process_results .= '</ul>';
}
    


include("../../header.php");

?>

<div class="features">

<h2>Settings for Constituents Module</h2>
	
<?php echo $process_results; ?>


</div> <!-- close of class features -->

<?php include("../../footer.php");?>
