<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

// this page is for manipulating custom user defined fields for interactions
// 2 tables:
// constituents_members_fields_int - this has the user_id and the field column
// constituents_members_fnames_int - this has the human readable name and the column name

# so we have access to module specific inlcude and proper user permissions
require("./include_mod.php");

#check to make sure user is admin
if ($_SESSION['ses_user_group_1'] != 'admin') {
	# send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=insufficient privileges 9805b");
	exit;
}

// how this works:
// check why they are here.  action = Add, Modify, Delete or empty
// $_GET = action, $_POST = form values, $process_results is our output

if (isset ($_GET['action'])) {
	$get_action=pg_escape_string(trim($_GET['action']));
} else {
	$get_action = null;  // to surpress 'PHP Notice:  Undefined variable'
}

switch ($get_action) {
    case 'add':
    
		if (!empty ($_POST['group_name_add']) and ($_POST['field_name_add']) ) {
			// they have already filled out the add new group form.  now we process it
			$post_group_name=pg_escape_string(trim($_POST['group_name_add']));
			$post_field_name=pg_escape_string(trim($_POST['field_name_add']));
			
			// here we split this variable in two.  1 is the column name.  
			// 2 is the custom field name users will see.
			// i did this because they may use characters not allowed
			// for a column name
			$post_field_name_human=strip_tags($post_field_name);
			// keep only letters and numbers for the column name
			$post_field_name_column = strtolower(preg_replace('/[^a-zA-Z0-9-]/', '', $post_field_name));
			
			// does this group already exist?
			$query_field_check = "select column_name ";
			$query_field_check .= "from information_schema.columns ";
			$query_field_check .= "where table_name = 'constituents_members_fields_int' ";
			$query_field_check .= "and column_name = '$post_field_name_column';";
			$result_field_check = pg_query($dbconn, $query_field_check) or die('Query failed: ' . pg_last_error());
			
			$rows_field_check = pg_num_rows($result_field_check);
			
			if ($rows_field_check == 1) {
				$process_results = 'Sorry, that field name already exists in the database.';
			} else {
				//That field name does not exist.
				// create column
				$query_field_alter = "alter table constituents_members_fields_int add column $post_field_name_column character varying(100);";
				$result_field_alter = pg_query($dbconn, $query_field_alter) or die('Query failed: ' . pg_last_error());
				// record human readable name
				$query_group_alter2 = "insert into constituents_members_fnames_int ";
				$query_group_alter2 .= "(column_name, human_name, group_name_int) values ('$post_field_name_column', '$post_field_name_human', '$post_group_name')";
				$result_group_alter2 = pg_query($dbconn, $query_group_alter2) or die('Query failed: ' . pg_last_error());
				
				$process_results = "You have successfully added the custom constituent field  $post_field_name_human to the database.";
			}	
		
		} else {
			// it's their first time here.  show them the form.
			$process_results = 'Please add your new custom interaction field here.<br /><br /><span class="colorme">Please note that all fields are limited to a maximum of 100 characters and must begin with a letter.</span><br /><br />Field name is the name of the new custom field you wish to add to the interactions form.<br /><br />Group name is the group you want to associate the field name with.<br /><br />This way staff will only see the custom fields that apply to their job.<br /><br />';
			
			$process_results .= '<form method="post" action="admin_custom_members_fields_int.php?action=add">';
			
			$process_results .= '<p><b>Field Name:</b> <input type="text" name="field_name_add" size="50" maxlength = "100" /></p>';
			
			$process_results .= '<p><b>Group Name:</b> <input type="text" value="default" name="group_name_add" size="50" maxlength = "100" /></p>';  // constituents_members_fnames_int.group_name_int 
			
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';    
			}
    break;
        
    case 'modify':
    //alter table constituents_members_fields_int
	
		if ((isset ($_POST['pri_key']) && (isset ($_POST['group_name_new'])))) {
			// they have already filled out the form.  now we process it
			$post_group_name_id=pg_escape_string(trim($_POST['pri_key']));
			$post_group_name_new=pg_escape_string(trim($_POST['group_name_new']));
			//$post_group_name_old=pg_escape_string(trim($_POST['group_name_old']));
						
				//  the key_id tells us the row
				//  the field name can be used to display and create the column name
				$post_group_name_id=strip_tags($post_group_name_id);
				$post_group_name_new_human=strip_tags($post_group_name_new);
				//$post_group_name_old_column=strtolower(strip_tags($post_group_name_old));
				$post_group_name_new_column=strtolower(preg_replace('/[^a-zA-Z0-9-]/', '', $post_group_name_new));
								
				// lets update our two tables
				// mod:  use pri_key to update column_name, human_name.
                // alter table <field_name>.constituents_members_fields_int
                $query_select_column_name = "select column_name from constituents_members_fnames_int ";
                $query_select_column_name .= "where pri_key = '$post_group_name_id';";
                $query_select_column_name_1 = pg_query($dbconn, $query_select_column_name) or die('Query failed: ' . pg_last_error());
                $query_select_column_name_2 = pg_fetch_result($query_select_column_name_1, 0, 0);
                
                $query_group_mod = "update constituents_members_fnames_int ";
				$query_group_mod .= "set column_name = '$post_group_name_new_column', human_name = '$post_group_name_new_human' ";
				$query_group_mod .= "where pri_key = '$post_group_name_id';";
				$query_group_mod_1 = pg_query($dbconn, $query_group_mod) or die('Query failed: ' . pg_last_error());
				
				// sometimes they want to alter the human readable name and not the column_name
				if ($query_select_column_name_2 != $post_group_name_new_column) {
				
					$query_group_mod_2 = "ALTER TABLE constituents_members_fields_int rename column $query_select_column_name_2 to $post_group_name_new_column;";
					$query_group_mod_3 = pg_query($dbconn, $query_group_mod_2) or die('Query failed: ' . pg_last_error());
				}
				
				$process_results = "You have successfully modified the custom user field <i>$post_group_name_new_human</i>.";

		} else {
			// it's their first time here.  
			
			$query_group_modify = "select pri_key, column_name, human_name ";
			$query_group_modify .= "from constituents_members_fnames_int;";
			$result_group_modify = pg_query($dbconn, $query_group_modify) or die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($result_group_modify);
			
			// a little text before our while
			$process_results = '<strong>Below is a list of the current custom fields.</strong><br /><br />';
			
			// note that this is above the list of items as i need to use the pri_key value
			// to know what they want to modify
			$process_results .= '<form method="post" action="admin_custom_members_fields_int.php?action=modify">';
			
			$i = 1;
			while ($i <= $rows) {
			$arr = pg_fetch_array($result_group_modify);
			$process_results .= '<input type="radio" name="pri_key" value=';
			$process_results .= "$arr[pri_key]";
			$process_results .= " /> ";
			$process_results .= "<strong>Field name:</strong>  $arr[human_name] ";
			$process_results .= "<br />";
			$i++;
			}
			
			$process_results .= '<p>Above please select the radio button of the custom field you would like to change and type in the new name below.</p>';
			
			$process_results .= '<p>New field name: <input type="text" name="group_name_new" size="50" maxlength = "100" /></p>';
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';
			}
			
    break;
    
    case 'delete':
    //alter table constituents_members_fields_int
		if ((isset ($_POST['group_name_delete']))) {
			// they have already filled out the delete form.  now we process it
			// sanitize variables
			$post_group_name_delete=strtolower(pg_escape_string(trim($_POST['group_name_delete'])));
			// does the current group name exist?
			$query_group_check = "select column_name ";
			$query_group_check .= "from information_schema.columns ";
			$query_group_check .= "where table_name = 'constituents_members_fields_int' ";
			$query_group_check .= "and column_name = '$post_group_name_delete';";
			$result_group_check = pg_query($dbconn, $query_group_check) or die('Query failed: ' . pg_last_error());
				
			$rows_group_check = pg_num_rows($result_group_check);
				
				if ($rows_group_check == 1) {
					// update table 1 of 2
					$query_group_modify_column = "alter table constituents_members_fields_int ";
					$query_group_modify_column .= "drop column $post_group_name_delete;";
					$result_group_modify_column = pg_query($dbconn, $query_group_modify_column) or die('Query failed: ' . pg_last_error());
					
					// update table 2 of 2
					$query_group_modify_column_2 = "delete from constituents_members_fnames_int ";
					$query_group_modify_column_2 .= "where column_name = '$post_group_name_delete';";
					$query_group_modify_column_3 = pg_query($dbconn, $query_group_modify_column_2) or die('Query failed: ' . pg_last_error());
					
					$process_results = "You have successfully deleted the custom field name $post_group_name_delete.";
					
				} else {  // the current column name did not exist
					$process_results = "The custom field name $post_group_name_delete does not exist in the database.<br />";
					$process_results .= "Update failed.<br />";
				}

		} else {
			// it's their first time here.  show them the list and form.
			/* 
			 * delete:  delete using pri_key.
			 * alter table delete <field_name>.constituents_members_fields_int
			 */

			$query_group_modify = "select column_name ";
			$query_group_modify .= "from information_schema.columns ";
			$query_group_modify .= "where table_name = 'constituents_members_fields_int'  ";
			$query_group_modify .= "and column_name not in ('field_id', 'user_id') ";
			$query_group_modify .= "order by column_name;";
			$result_group_modify = pg_query($dbconn, $query_group_modify) or die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($result_group_modify);
			
			// a little text before our while
			$process_results = '<strong>Below is a list of the current fields.</strong><br /><br />';
			
			$i = 1;
			while ($i <= $rows) {
			$arr = pg_fetch_array($result_group_modify);
			$process_results .= "$arr[column_name] <br />";
			$i++;
			}
			
			$process_results .= '<br />';
			$process_results .= '<p>Please type in the current custom column field name that you would like deleted.</p>';
			$process_results .= '<span class="colorme">Warning:  Note that if you delete a custom field name all data associated with that field will be deleted.</span>';
			
			$process_results .= '<form method="post" action="admin_custom_members_fields_int.php?action=delete">';
			$process_results .= '<p>Column to delete: <input type="text" name="group_name_delete" size="50" maxlength = "100" /></p>';
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';
		}
    
    break;
    
    default:  // they end up here if they come to this page with no get or post
	$process_results = 'What would you like to do?';
	$process_results .= '<ul>';
	
	$process_results .= '<li><a href="admin_custom_members_fields_int.php?action=add">Add a new custom interaction field</a></li>';
	
	$process_results .= '<li><a href="admin_custom_members_fields_int.php?action=modify">Modify an existing interaction field</a></li>';
	
	$process_results .= '<li><a href="admin_custom_members_fields_int.php?action=delete">Delete an existing interaction field</a></li>';
	
	$process_results .= '</ul>';
}
    

include("../../header.php");

?>

<div class="features">

<h2>Settings for Constituents Module</h2>
	
<?php echo $process_results; ?>

</div> <!-- close of class features -->

<?php include("../../footer.php");?>
