<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

// this page is for processing active campaigns
//  these are kept in a single table constituents_campaigns_active

# so we have access to module specific inlcude and proper user permissions 
require("./include_mod.php");

if (isset ($_POST['hidden_form_value'])) {
	$post_method=pg_escape_string(trim($_POST['hidden_form_value']));
} else {
	$post_method = null;  // to surpress 'PHP Notice:  Undefined variable'
}

switch ($post_method) {
	
	case 'Add_Group':
	
		// what campaign are we dealing with?
		if (isset ($_POST['hidden_form_value_2'])) {
		$post_campaign_id=pg_escape_string(trim($_POST['hidden_form_value_2']));
		} else {
			// they shouldn't be here without campaign.  error!
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect campaign form value. error 19380");
			exit;
		}
		
		// a little voodoo to get group column names
		$column_array = array(); // used to keep track of the columns we select

		$my_array = select_groups("group_list"); // call to function select_group in include_mod.php
		foreach ($my_array as $v_element) {
			array_push($column_array, $v_element['column_name']);
		}

		$my_array2 = select_groups("group");
		foreach ($my_array2 as $v_element) {
			array_push($column_array, $v_element['column_name']);
		}

		// using a variable variable $$ to set the variable name and value
		foreach ($column_array as $v_element) {
			$$v_element=pg_escape_string(trim($_POST[$v_element]));
			// build an array with column name (key) and value
			$array_add_group[$v_element."='x'"] = $$v_element;
			// remove keys with null vaules
			$new_array_without_nulls = array_filter($array_add_group, 'strlen');
		}
		// make the columns (keys) values
		$new_array_without_nulls = array_keys($new_array_without_nulls);
		// turn the array into a string
		$sql_part = implode(" or " , $new_array_without_nulls);
		
		$add_group_id = "begin;";
		// insert our user_id's
		$add_group_id .= "insert into constituents_campaigns_active (user_id) ";
		$add_group_id .= "select user_id from constituents_members ";
		$add_group_id .= "where $sql_part; "; // using our dynamically generated query
		// add the campaign_id
		$add_group_id .= "update constituents_campaigns_active ";
		$add_group_id .= "set campaign_id = '$post_campaign_id' ";
		$add_group_id .= "where campaign_id is null;";
		// remove duplicates
		$add_group_id .= "DELETE FROM constituents_campaigns_active ";
		$add_group_id .= "WHERE pri_key NOT IN (SELECT 	MAX(dup.pri_key) ";
		$add_group_id .= "FROM constituents_campaigns_active As dup ";
		$add_group_id .= "GROUP BY dup.campaign_id, dup.user_id);";
		$add_group_id .= "commit;";
		
		$do_add_group_id = pg_query($dbconn, $add_group_id) or 
		die('Query failed: ' . pg_last_error());
		
		$process_results = "<p>Success!  You have added your group(s) to campaign $post_campaign_id.</p>";
	
	break;
	
	case 'Add_Individual':
	
		// what campaign are we dealing with?
		if (isset ($_POST['hidden_form_value_2'])) {
		$post_campaign_id=pg_escape_string(trim($_POST['hidden_form_value_2']));
		} else {
			// they shouldn't be here without campaign.  error!
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect campaign form value. error 20331");
			exit;
		}
		
		// what email are we dealing with?
		if (isset ($_POST['email'])) {
		$post_email=pg_escape_string(trim($_POST['email']));
		} else {
			// they shouldn't be here without campaign.  error!
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect email form value. error 11087");
			exit;
		}
		
		$add_individual = "begin;";
		// insert our user_id's
		$add_individual .= "insert into constituents_campaigns_active (user_id) ";
		$add_individual .= "select user_id from constituents_members ";
		$add_individual .= "where (email = '$post_email' or alt_email = '$post_email'); ";
		// add the campaign_id
		$add_individual .= "update constituents_campaigns_active ";
		$add_individual .= "set campaign_id = '$post_campaign_id' ";
		$add_individual .= "where campaign_id is null;";
		// remove duplicates
		$add_individual .= "DELETE FROM constituents_campaigns_active ";
		$add_individual .= "WHERE pri_key NOT IN (SELECT 	MAX(dup.pri_key) ";
		$add_individual .= "FROM constituents_campaigns_active As dup ";
		$add_individual .= "GROUP BY dup.campaign_id, dup.user_id);";
		$add_individual .= "commit;";
		
		$do_add_individual = pg_query($dbconn, $add_individual) or 
		die('Query failed: ' . pg_last_error());
		
		// does this email actually exist in the db? n can't add somebody who isn't there
		$add_individual_check = "select count(*) from constituents_members where (email = '$post_email' or alt_email = '$post_email');";
		$do_add_individual_check = pg_query($dbconn, $add_individual_check) or die('Query failed: ' . pg_last_error());
		
		$do_add_individual_check_results = pg_fetch_result($do_add_individual_check,0,0);
		
		if ($do_add_individual_check_results > 0) {
			$process_results = "<p>Success!  You have added $post_email to campaign $post_campaign_id.</p>";
		} else { 
			$process_results = "<p>Error!  No constituent with the email address $post_email exists in the database.  You may have spelled the address incorrectly or need to create a new constituent.</p>";
		}
	
	break;
	
	case 'Delete_Group':
		// what campaign are we dealing with?
		if (isset ($_POST['hidden_form_value_2'])) {
		$post_campaign_id=pg_escape_string(trim($_POST['hidden_form_value_2']));
		} else {
			// they shouldn't be here without campaign.  error!
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect campaign form value. error 26309");
			exit;
		}
		
		// a little voodoo to get group column names
		$column_array = array(); // used to keep track of the columns we select

		$my_array = select_groups("group_list"); // call to function select_group in include_mod.php
		foreach ($my_array as $v_element) {
			array_push($column_array, $v_element['column_name']);
		}

		$my_array2 = select_groups("group");
		foreach ($my_array2 as $v_element) {
			array_push($column_array, $v_element['column_name']);
		}

		// using a variable variable $$ to set the variable name and value
		foreach ($column_array as $v_element) {
			$$v_element=pg_escape_string(trim($_POST[$v_element]));
			// build an array with column name (key) and value
			$array_add_group[$v_element."='x'"] = $$v_element;
			// remove keys with null vaules
			$new_array_without_nulls = array_filter($array_add_group, 'strlen');
		}
		// make the columns (keys) values
		$new_array_without_nulls = array_keys($new_array_without_nulls);
		// turn the array into a string
		$sql_part = implode(" or " , $new_array_without_nulls);
				
		// delete our user_id's
		$delete_group_id .= "delete from constituents_campaigns_active ";
		$delete_group_id .= "where user_id in ( ";
		$delete_group_id .= "select user_id from constituents_members  ";
		$delete_group_id .= "where $sql_part);"; // using our dynamically generated query
		
		$do_add_group_id = pg_query($dbconn, $delete_group_id) or 
		die('Query failed: ' . pg_last_error());
		
		$process_results = "<p>Success!  You have deleted your group(s) from campaign $post_campaign_id.</p>";
	
	break;
	
	case 'Delete_Individual':
		// what campaign are we dealing with?
		if (isset ($_POST['hidden_form_value_2'])) {
		$post_campaign_id=pg_escape_string(trim($_POST['hidden_form_value_2']));
		} else {
			// they shouldn't be here without campaign.  error!
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect campaign form value. error 21198");
			exit;
		}
		
		// what email are we dealing with?
		if (isset ($_POST['email'])) {
		$post_email=pg_escape_string(trim($_POST['email']));
		} else {
			// they shouldn't be here without campaign.  error!
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect email form value. error 30791");
			exit;
		}
		
		// delete our user_id's
		$delete_individual = "delete from constituents_campaigns_active ";
		$delete_individual .= "where user_id in (";
		$delete_individual .= "select user_id from constituents_members ";
		$delete_individual .= "where (email = '$post_email' or alt_email = '$post_email'));"; 
		
		$do_delete_individual = pg_query($dbconn, $delete_individual) or 
		die('Query failed: ' . pg_last_error());
		
		$process_results = "<p>Success!  You have removed $post_email from campaign $post_campaign_id.</p>";
	
	break;
	
	default:  // no valid hidden_form_value?  send to error page
			// what's my directory minus the document root?
			$i_am_here = str_replace($_SERVER["DOCUMENT_ROOT"], "", (__DIR__));
			// chop off the last two directories to get error path
			$he_is_there = dirname(dirname($i_am_here));
			header("Location: $he_is_there/error.php?error=incorrect form value. error 23127");
		exit;
}

    
include("../../header.php");

?>

<div class="features">

<h2>Settings - Campaigns Process</h2>
	
<?php echo $process_results; ?>

Would you like to return to the <a href="<?php echo $header_dirname; ?>/module/constituents/admin_campaign.php">campaign manager</a>?

</div> <!-- close of class features -->

<?php include("../../footer.php");?>
