<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

// this page is for managing active campaigns
//  these are kept in a single table constituents_campaigns_active

/*
 * $process_results is our output
 * $_POST['method'] = how
 * $_POST['campaign'] = who
*/

# so we have access to module specific inlcude and proper user permissions 
require("./include_mod.php");

if (isset ($_POST['method'])) {
	$post_method=pg_escape_string(trim($_POST['method']));
} else {
	$post_method = null;  // to surpress 'PHP Notice:  Undefined variable'
}

if (isset ($_POST['campaign_id'])) {
	$post_campaign=pg_escape_string(trim($_POST['campaign_id']));
} else {
	$post_campaign = null;  // to surpress 'PHP Notice:  Undefined variable'
}

switch ($post_method) {
	
	// $_POST['method'] = 'Add_Group'
    case 'Add_Group':
		// show them a list of groups to add
		$process_results = "<p>Please select the groups you would like to add to your campaign $post_campaign.  
		Note that <i>lists</i> usually include <i>groups</i>.  Such as if you selected group_list_newsletter 
		you would not have to select group_board_directors as they are already on the mailing list.</p>";
		
		$process_results .= '<form method="post" action="admin_campaign_manager_process.php">';
		$process_results .= '<input name="hidden_form_value" type="hidden" value="Add_Group" />';
		$process_results .= '<input name="hidden_form_value_2" type="hidden" value="'.$post_campaign.'" />';
				
		$process_results .= '<b>Lists</b>:<br />';
		$array_group_list = select_groups("group_list");
		foreach ($array_group_list as $v_element1) {
		//echo "$v_element['column_name'].<br />";
		$process_results .= '<input type="checkbox" name="'.$v_element1['column_name'].'" value="x"/> '.$v_element1['column_name'].'<br />';
	}
		// show them a list of groups to add
		$process_results .= '<b>Groups</b>:<br />';
		$array_group = select_groups("group");
		foreach ($array_group as $v_element2) {
		//echo "$v_element['column_name'].<br />";
		$process_results .= '<input type="checkbox" name="'.$v_element2['column_name'].'" value="x"/> '.$v_element2['column_name'].'<br />';
	}

		$process_results .= '<br />';
		$process_results .= '<p><p><input type="submit" value="Submit"/></p></p></form>';
       
    break;
	
	// $_POST['method'] = 'Add_Individual'
    case 'Add_Individual':
    // show them a search form to enter a user_id or email
		$process_results = "<p>Please enter in the email address of the individual you would like to add to your campaign $post_campaign.</p>";
		$process_results .= '<form method="post" action="admin_campaign_manager_process.php">';
		$process_results .= '<input name="hidden_form_value" type="hidden" value="Add_Individual" />';
		$process_results .= '<input name="hidden_form_value_2" type="hidden" value="'.$post_campaign.'" />';
		
		$process_results .= 'Email: <input type="text" name="email" size="40" MAXLENGTH="40"/>';
		
		$process_results .= '<p><p><input type="submit" value="Submit"/></p></p></form>';
    
    break;
	
	// $_POST['method'] = 'Delete_Group'
    case 'Delete_Group':
    // show them a list of groups to remove
    	$process_results = '<p>Please select the groups you would like to <span class="colorme">remove</span> from your campaign '.$post_campaign.'.</p>';
    	
    	$process_results .= '<p>As an example you may have already added group_list_newsletter to your campaign 
    	and now you want to remove group_board_advisors because you will send them something more 
    	personalized in a different campaign.</p>';
		
		$process_results .= '<form method="post" action="admin_campaign_manager_process.php">';
		$process_results .= '<input name="hidden_form_value" type="hidden" value="Delete_Group" />';
		$process_results .= '<input name="hidden_form_value_2" type="hidden" value="'.$post_campaign.'" />';
		
		$process_results .= '<b>Lists</b>:<br />';
		$array_group_list = select_groups("group_list");
		foreach ($array_group_list as $v_element1) {
		//echo "$v_element['column_name'].<br />";
		$process_results .= '<input type="checkbox" name="'.$v_element1['column_name'].'" value="x"/> '.$v_element1['column_name'].'<br />';
	}
		// show them a list of groups to add
		$process_results .= '<b>Groups</b>:<br />';
		$array_group = select_groups("group");
		foreach ($array_group as $v_element2) {
		//echo "$v_element['column_name'].<br />";
		$process_results .= '<input type="checkbox" name="'.$v_element2['column_name'].'" value="x"/> '.$v_element2['column_name'].'<br />';
	}

		$process_results .= '<br />';
		$process_results .= '<p><p><input type="submit" value="Submit"/></p></p></form>';
    
    break;
	
	// $_POST['method'] = 'Delete_Individual'
    case 'Delete_Individual':
    // show them a search form to enter a user_id or email or offer to display all with check box
		$process_results = '<p>Please enter the email of the person you would like to <span class="colorme">remove</span> from your campaign '.$post_campaign.'.</p>';
		$process_results .= '<form method="post" action="admin_campaign_manager_process.php">';
		$process_results .= '<input name="hidden_form_value" type="hidden" value="Delete_Individual" />';
		$process_results .= '<input name="hidden_form_value_2" type="hidden" value="'.$post_campaign.'" />';
		
		$process_results .= 'Email: <input type="text" name="email" size="40" MAXLENGTH="40"/>';
		
		$process_results .= '<p><p><input type="submit" value="Submit"/></p></p></form>';
    
    break;
	
	// $_POST['Send_Emails'] = 'send'  *creates interactions
    case 'Send_Emails':
    /* 
     * 1.  ask if they are sure
     * 2.  create interaction - remove do not email and deceased see canned reports
     * 3.  create list
     * 4.  inform user of created interactions and output list.
     */
     
		if (isset ($_POST['hidden_form_value_email_output'])) {
			$post_hidden_form_value_email_output=pg_escape_string(trim($_POST['hidden_form_value_email_output']));
			} else {
				$post_hidden_form_value_email_output = null;  // to surpress 'PHP Notice:  Undefined variable'
			}
		
		if ($post_hidden_form_value_email_output == 'do_it') {
			
			// make sure they didn't click the create interactions button twice
			$query_double_click = "select count(*) from constituents_interactions where campaign_id='$post_campaign' ";
			$query_double_click .= "and int_type = 'Asked' and medium = 'Email' and int_date = CURRENT_DATE;";
			$query_double_click_1 = pg_query($dbconn, $query_double_click) or die('Query failed: ' . pg_last_error());
			$query_double_click_2 = pg_fetch_result($query_double_click_1, 0);
			if ($query_double_click_2 > 2) {
				 $process_results = '<p>The interactions you are trying to create already exist.  <span class="colorme">Operation failed.</span></p>';
				 $process_results .= "Where campaign_id is $post_campaign and int_type is Asked and medium is Email and int_date is today, $query_double_click_2 interactions already exist.";
			 } else {
			
				//$process_results = "debugging: $post_campaign , $post_method , $post_hidden_form_value_email_output";
				
				 // if $post_hidden_form_value_email_output == 'do_it' and $post_method is Send_Emails
				 // process action
				 
					$today = date("Ymd");

					// tell the browser what we're about to do
					header("Content-type: application/csv");
					header("Content-Disposition: attachment; filename=$today.email_output.csv");
					header("Pragma: no-cache");
					header("Expires: 0");
					
					// build our list
					$query_select_userid = "select user_id ";
					$query_select_userid .= "from constituents_members ";
					$query_select_userid .= "where user_id in ( ";
						$query_select_userid .= "select user_id ";
						$query_select_userid .= "from constituents_campaigns_active ";
						$query_select_userid .= "where campaign_id = '$post_campaign') ";
					$query_select_userid .= "and (donotemail is null or donotemail = '' or donotemail = ' ') ";
					$query_select_userid .= "and ((email != '' and email != ' ' and email is not null) or (alt_email != '' and alt_email != ' ' and alt_email is not null)) ";
					$query_select_userid .= "and (is_deceased is null or is_deceased = '' or is_deceased = ' ' or is_deceased = 'n');";
					$query_select_userid_1 = pg_query($dbconn, $query_select_userid) or die('Query failed: ' . pg_last_error());

					$my_array3 = pg_fetch_all($query_select_userid_1);

					// i'm having output issues.  using strip_tags, str_replace and trim to help
					$find_new_lines = array("\r\n", "\n", "\r", ",");
					$replace_new_lines = ' ';

					foreach ($my_array3 as $v_element) {
						
								$an_id_num = $v_element['user_id'];
								$the_return=select_alt_choice("$an_id_num"); // using a function in include_mod.php to get preferred contact info
								
							echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[2]['email1'])));  // email
							
						echo "\n";
						
						// create interactions
						$insert_interaction_email = "insert into constituents_interactions ";
						$insert_interaction_email .= "(campaign_id, user_id, int_type, medium, int_date) values ";
						$insert_interaction_email .= "('$post_campaign', '$an_id_num', 'Asked', 'Email', now());";
						$insert_interaction_email_1 = pg_query($dbconn, $insert_interaction_email) or die('Query failed: ' . pg_last_error());
								
						}
				exit;
			}
				
			// else make sure they understand what is about to happen
			} else { // show them the 'are you sure?' page
				 $process_results = "<p>Are you sure that you want to export the email list for $post_campaign?</p>";
				 $process_results .= '<p>Note that this will <span class="colorme">create an interaction</span> (type = asked, medium = email, date = today) for each user_id ';
				 $process_results .= 'and <span class="colorme">export a list</span> suitable for importing into ConstantContact, MailChimp or a similar marketing solution.</p><br />';
				 
				 $process_results .= "<p>Please select the action you wish to take:</p><br />";
				 
				 $process_results .= '<form method="post" action="admin_campaign_manager.php">';  // not to _process.php
				 $process_results .= '<input name="method" type="hidden" value="Send_Emails" />'; // gets us here and not to default form
				 $process_results .= '<input name="campaign_id" type="hidden" value="'.$post_campaign.'" />';
				 $process_results .= '<input name="hidden_form_value_email_output" type="hidden" value="do_it" />';
				 $process_results .= '<p><button name="subject"  type="submit" value="Submit"/>Create interactions and export list</button></p></form>';

				 $process_results .= '<p>or <a href="admin_campaign_manager.php">Cancel action</a><p>';
			}
     
    break;
	
	// $_POST['Print_Labels'] = 'print'  *creates interactions
    case 'Print_Labels':
    /* 
     * 1.  ask if they are sure
     * 2.  create interaction - remove do not email and deceased see canned reports
     * 3.  create list
     * 4.  inform user of created interactions and output list.
     */
     
		if (isset ($_POST['hidden_form_value_email_output'])) {
			$post_hidden_form_value_email_output=pg_escape_string(trim($_POST['hidden_form_value_email_output']));
			} else {
				$post_hidden_form_value_email_output = null;  // to surpress 'PHP Notice:  Undefined variable'
			}
		
		if ($post_hidden_form_value_email_output == 'do_it') {
			
		//$process_results = "debugging: $post_campaign , $post_method , $post_hidden_form_value_email_output";
		
			// make sure they didn't click the create interactions button twice
			$query_double_click = "select count(*) from constituents_interactions where campaign_id='$post_campaign' ";
			$query_double_click .= "and int_type = 'Asked' and medium = 'Letter' and int_date = CURRENT_DATE;";
			$query_double_click_1 = pg_query($dbconn, $query_double_click) or die('Query failed: ' . pg_last_error());
			$query_double_click_2 = pg_fetch_result($query_double_click_1, 0);
			if ($query_double_click_2 > 2) {
				 $process_results = '<p>The interactions you are trying to create already exist.  <span class="colorme">Operation failed.</span></p>';
				 $process_results .= "Where campaign_id is $post_campaign and int_type is Asked and medium is Letter and int_date is today, $query_double_click_2 interactions already exist.";
			 } else {
		
			 // if $post_hidden_form_value_email_output == 'do_it' and $post_method is Send_Emails
			 // process action
			 
				$today = date("Ymd");

				// tell the browser what we're about to do
				header("Content-type: application/csv");
				header("Content-Disposition: attachment; filename=$today.mail_output.csv");
				header("Pragma: no-cache");
				header("Expires: 0");
				
				// build our list
				$query_select_userid = "select user_id, individual_prefix, first_name, middle_name, last_name, display_name, current_employer, organization_name, individual_suffix ";
				$query_select_userid .= "from constituents_members ";
				$query_select_userid .= "where user_id in ( ";
					$query_select_userid .= "select user_id ";
					$query_select_userid .= "from constituents_campaigns_active ";
					$query_select_userid .= "where campaign_id = '$post_campaign')  ";
				$query_select_userid .= "and (donotmail is null or donotmail = '' or donotmail = ' ')  ";
				$query_select_userid .= "and (display_name != '' and display_name != ' ' and display_name is not null) ";
				$query_select_userid .= "and ((zip_code != '' and zip_code != ' ' and zip_code is not null) or (alt_zip_code != '' and alt_zip_code != ' ' and alt_zip_code is not null)) ";
				$query_select_userid .= "and (is_deceased is null or is_deceased = '' or is_deceased = ' ' or is_deceased = 'n');";
				$query_select_userid_1 = pg_query($dbconn, $query_select_userid) or die('Query failed: ' . pg_last_error());

				$my_array3 = pg_fetch_all($query_select_userid_1);

				// i'm having output issues.  using strip_tags, str_replace and trim to help
				$find_new_lines = array("\r\n", "\n", "\r", ",");
				$replace_new_lines = ' ';
				
				// top row
				echo "user_id, individual_prefix, first_name, middle_name, last_name, display_name, current_employer, organization_name, individual_suffix, street_address, supplemental_address_1, supplemental_address_2, city, state1, zip, phone, email, website \n";

				foreach ($my_array3 as $v_element) {
					
					$an_id_num = $v_element['user_id'];
					$the_return=select_alt_choice("$an_id_num"); // using a function in include_mod.php to get preferred contact info
							
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($an_id_num)));
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['individual_prefix'])));
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['first_name'])));
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['middle_name'])));
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['last_name'])));
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['current_employer'])));
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['organization_name'])));
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['individual_suffix'])));
					echo ',';
				
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy0'])));  // addy 1
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy1'])));  // addy 2
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy2'])));  // addy 3
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['city1'])));  // city
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['state1'])));  // state
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['zip1'])));  // zip
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[1]['tele1'])));  // tele
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[2]['email1'])));  // email
					echo ',';
					echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[3]['website1'])));  // website 
						
					echo "\n";
					
					// create interactions
					$insert_interaction_email = "insert into constituents_interactions ";
					$insert_interaction_email .= "(campaign_id, user_id, int_type, medium, int_date) values ";
					$insert_interaction_email .= "('$post_campaign', '$an_id_num', 'Asked', 'Letter', now());";
					$insert_interaction_email_1 = pg_query($dbconn, $insert_interaction_email) or die('Query failed: ' . pg_last_error());
							
					}
					exit;
				}
			// else make sure they understand what is about to happen
			} else { // show them the 'are you sure?' page
				 $process_results = "<p>Are you sure that you want to export the mail list for $post_campaign?</p>";
				 $process_results .= '<p>Note that this will <span class="colorme">create an interaction</span> (type = Asked, medium = Letter, date = today) for each user_id ';
				 $process_results .= 'and <span class="colorme">export a list</span> suitable for printing letters, labels or sending to a bulk mail company.</p>';
				 
				 $process_results .= "<p>Please select the action you wish to take:</p>";
				 
				 $process_results .= '<form method="post" action="admin_campaign_manager.php">';  // not to _process.php
				 $process_results .= '<input name="method" type="hidden" value="Print_Labels" />'; // gets us here and not to default form
				 $process_results .= '<input name="campaign_id" type="hidden" value="'.$post_campaign.'" />';
				 $process_results .= '<input name="hidden_form_value_email_output" type="hidden" value="do_it" />';
				 $process_results .= '<p><button name="subject"  type="submit" value="Submit"/>Create interactions and export list</button></p></form>';

				 $process_results .= '<p>or <a href="admin_campaign_manager.php">Cancel action</a><p>';
			}
     
    break;

    //  $_POST['method'] = 'Export_Campaign'
    case 'Export_Campaign':
		// export as csv
		
		//$today = date("Ymd");
				
		// tell the browser what we're about to do
		header("Content-type: application/csv");
		//header("Content-Disposition: attachment; filename=output.csv");
		header('Content-Disposition: attachment; filename="output.csv"');
		header("Pragma: no-cache");
		header("Expires: 0");
		
		$query_export_campaign = "select cm.user_id, cm.individual_prefix, cm.first_name, cm.middle_name, cm.last_name, ";
		$query_export_campaign .= "cm.display_name, cm.current_employer, cm.organization_name, cm.individual_suffix ";
		$query_export_campaign .= "from constituents_members cm, constituents_campaigns_active cca ";
		$query_export_campaign .= "where (cm.donotmail is null or cm.donotmail = '' or cm.donotmail = ' ') ";
		$query_export_campaign .= "and (cm.user_id = cca.user_id) ";
		$query_export_campaign .= "and (cca.campaign_id = '$post_campaign');";

		$go_query_export_campaign = pg_query($dbconn, $query_export_campaign) or die('Query failed: ' . pg_last_error());

		$my_array4 = pg_fetch_all($go_query_export_campaign);

		// i'm having output issues.  using strip_tags, str_replace and trim to help
		$find_new_lines = array("\r\n", "\n", "\r", ",");
		$replace_new_lines = ' ';

		// top row
		echo "user_id, individual_prefix, first_name, middle_name, last_name, display_name, current_employer, organization_name, individual_suffix, street_address, supplemental_address_1, supplemental_address_2, city, state1, zip, phone, email, website \n";

		foreach ($my_array4 as $v_element) {
			
					$an_id_num = $v_element['user_id'];
					$the_return=select_alt_choice("$an_id_num"); // using a function in include_mod.php to get preferred contact info
					
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($an_id_num)));
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['individual_prefix'])));
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['first_name'])));
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['middle_name'])));
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['last_name'])));
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['display_name'])));
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['current_employer'])));
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['organization_name'])));
			echo ',';
			echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($v_element['individual_suffix'])));
			echo ',';
			
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy0'])));  // addy 1
				echo ',';
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy1'])));  // addy 2
				echo ',';
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['addy2'])));  // addy 3
				echo ',';
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['city1'])));  // city
				echo ',';
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['state1'])));  // state
				echo ',';
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[0]['zip1'])));  // zip
				echo ',';
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[1]['tele1'])));  // tele
				echo ',';
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[2]['email1'])));  // email
				echo ',';
				echo str_replace($find_new_lines, $replace_new_lines, strip_tags(trim($the_return[3]['website1'])));  // website 

			echo "\n";
					
		}
		
		// bottom row.  i use it to let them know more info about the report
		echo "NOTE:  this report is raw and not cleaned up.  is_deceased must be blank or n.";
		exit; // note sure if this is the best way to stop here...
    
    break;
    
    default:  // they end up here if they come to this page with no post
    
    $process_results = 'Here you can manage your campaign.  You will be able to do the following:';
    $process_results .= '<ul>';
    $process_results .= '<li>Add groups.  This will add constituents in this group to your campaign as of this moment in time.  Constituents added to a group via the add new constituent or modify constituent pages will not effect what you have just added into your campaign.</li>';
    $process_results .= '<li>Add individuals.  This is done by email address.</li>';
    $process_results .= '<li>Remove groups.  This will remove constituents in this group from your campaign as of this moment in time.  Constituents removed from a group via the modify constituent page will not effect what you have just removed from your campaign.</li>';
    $process_results .= '<li>Remove individuals.  This is done by email address.</li>';
    $process_results .= '<li>Send email.  <span class="colorme">This will automatically create interactions and output a list.</span></li>';
    $process_results .= '<li>Print labels.  <span class="colorme">This will automatically create interactions and output a list.</span></li>';
    $process_results .= '<li>Export your campaign to CSV.  This will not create interactions.</li>';
    $process_results .= '</ul>';
    
    $process_results .= 'It is assumed that the campaign name has already been created.<br /><br />';
    $process_results .= 'Please select the campaign to manage and the action to take:';
    
    $select_campaign_ids_int = "select campaign_id from constituents_campaigns order by campaign_id;";
	$select_campaign_ids_int_results = pg_query($dbconn, $select_campaign_ids_int) or die('Query failed: ' . pg_last_error());
	$rows = pg_num_rows($select_campaign_ids_int_results);
	
	$process_results .= '<form method="post" action="admin_campaign_manager.php">';
		
	$process_results .= '<select name="campaign_id">';
	
		$i = 1;
		while ($i <= $rows) {
		$arr = pg_fetch_array($select_campaign_ids_int_results);
		$process_results .= '"<option value="';
		$process_results .= $arr["campaign_id"];
		$process_results .= '">';
		$process_results .= $arr["campaign_id"];
		$process_results .= '</option>';
		$i++;
		}
		
	$process_results .= '</select>';
	
	$process_results .= '<select name="method">';
	
		$process_results .= '"<option value="Add_Group">Add Group</option>>';
		$process_results .= '"<option value="Add_Individual">Add Individual</option>>';
		$process_results .= '"<option value="Delete_Group">Delete Group</option>>';
		$process_results .= '"<option value="Delete_Individual">Delete Individual</option>>';
		$process_results .= '"<option value="Send_Emails">Send Emails</option>>';
		$process_results .= '"<option value="Print_Labels">Print Labels</option>>';
		$process_results .= '"<option value="Export_Campaign">Export to CSV</option>>';
		$process_results .= '</select>';

	$process_results .= '<p><p><input type="submit" value="Submit"/></p></p></form>';

} // end of long switch statement
    
include("../../header.php");

?>

<div class="features">

	<h2>Settings - Manage Campaigns</h2>
	
<?php echo $process_results; ?>


</div> <!-- close of class features -->

<?php include("../../footer.php");?>
