<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

// this page is for manipulating campaign_id's

# so we have access to module specific inlcude and proper user permissions 
require("./include_mod.php");

// this page can be used for all campaign administration.
// check why they are here.  action = Add, Modify, Delete or empty
// $_GET = action, $_POST = form values, $process_results is our output

if (isset ($_GET['action'])) {
	$get_action=pg_escape_string(trim($_GET['action']));
} else {
	$get_action = null;  // to surpress 'PHP Notice:  Undefined variable'
}

switch ($get_action) {
    case 'add':
    
		if (isset ($_POST['campaign_name_add'])) {
			// they have already filled out the add new campaign form below.  now we process it
			$post_campaign_name=pg_escape_string(trim($_POST['campaign_name_add']));
			
				// if the description is filled out sanatize it
				if (isset ($_POST['campaign_desc_add'])) {
				$post_campaign_desc=pg_escape_string(trim($_POST['campaign_desc_add']));
				} else {
					$post_campaign_desc = null;  // to surpress 'PHP Notice:  Undefined variable'
				}
						
			// does this campaign already exist?
			$query_campaign_check = "select campaign_id from constituents_campaigns ";
			$query_campaign_check .= "where campaign_id = '$post_campaign_name';";
			$result_campaign_check = pg_query($dbconn, $query_campaign_check) or die('Query failed: ' . pg_last_error());
			
			$rows_campaign_check = pg_num_rows($result_campaign_check);
			
			// quick and dirty check to make sure the campaign_name is not empty
			if (empty($post_campaign_name)) {
				// we can just use the rows_campaign_check which is evaluated below
				$rows_campaign_check = 1;
			}
			
			if ($rows_campaign_check == 1) {
				$process_results = 'Sorry, that campaign name already exists in the database.';
			} else {
				//That campaign name does not exist.  good.
				$query_campaign_alter = "insert into constituents_campaigns (campaign_id, campaign_descrip) ";
				$query_campaign_alter .= "values ('$post_campaign_name', '$post_campaign_desc');";
				$result_campaign_alter = pg_query($dbconn, $query_campaign_alter) or die('Query failed: ' . pg_last_error());
				$process_results = "You have successfully added $post_campaign_name to the database.";
			}	
		
		} else {
			// it's their first time here to add a new campaign.  show them the form.
			$process_results = 'Please add your new campaign name here.  The current naming convention is to use the date in the name.  Such as: <i>20110216 Newsletter</i>.  The description field is not mandatory but can be useful if you want to add an addtional description of your campaign.<br /><br />';
			
			$process_results .= '<form method="post" action="admin_campaign.php?action=add">';
			
			$process_results .= '<p><b>Campaign Name:</b> <input type="text" name="campaign_name_add" size="50" maxlength="50" /></p>';
			$process_results .= '<p><b>Campaign Description:</b> <input type="text" name="campaign_desc_add" size="60" maxlength="60" /></p>';
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';
			}
    break;
        
    case 'modify':
    // modify the name of an existing campaign
	
		if ((!empty ($_POST['campaign_name_current']) && (!empty ($_POST['campaign_name_new'])))) {
			// they have already filled out the modify campaign form.  now we process it
			// sanitize variables
			$post_campaign_name_current=pg_escape_string(trim($_POST['campaign_name_current']));
			$post_campaign_name_new=pg_escape_string(trim($_POST['campaign_name_new']));
			//$post_campaign_descrip_current=pg_escape_string(trim($_POST['campaign_descrip_current']));
			$post_campaign_descrip_new=pg_escape_string(trim($_POST['campaign_descrip_new']));
			
				// lets check if the campaign names are correct
				$query_var_check = "select count(*) from constituents_campaigns where campaign_id = '$post_campaign_name_current'";
				$query_var_check_results = pg_query($dbconn, $query_var_check) or die('Query failed: ' . pg_last_error());
				$does_it_exist=pg_fetch_result($query_var_check_results, 0, 0);
				
				if ($does_it_exist == 0) {
					$process_results = "That current campaign name does not exist.";  // stop
				} else {
					$query_var_check = "select count(*) from constituents_campaigns where campaign_id = '$post_campaign_name_new'";
					$query_var_check_results = pg_query($dbconn, $query_var_check) or die('Query failed: ' . pg_last_error());
					$does_it_exist=pg_fetch_result($query_var_check_results, 0, 0);
					
						if ($does_it_exist != 0) {
							$process_results = "That new campaign name already exists.";  // stop
							} else { // we made it this far so go ahead and do the update
									
								// update constituents_campaigns
								$query_update_campaign = "update constituents_campaigns ";
								$query_update_campaign .= "set  campaign_id = '$post_campaign_name_new', ";
								$query_update_campaign .= "campaign_descrip = '$post_campaign_descrip_new' ";
								$query_update_campaign .= "where campaign_id = '$post_campaign_name_current';";
								$result_update_campaign = pg_query($dbconn, $query_update_campaign) or die('Query failed: ' . pg_last_error());
									
								$process_results = "You have successfully updated $post_campaign_name_current to $post_campaign_name_new.";
								}
							}
		} else {
			
			// it's their first time here.  show them the list of campaigns and form.
			$query_campaign_modify = "select campaign_id, campaign_descrip ";
			$query_campaign_modify .= "from constituents_campaigns order by campaign_id;";
			$result_campaign_modify = pg_query($dbconn, $query_campaign_modify) or die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($result_campaign_modify);
			
			// a little text before our while
			$process_results = '<strong>Below is a list of campaigns.</strong><br />';
			
			$i = 1;
			while ($i <= $rows) {
			$arr = pg_fetch_array($result_campaign_modify);
			$process_results .= "<strong>Name:</strong>  $arr[campaign_id] <br />";
			$process_results .= "<strong>Desc:</strong>  $arr[campaign_descrip] <br />";
			$process_results .= "<br />";
			$i++;
			}
			
			$process_results .= '<p><strong>Please type in the current campaign name and the new campaign name you would like it
			changed to and then click submit.  Both fields <br />are manditory and the current campaign name must 
			be listed exactly as above.</strong></p>';
			$process_results .= '<span class="colorme">Note that this will not change any past interactions.  This will only effect future interactions.</span>';
			
			$process_results .= '<form method="post" action="admin_campaign.php?action=modify">';
			$process_results .= '<p>*Current campaign name: <input type="text" name="campaign_name_current" size="50" maxlength="50" /></p>';
			//$process_results .= '<p>Current campaign description: <input type="text" name="campaign_descrip_current" size="60" /></p>';
			$process_results .= '<p>*New campaign name: <input type="text" name="campaign_name_new" size="50" maxlength="50" /></p>';
			$process_results .= '<p>New campaign description: <input type="text" name="campaign_descrip_new" size="60" maxlength="60" /></p>';
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';
		}
			
    break;
    
    case 'delete':
    
		if ((!empty ($_POST['campaign_name_delete']))) {
			// they have already filled out the delete campaign form.  now we process it
			$post_campaign_name_delete=pg_escape_string(trim($_POST['campaign_name_delete']));
			// lets check if the campaign names are correct
			$query_var_check = "select count(*) from constituents_campaigns where campaign_id = '$post_campaign_name_delete'";
			$query_var_check_results = pg_query($dbconn, $query_var_check) or die('Query failed: ' . pg_last_error());
			$does_it_exist=pg_fetch_result($query_var_check_results, 0, 0);
				
				if ($does_it_exist == 0) {
						$process_results = "That campaign name does not exist.";
					} else {
						// delete the campaign
						$query_delete_campaign = "delete from constituents_campaigns ";
						$query_delete_campaign .= "where campaign_id = '$post_campaign_name_delete';";
						$query_delete_campaign_results = pg_query($dbconn, $query_delete_campaign) or die('Query failed: ' . pg_last_error());
						$process_results = "You have successfully deleted $post_campaign_name_delete.";
					}		
		} else {
			
			// it's their first time here.  show them the list of campaigns and form.
			$query_campaign_modify = "select campaign_id, campaign_descrip ";
			$query_campaign_modify .= "from constituents_campaigns order by campaign_id;";
			$result_campaign_modify = pg_query($dbconn, $query_campaign_modify) or die('Query failed: ' . pg_last_error());
			$rows = pg_num_rows($result_campaign_modify);
			
			// a little text before our while
			$process_results = '<strong>Below is a list of campaigns.</strong><br />';
			
			$i = 1;
			while ($i <= $rows) {
			$arr = pg_fetch_array($result_campaign_modify);
			$process_results .= "<strong>Name:</strong>  $arr[campaign_id] <br />";
			$process_results .= "Desc:  $arr[campaign_descrip] <br />";
			$process_results .= "<br />";
			$i++;
			}
			
			$process_results .= '<p><strong>Please type in the name of the campaign you wish to delete.</strong></p>';
			$process_results .= '<span class="colorme">Note that this will not modify past interactions.  It will merely no longer allow them to be selected for future interactions.</span>';
			
			$process_results .= '<form method="post" action="admin_campaign.php?action=delete">';
			$process_results .= '<p>Campaign to Delete: <input type="text" name="campaign_name_delete" size="50" maxlength="50"/></p>';
			$process_results .= '<p><p><input type="submit" value="Submit"/></p></p>';
			$process_results .= '</form>';
		}
			
    break;
    
    default:  // they end up here if they come to this page with no get
	$process_results = 'What would you like to do?';
	$process_results .= '<ul>';
	
	$process_results .= '<li><a href="admin_campaign.php?action=add">Add a new campaign</a></li>';
	
	$process_results .= '<li><a href="admin_campaign.php?action=modify">Modify an existing campaign</a></li>';
	
	$process_results .= '<li><a href="admin_campaign.php?action=delete">Delete an existing campaign</a></li>';
	
	$process_results .= '<li><a href="admin_campaign_manager.php">Manage a campaign</a></li>';
	
	$process_results .= '</ul>';
}
    


include("../../header.php");

?>

<div class="features">

	<h2>Settings for Constituents Module - Campaigns</h2>
	
<?php echo $process_results; ?>

</div> <!-- close of class features -->

<?php include("../../footer.php");?>
