<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */
/*
 * log_in_out.php is to be used for a central place for logging in
 * and out users.
 * 
 * users can get here two ways:
 * 1.  go directly to log_in_out.php
 * 2.  fill out log in form on index.php
 * 
 * what happens:
 * 1.  if get is 'log_me_out' then log out user.
 * 2.  is session 'is_logged_in' is true return user to front page
 * 3.  if session 'is_logged_in' isn't true show login page
 * 
 * session variables set after logging in:
 * $_SESSION['ses_user_id']
 * $_SESSION['is_logged_in'] = true;
 * $_SESSION['ses_user_name']
 * $_SESSION['ses_user_group_1']
 * $_SESSION['ses_user_group_2']
 * 
 * user permsions are as follows:  (see the account module for more info)
 * column user_group_1, column user_group_2
 * admin, admin  - the system admin account
 * exec, exec  - executive staff
 * user, user_dev - development staff
 * user, user_serv - service staff
 * volunteer, vol_dev - development volunteer
 * volunteer, vol_serv - service volunteer
 * 
 */

session_start();

// this is to just clean up the php warnings for these vars not being set
if (empty($_SESSION['ses_user_group_1'])) {$_SESSION['ses_user_group_1'] = null;}
if (empty($_SESSION['ses_user_group_2'])) {$_SESSION['ses_user_group_2'] = null;}
if (empty($_SESSION['log_me_out'])) {$_SESSION['log_me_out'] = null;}
if (empty($_GET['log_me_out'])) {$_GET['log_me_out'] = ' ';}
if (empty($_SESSION['is_logged_in'])) {$_SESSION['is_logged_in'] = null;}

# step 1
# first lets see if this is a request to log out of system
$log_me_out_now=NULL;
$log_me_out_now=strip_tags($_GET['log_me_out']);
if ($log_me_out_now == 'yes') {
	session_unset();
	# send user to index page
	$host  = $_SERVER['HTTP_HOST'];
	$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	$extra = 'index.php';
	header("Location: http://$host$uri/$extra");
	exit;
}

# step 2 (a)
# see if the user is already logged in.  if yes, send them to index.php 
# if no, show them the login form.
	
// already logged in?  go to index.php you silly person
if (($_SESSION['is_logged_in'] == true)) {
	# send user to index page
	$host  = $_SERVER['HTTP_HOST'];
	$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	$extra = 'index.php';
	header("Location: http://$host$uri/$extra");
	exit;
}

// is user trying to log in?  they want to see the form?
// (is_logged_in isn't set OR doesn't = true) AND post email is null
if ((!isset($_SESSION['is_logged_in'])
    || ($_SESSION['is_logged_in'] !== true)) && (!isset($_POST['email']))) {

	# put this here to avoid modify header error
	include("./header.php");

	// login form here 
	?>

	<div class="features">

	<h2>Login</h2>

	Site members please login.
			  
	<form action="log_in_out.php" method="post">
	<p><b>Email:</b> <input type="text" name="email" /></p>
	<p><b>Password:</b> <input type="password" name="password" /></p>
	<p><input type="submit" value="Login"/></p>
	</form>

	<p></p>

	</div> <!-- close of class features -->

	<?php
	# we've got to stop code execution here since they only want to 
	# see the form.
		include("footer.php");
		exit;
}

# step 2 (b)
# *this is where we check if the password is correct*
# if the user neither had get=yes or wanted to see the log in form
# then the code falls here.  they have filled out form and want to 
# log in.

# we haven't connected to the db yet.  let's include common.php
# we have to do this because we haven't included header.php

@define('MnemeConst', TRUE); // to allow access to include
// define where we are.
define('MAIN_DIR',dirname(__FILE__) . '/');
define('INC_DIR',MAIN_DIR . 'include/');
require_once(INC_DIR . 'common.php');

# remove white space and escape user input
$email=pg_escape_string(strip_tags(trim($_POST['email'])));
$password=pg_escape_string(strip_tags(trim($_POST['password'])));

#
# check to see if user and pass and are populated and exist.
#

// is the email filled in?
if (empty($email)) {
	sleep(3);
	$host  = $_SERVER['HTTP_HOST'];
	$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	$extra = 'error.php';
	header("Location: http://$host$uri/$extra?error=missing email 11976a");
	exit;
}

// is the password filled in?
if (empty($password)) {
	sleep(3);
	$host  = $_SERVER['HTTP_HOST'];
	$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	$extra = 'error.php';
	header("Location: http://$host$uri/$extra?error=missing password 11976b");
	exit;
}

// is this user in the database?  get user_id
$query_pass_check_0 = "select user_id, first_name, user_group_1, user_group_2 from users where email = '$email' and password = crypt('$password',password)";
$query_pass_check_1 = pg_query($dbconn, $query_pass_check_0) or die('Query failed: ' . pg_last_error());

// getting an unable to jump on index error.  lets count rows to avoid
// if the query doesn't return a result send them to the error page
$rows_pass = pg_num_rows($query_pass_check_1);
if ($rows_pass != 1) {
	//sleep(3);
	$host  = $_SERVER['HTTP_HOST'];
	$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	$extra = 'error.php';
	header("Location: http://$host$uri/$extra?error=password_invalid_11976c");
	exit;
}

// password is valid.  we made it this far.  let's fetch the user_id
$query_pass_check_2 = pg_fetch_result($query_pass_check_1, 0, 'user_id');
// and the user permissions
$_SESSION['ses_user_group_1'] = pg_fetch_result($query_pass_check_1, 0, 'user_group_1');
$_SESSION['ses_user_group_2'] = pg_fetch_result($query_pass_check_1, 0, 'user_group_2');

switch ($query_pass_check_2) {
	case NULL:
    # user doesn't exist.  send them to error page.
	sleep(3);
	$host  = $_SERVER['HTTP_HOST'];
	$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	$extra = 'error.php';
	header("Location: http://$host$uri/$extra?error=password_invalid 11976d");
	exit;
		
	break;
	# otherwise user exists.
	#
	# we have a single session cookie (common.php).  for session
	# variables we have ses_user_id, is_logged_in and ses_user_name.
	#
	default:
	# set user id.  useful in future queries
	$_SESSION['ses_user_id'] = $query_pass_check_2;
	# set that they are logged in
	$_SESSION['is_logged_in'] = true;
	# set users name so we can say hello
	$_SESSION['ses_user_name'] = pg_fetch_result($query_pass_check_1, 0, 'first_name');
		
	# insert login time in case in the future we want to purge
	# db of inactive users
	$query_update_login = "UPDATE users SET login_date = 'now' WHERE user_id = '$query_pass_check_2'";
	$do_query_update_login = pg_query($dbconn, $query_update_login)	or die('Query failed: ' . pg_last_error());
	# send user to home page
	$host  = $_SERVER['HTTP_HOST'];
	$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	$extra = 'index.php';
	header("Location: http://$host$uri/$extra");
}

?>
