<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

/*
 * what this script does:
 * 
 * 1.  check if install_schema.sql exists.  if yes continue with install.
 * 		if no abort install.  check if form is filled in.
 * 
 * 2.  verify if the connection information works.
 * 
 * 3.  add the database name and owner to install_schema.sql
 * 		this file is used to build the initial db.  add the host, 
 * 		db name, db owner and password to /include/common.php
 * 
 * 4.  create an administrative account for mneme.
 * 
 * 5.  set correct permissions on files / folders and delete 
 * 		install_schema.sql and install.php
 * 
 */

#
# step 1.  does install_schema.sql exist?
#	these are used as a flag to see if install_step_2.php
#	has already been run.
#

if (file_exists('./install_schema.sql')) {
    // just continue on in script
	} else {
    echo "It appears that install_schema.sql does not exist.";
    exit;
}

# get info from form ready to use
$v_first_name=strip_tags(trim($_POST['first_name']));
$v_last_name=strip_tags(trim($_POST['last_name']));
$v_email=strip_tags(trim($_POST['email']));
$v_admin_password=strip_tags(trim($_POST['admin_password']));
$v_host=strip_tags(trim($_POST['db_host']));
$v_dbname=strip_tags(trim($_POST['db_name']));
$v_user=strip_tags(trim($_POST['db_user']));
$v_password=strip_tags(trim($_POST['db_password']));

/*
// for troubleshooting
echo $v_first_name;
echo '<br />';
echo $v_last_name;
echo '<br />';
echo $v_email;
echo '<br />';
echo $v_admin_password;
echo '<br />';
echo $v_host;
echo '<br />';
echo $v_dbname;
echo '<br />';
echo $v_user;
echo '<br />';
echo $v_password;
echo '<br />';
*/

// is the form all filled in?  if not send them back to install.php
if ((empty($v_first_name)) || (empty($v_last_name)) || (empty($v_email)) 
|| (empty($v_admin_password)) || (empty($v_host)) || (empty($v_dbname)) 
|| (empty($v_user)) || (empty($v_password))) {
	sleep(3);
	$host  = $_SERVER['HTTP_HOST'];
	$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	$extra = 'install.php';
	header("Location: http://$host$uri/$extra");
	exit;
}

#
# 2.  verify if the connection information works.
#

if (pg_connect("host=$v_host dbname=$v_dbname user=$v_user password=$v_password"))
	{
    // just continue on in script
	} else {
    echo "It appears that either the database is not set up correctly 
    or that the connection information is not correct.  Please return 
    install.php";
    exit;
	}

#
# step 3.  str_replace install_schema.sql and /include/common.php
#

// this could actually be done with a single file_put_contents but 
// as we only install once it doesn't matter.
$v_handle = file_get_contents('./install_schema.sql');
$v_dbname_replace = str_replace("the_database_name", $v_dbname, $v_handle);
file_put_contents('./install_schema.sql', $v_dbname_replace);

$v_handle = file_get_contents('./install_schema.sql');
$v_user_replace = str_replace("the_database_owner", $v_user, $v_handle);
file_put_contents('./install_schema.sql', $v_user_replace);

$v_handle = file_get_contents('./include/common.php');
$v_host_replace = str_replace("localhost", $v_host, $v_handle);
file_put_contents('./include/common.php', $v_host_replace);

$v_handle = file_get_contents('./include/common.php');
$v_dbname_replace = str_replace("thedbname", $v_dbname, $v_handle);
file_put_contents('./include/common.php', $v_dbname_replace);

$v_handle = file_get_contents('./include/common.php');
$v_user_replace = str_replace("theuser", $v_user, $v_handle);
file_put_contents('./include/common.php', $v_user_replace);

$v_handle = file_get_contents('./include/common.php');
$v_pass_replace_pass = str_replace("thepass", $v_password, $v_handle);
file_put_contents('./include/common.php', $v_pass_replace_pass);

#
# 4.  create initial database schema and create an administrative 
#		account.
#

$conn = pg_connect("host=$v_host dbname=$v_dbname user=$v_user password=$v_password");

$v_sql_file = file_get_contents('./install_schema.sql');

// set up admin password
$query = "$v_sql_file";
$query .= "INSERT into users (first_name, last_name, user_group_1, user_group_2, email, password) values ('$v_first_name', '$v_last_name', 'admin', 'admin', '$v_email', crypt('$v_admin_password', gen_salt('bf')));";

if (pg_query($conn, $query)) {
    // just continue on in script
	} else {
    echo "There's been a problem executing install_schema.sql";
    exit;
	}

#
# 5.  set correct permissions on files / folders and delete 
#		install_schema.sql and install.php
#

# delete install_schema.sql.  these are used as a
# flag to know if we have run install_step_2.php previously.
#unlink('install.php');
unlink('./install_schema.sql');

// Read and write for owner, read for everybody else
chmod("./include/common.php", 0644);

if (file_exists('./install_schema.sql')) {
    // we probably don't have permission to delete the files
    echo "
    if you did not receive an error the database has been set up correctly 
    but the two following steps need to be taken.
    <p>
    (1)  delete install_schema.sql
    </p>
    (2)  with your favorite text editor fill in the variables in /include/common.php if needed.";
} else {
    echo "if you did not  receive an error the install was probably 
    successful.  try going to the index.php page.
    <p>
    if common.php is unable to connect to the database with your favorite text editor fill in the variables in /include/common.php if needed</p>";
    exit;
}


?>
