<?php
/* ***************************************************************************

    The Mneme Project
    http://theMnemeProject.org/  http://nonprofit-crm.org/
    Copyright (C) 2009 - 2014  Eric Chadbourne
    eric.chadbourne@gmail.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************************** */

include("./header.php");

?>

<div class="center_left">
	<div class="welcome_box">
	<p class="welcome">
<span class="orange">The Mneme Project</span>
<br />
A free constituent relationship management system for nonprofits.
<br /><br />
If you need assistance with this site please contact the IT department.  Thank you.

			</p>
            <a href="<?php echo $header_dirname;?>/about.php" class="read_more">about us</a>          
            </div>  <!-- end welcome_box -->
                
        </div>  <!-- end center_left -->

<?php
// this is to just clean up the php warning for this var not being set
if (empty($_SESSION['ses_user_group_2'])) {
	$_SESSION['ses_user_group_2'] = null;
}

// here we'll check if they are logged in.  if yes show user specific info
if (empty($_SESSION['is_logged_in'])) {
	
	echo '<div class="center_right">';
	echo '<br />';
	echo '<div class="text_box">';
	echo '<form action="log_in_out.php" method="post">';
	echo '<div class="title">Login</div>';
	echo '<div class="login_form_row">';
	echo '<label class="login_label">Email:</label><input type="text" name="email" class="login_input" />';
	echo '</div>';
                            
	echo '<div class="login_form_row">';
	echo '<label class="login_label">Password:</label><input type="password" name="password" class="login_input" />';
	echo '</div>';           
	echo '<input type="image" src="images/login.gif" class="login" />';
	echo '</form>';
	echo '</div>';
	echo '</div>';
	
}

// if they are in the developement dept
if ( $_SESSION['ses_user_group_2'] == 'admin' OR $_SESSION['ses_user_group_2'] == 'exec' 
	OR $_SESSION['ses_user_group_2'] == 'user_dev' OR $_SESSION['ses_user_group_2'] == 'vol_dev' ) {
	
	// here we show information specific to permission level
	$num_constituents = pg_query($dbconn, "select count(*) from constituents_members;") or die('Query failed: ' . pg_last_error());
	$return_num_constituents = pg_fetch_result($num_constituents, 0, 0);

	$num_interactions = pg_query($dbconn, "select count(*) from constituents_interactions;") or die('Query failed: ' . pg_last_error());
	$return_num_interactions = pg_fetch_result($num_interactions, 0, 0);

	$num_campaigns = pg_query($dbconn, "select count(distinct campaign_id) from constituents_interactions;") or die('Query failed: ' . pg_last_error());
	$return_num_campaigns = pg_fetch_result($num_campaigns, 0, 0);

	$num_dollars = pg_query($dbconn, "select sum(amount) from constituents_interactions where int_date > (now() - interval '1 year') and amount_type = 'h';") or die('Query failed: ' . pg_last_error());
	$return_num_dollars = pg_fetch_result($num_dollars, 0, 0);

	echo '<div class="center_right"><br /><div class="text_box"><div class="title">Stats</div>';
		
	echo "<p>";
	echo "Total constituents: $return_num_constituents<br />";
	echo "Total interactions: $return_num_interactions<br />";
	echo "Total campaigns / services: $return_num_campaigns<br />";
	
		if ($_SESSION['ses_user_group_1'] != 'volunteer') {
			echo "Total donations within 12 months: $return_num_dollars<br />";
		}
	
	echo "</p>";
	echo "<br />";
	echo 'You are logged in as <b>' . $_SESSION['ses_user_name'] . '</b>.';
	echo '</div></div>';
	
	/*
	// this is for debugging
	echo "ses_user_id is ".$_SESSION['ses_user_id']."<br />";
	echo "is_logged_in is ".$_SESSION['is_logged_in']."<br />";
	echo "ses_user_name is ".$_SESSION['ses_user_name']."<br />";
	echo "ses_user_group_1 is ".$_SESSION['ses_user_group_1']."<br />";
	echo "ses_user_group_2 is ".$_SESSION['ses_user_group_2']."<br />";
	*
	*/
	
}

// if the are in the service dept
if ( $_SESSION['ses_user_group_2'] == 'user_serv' OR $_SESSION['ses_user_group_2'] == 'vol_serv' ) {

	// here we show information specific to permission level
	$num_constituents = pg_query($dbconn, "select count(*) from constituents_members;") or die('Query failed: ' . pg_last_error());
	$return_num_constituents = pg_fetch_result($num_constituents, 0, 0);

	$num_interactions = pg_query($dbconn, "select count(*) from constituents_interactions;") or die('Query failed: ' . pg_last_error());
	$return_num_interactions = pg_fetch_result($num_interactions, 0, 0);

	$num_campaigns = pg_query($dbconn, "select count(distinct campaign_id) from constituents_interactions;") or die('Query failed: ' . pg_last_error());
	$return_num_campaigns = pg_fetch_result($num_campaigns, 0, 0);

	//$num_dollars = pg_query($dbconn, "select sum(amount) from constituents_interactions where int_date > (now() - interval '1 year') and amount_type = 'h';") or die('Query failed: ' . pg_last_error());
	//$return_num_dollars = pg_fetch_result($num_dollars, 0, 0);

	echo '<div class="center_right"><br /><div class="text_box"><div class="title">Stats</div>';
		
	echo "<p>";
	echo "Total constituents: $return_num_constituents<br />";
	echo "Total interactions: $return_num_interactions<br />";
	echo "Total campaigns / services: $return_num_campaigns<br />";
	
	//	if ($_SESSION['ses_user_group_1'] != 'volunteer') {
	//		echo "Total donations within 12 months: $return_num_dollars<br />";
	//	}
	
	echo "</p>";
	echo "<br />";
	echo 'You are logged in as <b>' . $_SESSION['ses_user_name'] . '</b>.';
	echo '</div></div>';
}

?>

<?php

// here we will display charts.  this is using the pChart module
// only show to admin, exec, and dev
if ( $_SESSION['ses_user_group_2'] == 'admin' OR $_SESSION['ses_user_group_2'] == 'exec' 
	OR $_SESSION['ses_user_group_2'] == 'user_dev' ) {
		
		echo '
		<img class="displayed" src="./module/pChart/mneme_home/donations_1_year.php">
		';
	}
?>

<?php include("./footer.php");?>
