/****************************************************************************
** Copyright (C) 2006  Xavier Cremaschi (omega.xavier@gmail.com)
** This file is part of teXswitcher.
** teXswitcher is a LaTeX document modifier.
**
** teXswitcher is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program; if not, write to the Free Software Foundation, Inc.,
** 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
****************************************************************************/


#ifndef _PARSER_H_
#define _PARSER_H_

#include <sstream>
#include <map>
using namespace std;

class Node;

/** Parser used by the Node class to construct a tree from a string */
class Parser {
    private:
        static string::size_type find_next_keyword_position(string, string::size_type);
        static Node*             find_good_node(Node*, int);

    public:
        static Node* parse(string&);
        static string extract_document_class(string);
};

#endif
