/****************************************************************************
** Copyright (C) 2006  Xavier Cremaschi (omega.xavier@gmail.com)
** This file is part of teXswitcher.
** teXswitcher is a LaTeX document modifier.
**
** teXswitcher is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program; if not, write to the Free Software Foundation, Inc.,
** 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
****************************************************************************/


#ifndef _NODE_H_
#define _NODE_H_

#include <vector>
#include <string>
using namespace std;

class Node {
    private:
        Node* father;
        vector<Node*> sons;
        string body;
        string footer;

        int     get_index_of_son    (const Node*)     const;

    public:
        Node(string);
        ~Node();


        /*************
         * structure *
         *************/
        void    add_son                         (Node*);
        bool    has_son                         (void)      const;
        void    remove_son                      (const Node*);
        Node*   get_son                         (int)       const;
        Node*   get_parent                      (void)      const;
        int     get_nb_of_nodes                 (void)      const;
        int     get_sons_lowest_keyword_value   (void)      const;
        int     get_sons_biggest_keyword_value  (void)      const;
        int     get_number                      (void)      const;

        /********
         * data *
         ********/

        // serialization
        string  to_string(void)      const;
        static  Node* from_string(string);

        string  get_keyword         (void)      const;
        int     get_keyword_value   (void)      const;
        void    change_keyword      (int, bool);
        string  get_name            (void)      const;
        void    set_footer          (string);

};

#endif
