/****************************************************************************
** Copyright (C) 2006  Xavier Cremaschi (omega.xavier@gmail.com)
** This file is part of teXswitcher.
** teXswitcher is a LaTeX document modifier.
**
** teXswitcher is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program; if not, write to the Free Software Foundation, Inc.,
** 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
****************************************************************************/


#ifndef _KEYWORDSET_H_
#define _KEYWORDSET_H_

#include <iostream>
using namespace std;

/** 
 * you must implement this interface to use your own set of keywords in Keyword
 * class
 * */
class KeywordSet {
    protected :
        string* KEYWORD;
    public:
        virtual ~KeywordSet() { 
            if (this->KEYWORD != NULL) {
                delete[] this->KEYWORD;
                this->KEYWORD = NULL;
            }
        }

        // the size of KEYWORD array
        virtual int get_nb_of_keywords(void) = 0;





        // the keyword associated to the numerical value given by argument
        string get_keyword(int value) {
            return this->KEYWORD[value];
        }

        string get_latex_document_first_keyword(void) {
            return "\\documentclass";
        }
        string get_latex_document_last_keyword(void) {
            return "\\end{document}";
        }

        // return the value of a keyword
        int get_value(string s) {
            for (int i = 0 ; i < this->get_nb_of_keywords() ; i++) {
                if (s == this->KEYWORD[i]) {
                    return i;
                }
            }

            // if keyword not found, maybe we search the value of the root of
            // the document (\documentclass)
            string::size_type pos = s.find(this->get_latex_document_first_keyword());
            if (pos != string::npos) {
                return this->get_max_value(); // maximal priority
            }
            return -1;
        }

        int get_min_value(void) {
            return 0;
        }

        int get_max_value(void) {
            return this->get_nb_of_keywords();
        }
};
#endif
